/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.log;

import org.apache.camel.Component;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.log.LogProducer;
import org.apache.camel.impl.ProcessorEndpoint;
import org.apache.camel.processor.CamelLogProcessor;
import org.apache.camel.processor.DefaultExchangeFormatter;
import org.apache.camel.processor.DefaultMaskingFormatter;
import org.apache.camel.processor.ThroughputLogger;
import org.apache.camel.spi.ExchangeFormatter;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.MaskingFormatter;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.util.CamelLogger;
import org.apache.camel.util.ServiceHelper;
import org.slf4j.Logger;

@UriEndpoint(firstVersion="1.1.0", scheme="log", title="Log", syntax="log:loggerName", producerOnly=true, label="core,monitoring")
public class LogEndpoint
extends ProcessorEndpoint {
    private volatile Processor logger;
    private Logger providedLogger;
    private ExchangeFormatter localFormatter;
    @UriPath(description="Name of the logging category to use")
    @Metadata(required="true")
    private String loggerName;
    @UriParam(defaultValue="INFO", enums="ERROR,WARN,INFO,DEBUG,TRACE,OFF")
    private String level;
    @UriParam
    private String marker;
    @UriParam
    private Integer groupSize;
    @UriParam
    private Long groupInterval;
    @UriParam(defaultValue="true")
    private Boolean groupActiveOnly;
    @UriParam
    private Long groupDelay;
    @UriParam(label="advanced")
    private DefaultExchangeFormatter exchangeFormatter;
    @UriParam
    private Boolean logMask;

    public LogEndpoint() {
    }

    public LogEndpoint(String endpointUri, Component component) {
        super(endpointUri, component);
    }

    public LogEndpoint(String endpointUri, Component component, Processor logger) {
        super(endpointUri, component);
        this.setLogger(logger);
    }

    @Override
    protected void doStart() throws Exception {
        if (this.logger == null) {
            this.logger = this.createLogger();
        }
        ServiceHelper.startService(this.logger);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopService(this.logger);
    }

    public void setLogger(Processor logger) {
        this.logger = logger;
        this.setProcessor(this.logger);
    }

    public Processor getLogger() {
        return this.logger;
    }

    @Override
    public Producer createProducer() throws Exception {
        if (this.logger == null) {
            this.logger = this.createLogger();
        }
        ServiceHelper.startService(this.logger);
        return new LogProducer(this, this.logger);
    }

    @Override
    protected String createEndpointUri() {
        return "log:" + this.logger.toString();
    }

    protected Processor createLogger() throws Exception {
        IdAware answer;
        LoggingLevel loggingLevel = LoggingLevel.INFO;
        if (this.level != null) {
            loggingLevel = LoggingLevel.valueOf(this.level);
        }
        CamelLogger camelLogger = this.providedLogger == null ? new CamelLogger(this.loggerName, loggingLevel, this.getMarker()) : new CamelLogger(this.providedLogger, loggingLevel, this.getMarker());
        if (this.getGroupSize() != null) {
            answer = new ThroughputLogger(camelLogger, this.getGroupSize());
        } else if (this.getGroupInterval() != null) {
            Boolean groupActiveOnly = this.getGroupActiveOnly() != null ? this.getGroupActiveOnly() : Boolean.TRUE;
            Long groupDelay = this.getGroupDelay();
            answer = new ThroughputLogger(camelLogger, this.getCamelContext(), this.getGroupInterval(), groupDelay, groupActiveOnly);
        } else {
            answer = new CamelLogProcessor(camelLogger, this.localFormatter, this.getMaskingFormatter(), this.getCamelContext().getLogListeners());
        }
        this.setProcessor((Processor)((Object)answer));
        return answer;
    }

    private MaskingFormatter getMaskingFormatter() {
        if ((this.logMask != null ? this.logMask : this.getCamelContext().isLogMask()).booleanValue()) {
            MaskingFormatter formatter = this.getCamelContext().getRegistry().lookupByNameAndType("CamelCustomLogMask", MaskingFormatter.class);
            if (formatter == null) {
                formatter = new DefaultMaskingFormatter();
            }
            return formatter;
        }
        return null;
    }

    public String getLevel() {
        return this.level;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    public String getMarker() {
        return this.marker;
    }

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public Integer getGroupSize() {
        return this.groupSize;
    }

    public void setGroupSize(Integer groupSize) {
        this.groupSize = groupSize;
    }

    public Long getGroupInterval() {
        return this.groupInterval;
    }

    public void setGroupInterval(Long groupInterval) {
        this.groupInterval = groupInterval;
    }

    public Boolean getGroupActiveOnly() {
        return this.groupActiveOnly;
    }

    public void setGroupActiveOnly(Boolean groupActiveOnly) {
        this.groupActiveOnly = groupActiveOnly;
    }

    public Long getGroupDelay() {
        return this.groupDelay;
    }

    public void setGroupDelay(Long groupDelay) {
        this.groupDelay = groupDelay;
    }

    public ExchangeFormatter getLocalFormatter() {
        return this.localFormatter;
    }

    public void setLocalFormatter(ExchangeFormatter localFormatter) {
        this.localFormatter = localFormatter;
    }

    public Logger getProvidedLogger() {
        return this.providedLogger;
    }

    public void setProvidedLogger(Logger providedLogger) {
        this.providedLogger = providedLogger;
    }

    public String getLoggerName() {
        return this.loggerName;
    }

    public void setLoggerName(String loggerName) {
        this.loggerName = loggerName;
    }

    public Boolean getLogMask() {
        return this.logMask;
    }

    public void setLogMask(Boolean logMask) {
        this.logMask = logMask;
    }
}

