/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.services.impl;

import java.util.LinkedList;
import org.apache.unomi.api.Metadata;
import org.apache.unomi.api.MetadataItem;
import org.apache.unomi.api.PartialList;
import org.apache.unomi.api.query.Query;
import org.apache.unomi.api.services.DefinitionsService;
import org.apache.unomi.persistence.spi.PersistenceService;

public abstract class AbstractServiceImpl {
    protected PersistenceService persistenceService;
    protected DefinitionsService definitionsService;

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    public void setDefinitionsService(DefinitionsService definitionsService) {
        this.definitionsService = definitionsService;
    }

    protected <T extends MetadataItem> PartialList<Metadata> getMetadatas(int offset, int size, String sortBy, Class<T> clazz) {
        PartialList items = this.persistenceService.getAllItems(clazz, offset, size, sortBy);
        LinkedList<Metadata> details = new LinkedList<Metadata>();
        for (MetadataItem definition : items.getList()) {
            details.add(definition.getMetadata());
        }
        return new PartialList(details, items.getOffset(), items.getPageSize(), items.getTotalSize(), items.getTotalSizeRelation());
    }

    protected <T extends MetadataItem> PartialList<Metadata> getMetadatas(Query query, Class<T> clazz) {
        if (query.isForceRefresh()) {
            this.persistenceService.refresh();
        }
        this.definitionsService.resolveConditionType(query.getCondition());
        PartialList items = this.persistenceService.query(query.getCondition(), query.getSortby(), clazz, query.getOffset(), query.getLimit());
        LinkedList<Metadata> details = new LinkedList<Metadata>();
        for (MetadataItem definition : items.getList()) {
            details.add(definition.getMetadata());
        }
        return new PartialList(details, items.getOffset(), items.getPageSize(), items.getTotalSize(), items.getTotalSizeRelation());
    }
}

