/*
 * Decompiled with CFR 0.152.
 */
package nonapi.io.github.classgraph.classpath;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import nonapi.io.github.classgraph.utils.LogNode;
import nonapi.io.github.classgraph.utils.VersionFinder;

class CallStackReader {
    CallStackReader() {
    }

    private static Class<?>[] getCallStackViaStackWalker(LogNode log) throws Exception {
        Class<?> consumerClass = Class.forName("java.util.function.Consumer");
        final ArrayList stackFrameClasses = new ArrayList();
        Class<?> stackWalkerOptionClass = Class.forName("java.lang.StackWalker$Option");
        Object RETAIN_CLASS_REFERENCE = Class.forName("java.lang.Enum").getMethod("valueOf", Class.class, String.class).invoke(null, stackWalkerOptionClass, "RETAIN_CLASS_REFERENCE");
        Class<?> stackWalkerClass = Class.forName("java.lang.StackWalker");
        Object stackWalkerInstance = stackWalkerClass.getMethod("getInstance", stackWalkerOptionClass).invoke(null, RETAIN_CLASS_REFERENCE);
        final Method stackFrameGetDeclaringClassMethod = Class.forName("java.lang.StackWalker$StackFrame").getMethod("getDeclaringClass", new Class[0]);
        stackWalkerClass.getMethod("forEach", consumerClass).invoke(stackWalkerInstance, Proxy.newProxyInstance(consumerClass.getClassLoader(), new Class[]{consumerClass}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Class declaringClass = (Class)stackFrameGetDeclaringClassMethod.invoke(args[0], new Object[0]);
                stackFrameClasses.add(declaringClass);
                return null;
            }
        }));
        return stackFrameClasses.toArray(new Class[0]);
    }

    private static Class<?>[] getCallStackViaSecurityManager(LogNode log) {
        try {
            return new CallerResolver().getClassContext();
        }
        catch (Throwable e) {
            if (log != null) {
                log.log("Exception while trying to obtain call stack via SecurityManager", e);
            }
            return null;
        }
    }

    static Class<?>[] getClassContext(final LogNode log) {
        if (VersionFinder.JAVA_MAJOR_VERSION >= 9) {
            try {
                return AccessController.doPrivileged(new PrivilegedAction<Class<?>[]>(){

                    @Override
                    public Class<?>[] run() {
                        try {
                            return CallStackReader.getCallStackViaStackWalker(log);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        try {
            return AccessController.doPrivileged(new PrivilegedAction<Class<?>[]>(){

                @Override
                public Class<?>[] run() {
                    return CallStackReader.getCallStackViaSecurityManager(log);
                }
            });
        }
        catch (Throwable throwable) {
            try {
                throw new Exception();
            }
            catch (Exception e) {
                ArrayList classes = new ArrayList();
                for (StackTraceElement elt : e.getStackTrace()) {
                    try {
                        classes.add(Class.forName(elt.getClassName()));
                    }
                    catch (Throwable throwable2) {
                        // empty catch block
                    }
                }
                if (classes.size() > 0) {
                    return classes.toArray(new Class[0]);
                }
                return new Class[]{CallStackReader.class};
            }
        }
    }

    private static final class CallerResolver
    extends SecurityManager {
        private CallerResolver() {
        }

        @Override
        protected Class<?>[] getClassContext() {
            return super.getClassContext();
        }
    }
}

