/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.ref;

import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.IsSingleton;
import org.apache.camel.Predicate;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.spi.Language;
import org.apache.camel.support.ExpressionAdapter;
import org.apache.camel.util.ExpressionToPredicateAdapter;
import org.apache.camel.util.PredicateToExpressionAdapter;

public class RefLanguage
implements Language,
IsSingleton {
    public static Expression ref(Object value) {
        String ref = value.toString();
        return ExpressionBuilder.refExpression(ref);
    }

    @Override
    public Predicate createPredicate(String expression) {
        return ExpressionToPredicateAdapter.toPredicate(this.createExpression(expression));
    }

    @Override
    public Expression createExpression(final String expression) {
        final Expression exp = RefLanguage.ref(expression);
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                Expression target = null;
                Object lookup = exp.evaluate(exchange, Object.class);
                if (lookup != null && lookup instanceof Expression) {
                    target = (Expression)lookup;
                } else if (lookup != null && lookup instanceof Predicate) {
                    target = PredicateToExpressionAdapter.toExpression((Predicate)lookup);
                }
                if (target != null) {
                    return target.evaluate(exchange, Object.class);
                }
                throw new IllegalArgumentException("Cannot find expression or predicate in registry with ref: " + expression);
            }

            public String toString() {
                return exp.toString();
            }
        };
    }

    @Override
    public boolean isSingleton() {
        return true;
    }
}

