/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.config;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.QueryCacheConfigBuilderHelper;
import com.hazelcast.config.DomConfigHelper;
import com.hazelcast.config.EntryListenerConfig;
import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.MapIndexConfig;
import com.hazelcast.config.QueryCacheConfig;
import com.hazelcast.util.StringUtil;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

abstract class AbstractQueryCacheConfigBuilderHelper
implements QueryCacheConfigBuilderHelper {
    private final boolean domLevel3;

    protected AbstractQueryCacheConfigBuilderHelper(boolean domLevel3) {
        this.domLevel3 = domLevel3;
    }

    protected String getTextContent(Node node) {
        return DomConfigHelper.getTextContent(node, this.domLevel3);
    }

    protected void populateQueryCacheConfig(QueryCacheConfig queryCacheConfig, Node childNode, String textContent, String nodeName) {
        if ("entry-listeners".equals(nodeName)) {
            this.handleEntryListeners(queryCacheConfig, childNode);
        } else if ("include-value".equals(nodeName)) {
            boolean includeValue = DomConfigHelper.getBooleanValue(textContent);
            queryCacheConfig.setIncludeValue(includeValue);
        } else if ("batch-size".equals(nodeName)) {
            int batchSize = DomConfigHelper.getIntegerValue("batch-size", textContent.trim());
            queryCacheConfig.setBatchSize(batchSize);
        } else if ("buffer-size".equals(nodeName)) {
            int bufferSize = DomConfigHelper.getIntegerValue("buffer-size", textContent.trim());
            queryCacheConfig.setBufferSize(bufferSize);
        } else if ("delay-seconds".equals(nodeName)) {
            int delaySeconds = DomConfigHelper.getIntegerValue("delay-seconds", textContent.trim());
            queryCacheConfig.setDelaySeconds(delaySeconds);
        } else if ("in-memory-format".equals(nodeName)) {
            String value = textContent.trim();
            queryCacheConfig.setInMemoryFormat(InMemoryFormat.valueOf(StringUtil.upperCaseInternal(value)));
        } else if ("coalesce".equals(nodeName)) {
            boolean coalesce = DomConfigHelper.getBooleanValue(textContent);
            queryCacheConfig.setCoalesce(coalesce);
        } else if ("populate".equals(nodeName)) {
            boolean populate = DomConfigHelper.getBooleanValue(textContent);
            queryCacheConfig.setPopulate(populate);
        } else if ("indexes".equals(nodeName)) {
            this.queryCacheIndexesHandle(childNode, queryCacheConfig);
        } else if ("predicate".equals(nodeName)) {
            this.queryCachePredicateHandler(childNode, queryCacheConfig);
        } else if ("eviction".equals(nodeName)) {
            queryCacheConfig.setEvictionConfig(this.getEvictionConfig(childNode));
        }
    }

    private EvictionConfig getEvictionConfig(Node node) {
        EvictionConfig evictionConfig = new EvictionConfig();
        Node size = node.getAttributes().getNamedItem("size");
        Node maxSizePolicy = node.getAttributes().getNamedItem("max-size-policy");
        Node evictionPolicy = node.getAttributes().getNamedItem("eviction-policy");
        Node comparatorClassName = node.getAttributes().getNamedItem("comparator-class-name");
        if (size != null) {
            evictionConfig.setSize(Integer.parseInt(this.getTextContent(size)));
        }
        if (maxSizePolicy != null) {
            evictionConfig.setMaximumSizePolicy(EvictionConfig.MaxSizePolicy.valueOf(StringUtil.upperCaseInternal(this.getTextContent(maxSizePolicy))));
        }
        if (evictionPolicy != null) {
            evictionConfig.setEvictionPolicy(EvictionPolicy.valueOf(StringUtil.upperCaseInternal(this.getTextContent(evictionPolicy))));
        }
        if (comparatorClassName != null) {
            evictionConfig.setComparatorClassName(this.getTextContent(comparatorClassName));
        }
        return evictionConfig;
    }

    protected abstract String getCacheName(Node var1);

    protected void handleQueryCacheNode(ClientConfig clientConfig, Node queryCacheNode) {
        NamedNodeMap attrs = queryCacheNode.getAttributes();
        String cacheName = this.getCacheName(queryCacheNode);
        String mapName = this.getCacheMapName(attrs);
        QueryCacheConfig queryCacheConfig = new QueryCacheConfig(cacheName);
        for (Node childNode : DomConfigHelper.childElements(queryCacheNode)) {
            String textContent = this.getTextContent(childNode);
            String nodeName = DomConfigHelper.cleanNodeName(childNode);
            this.populateQueryCacheConfig(queryCacheConfig, childNode, textContent, nodeName);
        }
        clientConfig.addQueryCacheConfig(mapName, queryCacheConfig);
    }

    protected abstract String getCacheMapName(NamedNodeMap var1);

    protected abstract void handleEntryListeners(QueryCacheConfig var1, Node var2);

    protected void handleEntryListenerNode(QueryCacheConfig queryCacheConfig, Node listenerNode) {
        NamedNodeMap listenerNodeAttributes = listenerNode.getAttributes();
        boolean incValue = DomConfigHelper.getBooleanValue(this.getTextContent(listenerNodeAttributes.getNamedItem("include-value")));
        boolean local = DomConfigHelper.getBooleanValue(this.getTextContent(listenerNodeAttributes.getNamedItem("local")));
        String listenerClass = this.getTextContent(listenerNode);
        queryCacheConfig.addEntryListenerConfig(new EntryListenerConfig(listenerClass, local, incValue));
    }

    protected abstract void queryCachePredicateHandler(Node var1, QueryCacheConfig var2);

    protected abstract void queryCacheIndexesHandle(Node var1, QueryCacheConfig var2);

    protected void handleIndexNode(QueryCacheConfig queryCacheConfig, Node indexNode) {
        NamedNodeMap attrs = indexNode.getAttributes();
        boolean ordered = DomConfigHelper.getBooleanValue(this.getTextContent(attrs.getNamedItem("ordered")));
        String attribute = this.getTextContent(indexNode);
        queryCacheConfig.addIndexConfig(new MapIndexConfig(attribute, ordered));
    }
}

