/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.core.osgi;

import java.util.Collection;
import java.util.Iterator;
import org.apache.camel.CamelContext;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatFactory;
import org.apache.camel.spi.DataFormatResolver;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ResolverHelper;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsgiDataFormatResolver
implements DataFormatResolver {
    private static final Logger LOG = LoggerFactory.getLogger(OsgiDataFormatResolver.class);
    private final BundleContext bundleContext;

    public OsgiDataFormatResolver(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public DataFormat resolveDataFormat(String name, CamelContext context) {
        DataFormat dataFormat = ResolverHelper.lookupDataFormatInRegistryWithFallback((CamelContext)context, (String)name);
        if (dataFormat == null) {
            dataFormat = this.getDataFormat(name, context, false);
        }
        if (dataFormat == null) {
            dataFormat = this.createDataFormat(name, context);
        }
        return dataFormat;
    }

    public DataFormat createDataFormat(String name, CamelContext context) {
        DataFormat dataFormat = null;
        DataFormatFactory dataFormatFactory = ResolverHelper.lookupDataFormatFactoryInRegistryWithFallback((CamelContext)context, (String)name);
        if (dataFormatFactory != null) {
            dataFormat = dataFormatFactory.newInstance();
        }
        if (dataFormat == null) {
            dataFormat = this.getDataFormat(name, context, true);
        }
        return dataFormat;
    }

    private DataFormat getDataFormat(String name, CamelContext context, boolean create) {
        LOG.trace("Finding DataFormat: {}", (Object)name);
        try {
            Iterator iterator;
            Collection refs = this.bundleContext.getServiceReferences(DataFormatResolver.class, "(dataformat=" + name + ")");
            if (refs != null && (iterator = refs.iterator()).hasNext()) {
                ServiceReference ref = (ServiceReference)iterator.next();
                return create ? ((DataFormatResolver)this.bundleContext.getService(ref)).createDataFormat(name, context) : ((DataFormatResolver)this.bundleContext.getService(ref)).resolveDataFormat(name, context);
            }
            return null;
        }
        catch (InvalidSyntaxException e) {
            throw ObjectHelper.wrapRuntimeCamelException((Throwable)e);
        }
    }
}

