/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.make;

import aQute.bnd.build.ProjectBuilder;
import aQute.bnd.osgi.Builder;
import aQute.bnd.osgi.Constants;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.JarResource;
import aQute.bnd.osgi.Processor;
import aQute.bnd.osgi.Resource;
import aQute.bnd.service.MakePlugin;
import java.io.File;
import java.util.Map;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MakeBnd
implements MakePlugin,
Constants {
    static final Pattern JARFILE = Pattern.compile("(.+)\\.(jar|ipa)");

    @Override
    public Resource make(Builder builder, String destination, Map<String, String> argumentsOnMake) throws Exception {
        String type = argumentsOnMake.get("type");
        if (!"bnd".equals(type)) {
            return null;
        }
        String recipe = argumentsOnMake.get("recipe");
        if (recipe == null) {
            builder.error("No recipe specified on a make instruction for " + destination, new Object[0]);
            return null;
        }
        File bndfile = builder.getFile(recipe);
        if (bndfile.isFile()) {
            Builder bchild = builder.getSubBuilder();
            bchild.removeBundleSpecificHeaders();
            bchild.setProperty("Include-Resource", "");
            bchild.setProperty("-includeresource", "");
            bchild.setProperties(bndfile, builder.getBase());
            Jar jar = bchild.build();
            Jar dot = builder.getTarget();
            if (builder.hasSources()) {
                for (String key : jar.getResources().keySet()) {
                    if (!key.startsWith("OSGI-OPT/src")) continue;
                    dot.putResource(key, jar.getResource(key));
                }
            }
            builder.getInfo(bchild, bndfile.getName() + ": ");
            String debug = bchild.getProperty("-debug");
            if (Processor.isTrue(debug) && builder instanceof ProjectBuilder) {
                ProjectBuilder pb = (ProjectBuilder)builder;
                File target = pb.getProject().getTarget();
                String bsn = bchild.getBsn();
                File output = new File(target, bsn + ".jar");
                jar.write(output);
                pb.getProject().getWorkspace().changedFile(output);
            }
            return new JarResource(jar);
        }
        return null;
    }
}

