/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.client;

import java.lang.reflect.InvocationHandler;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.common.util.ProxyHelper;
import org.apache.cxf.feature.Feature;
import org.apache.cxf.jaxrs.client.Client;
import org.apache.cxf.jaxrs.client.ClientState;
import org.apache.cxf.jaxrs.client.InvocationHandlerAware;
import org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean;
import org.apache.cxf.jaxrs.client.ThreadLocalClientState;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.model.UserResource;

public final class JAXRSClientFactory {
    private JAXRSClientFactory() {
    }

    public static <T> T create(String baseAddress, Class<T> cls) {
        return JAXRSClientFactory.create(URI.create(baseAddress), cls);
    }

    public static <T> T create(String baseAddress, Class<T> cls, ClassLoader loader) {
        JAXRSClientFactoryBean bean = JAXRSClientFactory.getBean(baseAddress, cls, null);
        bean.setClassLoader(loader);
        return bean.create(cls, new Object[0]);
    }

    public static <T> T create(URI baseURI, Class<T> cls) {
        return JAXRSClientFactory.create(baseURI, cls, false);
    }

    public static <T> T create(URI baseURI, Class<T> cls, boolean inheritHeaders) {
        JAXRSClientFactoryBean bean = JAXRSClientFactory.getBean(baseURI.toString(), cls, null);
        bean.setInheritHeaders(inheritHeaders);
        return bean.create(cls, new Object[0]);
    }

    public static <T> T create(String baseAddress, Class<T> cls, Map<String, Object> properties) {
        JAXRSClientFactoryBean bean = JAXRSClientFactory.getBean(baseAddress, cls, null);
        bean.setProperties(properties);
        return bean.create(cls, new Object[0]);
    }

    public static <T> T create(String baseAddress, Class<T> cls, String configLocation) {
        JAXRSClientFactoryBean bean = JAXRSClientFactory.getBean(baseAddress, cls, configLocation);
        return bean.create(cls, new Object[0]);
    }

    public static <T> T create(String baseAddress, Class<T> cls, String configLocation, Object ... varValues) {
        JAXRSClientFactoryBean bean = JAXRSClientFactory.getBean(baseAddress, cls, configLocation);
        return bean.create(cls, varValues);
    }

    public static <T> T create(String baseAddress, Class<T> cls, List<?> providers) {
        return JAXRSClientFactory.create(baseAddress, cls, providers, null);
    }

    public static <T> T create(String baseAddress, Class<T> cls, List<?> providers, boolean threadSafe) {
        return JAXRSClientFactory.create(baseAddress, cls, providers, Collections.emptyMap(), threadSafe);
    }

    public static <T> T create(String baseAddress, Class<T> cls, List<?> providers, Map<String, Object> properties, boolean threadSafe) {
        JAXRSClientFactoryBean bean = JAXRSClientFactory.getBean(baseAddress, cls, null);
        bean.setProviders(providers);
        bean.setProperties(properties);
        if (threadSafe) {
            bean.setInitialState(new ThreadLocalClientState(baseAddress, properties));
        }
        return bean.create(cls, new Object[0]);
    }

    public static <T> T create(String baseAddress, Class<T> cls, List<?> providers, long timeToKeepState) {
        JAXRSClientFactoryBean bean = JAXRSClientFactory.getBean(baseAddress, cls, null);
        bean.setProviders(providers);
        bean.setInitialState(new ThreadLocalClientState(baseAddress, timeToKeepState));
        return bean.create(cls, new Object[0]);
    }

    public static <T> T create(String baseAddress, Class<T> cls, List<?> providers, String configLocation) {
        JAXRSClientFactoryBean bean = JAXRSClientFactory.getBean(baseAddress, cls, configLocation);
        bean.setProviders(providers);
        return bean.create(cls, new Object[0]);
    }

    public static <T> T create(String baseAddress, Class<T> cls, List<?> providers, List<Feature> features, String configLocation) {
        JAXRSClientFactoryBean bean = JAXRSClientFactory.getBean(baseAddress, cls, configLocation);
        bean.setProviders(providers);
        bean.setFeatures(features);
        return bean.create(cls, new Object[0]);
    }

    public static <T> T create(String baseAddress, Class<T> cls, String username, String password, String configLocation) {
        JAXRSClientFactoryBean bean = JAXRSClientFactory.getBean(baseAddress, cls, configLocation);
        bean.setUsername(username);
        bean.setPassword(password);
        return bean.create(cls, new Object[0]);
    }

    public static <T> T create(String baseAddress, Class<T> cls, List<?> providers, String username, String password, String configLocation) {
        JAXRSClientFactoryBean bean = JAXRSClientFactory.getBean(baseAddress, cls, configLocation);
        bean.setUsername(username);
        bean.setPassword(password);
        bean.setProviders(providers);
        return bean.create(cls, new Object[0]);
    }

    public static <T> T createFromModel(String baseAddress, Class<T> cls, String modelRef, String configLocation) {
        return JAXRSClientFactory.createFromModel(baseAddress, cls, modelRef, Collections.emptyList(), configLocation);
    }

    public static <T> T createFromModel(String baseAddress, Class<T> cls, String modelRef, List<?> providers, String configLocation) {
        JAXRSClientFactoryBean bean = WebClient.getBean(baseAddress, configLocation);
        bean.setProviders(providers);
        bean.setModelRef(modelRef);
        bean.setServiceClass(cls);
        return bean.create(cls, new Object[0]);
    }

    public static <T> T createFromModel(String baseAddress, Class<T> cls, String modelRef, List<?> providers, boolean threadSafe) {
        JAXRSClientFactoryBean bean = WebClient.getBean(baseAddress, null);
        bean.setProviders(providers);
        bean.setModelRef(modelRef);
        bean.setServiceClass(cls);
        if (threadSafe) {
            bean.setInitialState(new ThreadLocalClientState(baseAddress));
        }
        return bean.create(cls, new Object[0]);
    }

    public static <T> T createFromModel(String baseAddress, Class<T> cls, String modelRef, List<?> providers, long timeToKeepState) {
        JAXRSClientFactoryBean bean = WebClient.getBean(baseAddress, null);
        bean.setProviders(providers);
        bean.setModelRef(modelRef);
        bean.setServiceClass(cls);
        bean.setInitialState(new ThreadLocalClientState(baseAddress, timeToKeepState));
        return bean.create(cls, new Object[0]);
    }

    public static <T> T createFromModel(String baseAddress, Class<T> cls, List<UserResource> modelBeans, String configLocation) {
        return JAXRSClientFactory.createFromModel(baseAddress, cls, modelBeans, Collections.emptyList(), configLocation);
    }

    public static <T> T createFromModel(String baseAddress, Class<T> cls, List<UserResource> modelBeans, List<?> providers, String configLocation) {
        JAXRSClientFactoryBean bean = WebClient.getBean(baseAddress, configLocation);
        bean.setProviders(providers);
        bean.setModelBeans(modelBeans);
        bean.setServiceClass(cls);
        return bean.create(cls, new Object[0]);
    }

    public static <T> T fromClient(Client client, Class<T> cls) {
        return JAXRSClientFactory.fromClient(client, cls, false);
    }

    public static <T> T fromClient(Client client, Class<T> cls, boolean inheritHeaders) {
        JAXRSClientFactoryBean bean = JAXRSClientFactory.getBean(client.getCurrentURI().toString(), cls, null);
        bean.setInheritHeaders(inheritHeaders);
        ClientState clientState = WebClient.getClientState(client);
        T proxy = null;
        if (clientState == null) {
            proxy = bean.create(cls, new Object[0]);
            if (inheritHeaders) {
                WebClient.client(proxy).headers(client.getHeaders());
            }
        } else {
            MultivaluedMap<String, String> headers = inheritHeaders ? client.getHeaders() : null;
            bean.setInitialState(clientState.newState(client.getCurrentURI(), headers, null, bean.getProperties()));
            proxy = bean.create(cls, new Object[0]);
        }
        WebClient.copyProperties(WebClient.client(proxy), client);
        return proxy;
    }

    static <T> T createProxy(Class<T> cls, ClassLoader loader, InvocationHandler handler) {
        return cls.cast(ProxyHelper.getProxy((ClassLoader)(loader == null ? cls.getClassLoader() : loader), (Class[])new Class[]{Client.class, InvocationHandlerAware.class, cls}, (InvocationHandler)handler));
    }

    private static JAXRSClientFactoryBean getBean(String baseAddress, Class<?> cls, String configLocation) {
        JAXRSClientFactoryBean bean = WebClient.getBean(baseAddress, configLocation);
        bean.setServiceClass(cls);
        return bean;
    }
}

