/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.internal.util;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.uima.internal.util.MsgLocalizationClassLoader;

public class I18nUtil {
    public static String localizeMessage(String aResourceBundleName, String aMessageKey, Object[] aArguments) {
        return I18nUtil.localizeMessage(aResourceBundleName, Locale.getDefault(), aMessageKey, aArguments, null);
    }

    public static String localizeMessage(String aResourceBundleName, String aMessageKey, Object[] aArguments, ClassLoader aLoader) {
        return I18nUtil.localizeMessage(aResourceBundleName, Locale.getDefault(), aMessageKey, aArguments, aLoader);
    }

    public static String localizeMessage(String aResourceBundleName, Locale aLocale, String aMessageKey, Object[] aArguments) {
        return I18nUtil.localizeMessage(aResourceBundleName, aLocale, aMessageKey, aArguments, null);
    }

    public static String localizeMessage(String aResourceBundleName, Locale aLocale, String aMessageKey, Object[] aArguments, ClassLoader aLoader) {
        try {
            ResourceBundle bundle = I18nUtil.resolveResourceBundle(aResourceBundleName, aLocale, aLoader);
            return I18nUtil.localizeMessage(bundle, aLocale, aMessageKey, aArguments);
        }
        catch (Exception e) {
            return "MESSAGE LOCALIZATION FAILED: " + e.getMessage();
        }
    }

    public static String localizeMessage(ResourceBundle aResourceBundle, Locale aLocale, String aMessageKey, Object[] aArguments) {
        try {
            Object message;
            Object object = message = aResourceBundle == null ? "Null ResourceBundle, key = \"" + aMessageKey + "\"" : aResourceBundle.getString(aMessageKey);
            if (aResourceBundle != null && aArguments != null && aArguments.length > 0) {
                MessageFormat fmt = new MessageFormat((String)message);
                fmt.setLocale(aLocale);
                return fmt.format(aArguments);
            }
            return message;
        }
        catch (Exception e) {
            return "MESSAGE LOCALIZATION FAILED: The key " + aMessageKey + " may be missing in the properties file " + e.getMessage();
        }
    }

    public static ResourceBundle resolveResourceBundle(String aResourceBundleName, Locale aLocale, ClassLoader aLoader) {
        if (aLoader == null) {
            aLoader = MsgLocalizationClassLoader.getMsgLocalizationClassLoader();
        }
        return ResourceBundle.getBundle(aResourceBundleName, aLocale, aLoader);
    }

    public static void setTccl(ClassLoader tccl) {
        MsgLocalizationClassLoader.CallClimbingClassLoader.original_thread_context_class_loader.set(tccl);
    }

    public static void removeTccl() {
        MsgLocalizationClassLoader.CallClimbingClassLoader.original_thread_context_class_loader.remove();
    }
}

