/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.fit.factory;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.uima.cas.CAS;
import org.apache.uima.fit.factory.FsIndexFactory;
import org.apache.uima.fit.factory.TypePrioritiesFactory;
import org.apache.uima.fit.factory.TypeSystemDescriptionFactory;
import org.apache.uima.fit.internal.ResourceManagerFactory;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.metadata.FsIndexCollection;
import org.apache.uima.resource.metadata.FsIndexDescription;
import org.apache.uima.resource.metadata.TypePriorities;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.util.CasCreationUtils;
import org.apache.uima.util.CasIOUtils;

public final class CasFactory {
    private CasFactory() {
    }

    public static CAS createText(String aText) throws ResourceInitializationException {
        return CasFactory.createText(aText, null);
    }

    public static CAS createText(String aText, String aLanguage) throws ResourceInitializationException {
        CAS cas = CasFactory.createCas();
        if (aText != null) {
            cas.setDocumentText(aText);
        }
        if (aLanguage != null) {
            cas.setDocumentLanguage(aLanguage);
        }
        return cas;
    }

    public static CAS createCas() throws ResourceInitializationException {
        TypeSystemDescription tsd = TypeSystemDescriptionFactory.createTypeSystemDescription();
        TypePriorities tp = TypePrioritiesFactory.createTypePriorities();
        FsIndexCollection indexes = FsIndexFactory.createFsIndexCollection();
        ResourceManager resMgr = ResourceManagerFactory.newResourceManager();
        return CasCreationUtils.createCas((TypeSystemDescription)tsd, (TypePriorities)tp, (FsIndexDescription[])indexes.getFsIndexes(), null, (ResourceManager)resMgr);
    }

    public static CAS createCas(String ... typeSystemDescriptorNames) throws ResourceInitializationException {
        return CasCreationUtils.createCas((TypeSystemDescription)TypeSystemDescriptionFactory.createTypeSystemDescription(typeSystemDescriptorNames), null, null);
    }

    public static CAS createCasFromPath(String ... typeSystemDescriptorPaths) throws ResourceInitializationException {
        return CasFactory.createCas(TypeSystemDescriptionFactory.createTypeSystemDescriptionFromPath(typeSystemDescriptorPaths));
    }

    public static CAS createCas(TypeSystemDescription typeSystemDescription) throws ResourceInitializationException {
        return CasCreationUtils.createCas((TypeSystemDescription)typeSystemDescription, null, null);
    }

    public static CAS createCas(String fileName, TypeSystemDescription typeSystemDescription) throws ResourceInitializationException, IOException {
        CAS cas = CasFactory.createCas(typeSystemDescription);
        try (FileInputStream is = new FileInputStream(fileName);){
            CasIOUtils.load((InputStream)is, (CAS)cas);
        }
        return cas;
    }
}

