/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast;

import com.strobel.decompiler.languages.java.ast.Expression;
import com.strobel.decompiler.languages.java.ast.IAstVisitor;
import com.strobel.decompiler.languages.java.ast.JavaTokenNode;
import com.strobel.decompiler.languages.java.ast.Roles;
import com.strobel.decompiler.languages.java.ast.Statement;
import com.strobel.decompiler.languages.java.ast.TokenRole;
import com.strobel.decompiler.patterns.INode;
import com.strobel.decompiler.patterns.Match;

public class WhileStatement
extends Statement {
    public static final TokenRole WHILE_KEYWORD_ROLE = new TokenRole("while", 1);

    public WhileStatement(int offset) {
        super(offset);
    }

    public WhileStatement(Expression condition) {
        super(condition.getOffset());
        this.setCondition(condition);
    }

    public final Statement getEmbeddedStatement() {
        return this.getChildByRole(Roles.EMBEDDED_STATEMENT);
    }

    public final void setEmbeddedStatement(Statement value) {
        this.setChildByRole(Roles.EMBEDDED_STATEMENT, value);
    }

    public final Expression getCondition() {
        return this.getChildByRole(Roles.CONDITION);
    }

    public final void setCondition(Expression value) {
        this.setChildByRole(Roles.CONDITION, value);
    }

    public final JavaTokenNode getWhileToken() {
        return this.getChildByRole(WHILE_KEYWORD_ROLE);
    }

    public final JavaTokenNode getLeftParenthesisToken() {
        return this.getChildByRole(Roles.LEFT_PARENTHESIS);
    }

    public final JavaTokenNode getRightParenthesisToken() {
        return this.getChildByRole(Roles.RIGHT_PARENTHESIS);
    }

    @Override
    public <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> visitor, T data) {
        return visitor.visitWhileStatement(this, data);
    }

    @Override
    public boolean matches(INode other, Match match) {
        if (other instanceof WhileStatement) {
            WhileStatement otherStatement = (WhileStatement)other;
            return !other.isNull() && this.getCondition().matches(otherStatement.getCondition(), match) && this.getEmbeddedStatement().matches(otherStatement.getEmbeddedStatement(), match);
        }
        return false;
    }
}

