/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.QNameValue;

public class ResolveQName
extends SystemFunction {
    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        NodeInfo nodeInfo;
        String[] stringArray;
        AtomicValue atomicValue = (AtomicValue)this.argument[0].evaluateItem(xPathContext);
        if (atomicValue == null) {
            return null;
        }
        CharSequence charSequence = atomicValue.getStringValueCS();
        NameChecker nameChecker = xPathContext.getConfiguration().getNameChecker();
        try {
            stringArray = nameChecker.getQNameParts(charSequence);
        }
        catch (QNameException qNameException) {
            this.dynamicError(qNameException.getMessage(), "FOCA0002", xPathContext);
            return null;
        }
        NodeInfo nodeInfo2 = (NodeInfo)this.argument[1].evaluateItem(xPathContext);
        AxisIterator axisIterator = nodeInfo2.iterateAxis((byte)8);
        while ((nodeInfo = (NodeInfo)axisIterator.next()) != null) {
            String string = nodeInfo.getLocalPart();
            if (!string.equals(stringArray[0])) continue;
            return new QNameValue(string, nodeInfo.getStringValue(), stringArray[1], BuiltInAtomicType.QNAME, nameChecker);
        }
        if (stringArray[0].equals("")) {
            return new QNameValue("", null, stringArray[1], BuiltInAtomicType.QNAME, nameChecker);
        }
        this.dynamicError("Namespace prefix '" + stringArray[0] + "' is not in scope for the selected element", "FONS0004", xPathContext);
        return null;
    }
}

