/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.adapter.jms.activemq;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.activemq.ActiveMQConnectionFactory;

public class ConnectionFactoryIniter {
    ActiveMQConnectionFactory factory;
    String whiteListedPackages = null;
    List<String> defaultPackages = Arrays.asList("org.apache.uima.aae.error", "org.apache.uima.analysis_engine", "org.apache.uima.resource", "org.apache.activemq", "org.fusesource.hawtbuf", "com.thoughtworks.xstream.mapper", "java.lang", "java.util");

    public ConnectionFactoryIniter(ActiveMQConnectionFactory factory) {
        this.factory = factory;
        this.whiteListedPackages = System.getProperty("uima.as.white.list.packages");
    }

    public void whiteListPackages() {
        if (this.whiteListedPackages != null && this.whiteListedPackages.trim().length() > 0) {
            this.whiteListPackages(this.whiteListedPackages);
        } else {
            this.whiteListPackages(this.defaultPackages);
        }
    }

    public void whiteListPackages(List<String> packageList) {
        if (!packageList.equals(this.defaultPackages)) {
            packageList.addAll(this.defaultPackages);
        }
        this.updateFactory(packageList);
    }

    public void whiteListPackages(String packageListAsString) {
        String[] pkgArray = packageListAsString.split(",");
        ArrayList<String> list = new ArrayList<String>();
        for (String pkg : pkgArray) {
            list.add(pkg.trim());
        }
        this.whiteListPackages(list);
    }

    private void updateFactory(List<String> packageList) {
        this.factory.setTrustedPackages(packageList);
    }
}

