/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.io.Serializable;
import java.util.List;
import java.util.Properties;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.Controller;
import net.sf.saxon.event.CDATAFilter;
import net.sf.saxon.event.CharacterMapExpander;
import net.sf.saxon.event.ContentHandlerProxy;
import net.sf.saxon.event.Emitter;
import net.sf.saxon.event.HTMLEmitter;
import net.sf.saxon.event.HTMLIndenter;
import net.sf.saxon.event.HTMLURIEscaper;
import net.sf.saxon.event.MetaTagAdjuster;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.TEXTEmitter;
import net.sf.saxon.event.UncommittedSerializer;
import net.sf.saxon.event.UnicodeNormalizer;
import net.sf.saxon.event.XHTMLEmitter;
import net.sf.saxon.event.XHTMLIndenter;
import net.sf.saxon.event.XML10ContentChecker;
import net.sf.saxon.event.XMLEmitter;
import net.sf.saxon.event.XMLIndenter;
import net.sf.saxon.om.ExternalObjectModel;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;

public class SerializerFactory
implements Serializable {
    public Receiver getReceiver(Result result, PipelineConfiguration pipelineConfiguration, Properties properties) throws XPathException {
        if (result instanceof Emitter) {
            ((Emitter)result).setOutputProperties(properties);
            return (Emitter)result;
        }
        if (result instanceof Receiver) {
            Receiver receiver = (Receiver)result;
            receiver.setSystemId(result.getSystemId());
            receiver.setPipelineConfiguration(pipelineConfiguration);
            return receiver;
        }
        if (result instanceof SAXResult) {
            ContentHandlerProxy contentHandlerProxy = this.newContentHandlerProxy();
            contentHandlerProxy.setUnderlyingContentHandler(((SAXResult)result).getHandler());
            contentHandlerProxy.setPipelineConfiguration(pipelineConfiguration);
            contentHandlerProxy.setOutputProperties(properties);
            if ("yes".equals(properties.getProperty("supply-source-locator"))) {
                if (pipelineConfiguration.getConfiguration().isCompileWithTracing()) {
                    pipelineConfiguration.getController().addTraceListener(contentHandlerProxy.getTraceListener());
                } else {
                    DynamicError dynamicError = new DynamicError("Cannot use saxon:supply-source-locator unless tracing was enabled at compile time");
                    dynamicError.setErrorCode("SXSE0002");
                    throw dynamicError;
                }
            }
            return contentHandlerProxy;
        }
        if (result instanceof StreamResult) {
            Result result2;
            Result result3;
            Emitter emitter;
            Object object;
            String string = properties.getProperty("method");
            if (string == null) {
                UncommittedSerializer uncommittedSerializer = this.newUncommittedSerializer(result, properties);
                uncommittedSerializer.setPipelineConfiguration(pipelineConfiguration);
                return uncommittedSerializer;
            }
            CharacterMapExpander characterMapExpander = null;
            String string2 = properties.getProperty("use-character-maps");
            if (string2 != null) {
                Object object2 = object = pipelineConfiguration == null ? null : pipelineConfiguration.getController();
                if (object == null) {
                    DynamicError dynamicError = new DynamicError("Cannot use character maps in an environment with no Controller");
                    dynamicError.setErrorCode("SXSE0001");
                    throw dynamicError;
                }
                characterMapExpander = ((Controller)object).makeCharacterMapExpander(string2, this);
                characterMapExpander.setPipelineConfiguration(pipelineConfiguration);
            }
            object = null;
            String string3 = properties.getProperty("normalization-form");
            if (string3 != null && !string3.equals("none")) {
                object = this.newUnicodeNormalizer(pipelineConfiguration, properties);
            }
            if ("html".equals(string)) {
                emitter = this.newHTMLEmitter();
                emitter.setPipelineConfiguration(pipelineConfiguration);
                result3 = this.createHTMLSerializer(emitter, properties, pipelineConfiguration, characterMapExpander, (ProxyReceiver)object);
            } else if ("xml".equals(string)) {
                emitter = this.newXMLEmitter();
                emitter.setPipelineConfiguration(pipelineConfiguration);
                result3 = this.createXMLSerializer(emitter, properties, pipelineConfiguration, (ProxyReceiver)object, characterMapExpander);
            } else if ("xhtml".equals(string)) {
                emitter = this.newXHTMLEmitter();
                emitter.setPipelineConfiguration(pipelineConfiguration);
                result3 = this.createXHTMLSerializer(emitter, properties, pipelineConfiguration, (ProxyReceiver)object, characterMapExpander);
            } else if ("text".equals(string)) {
                emitter = this.newTEXTEmitter();
                emitter.setPipelineConfiguration(pipelineConfiguration);
                result3 = this.createTextSerializer(emitter, characterMapExpander, (ProxyReceiver)object);
            } else {
                if (pipelineConfiguration == null) {
                    throw new DynamicError("Unsupported serialization method " + string);
                }
                result2 = pipelineConfiguration.getConfiguration().makeEmitter(string, pipelineConfiguration.getController());
                result2.setPipelineConfiguration(pipelineConfiguration);
                if (result2 instanceof ContentHandlerProxy && "yes".equals(properties.getProperty("supply-source-locator"))) {
                    if (pipelineConfiguration.getConfiguration().isCompileWithTracing()) {
                        pipelineConfiguration.getController().addTraceListener(((ContentHandlerProxy)result2).getTraceListener());
                    } else {
                        DynamicError dynamicError = new DynamicError("Cannot use saxon:supply-source-locator unless tracing was enabled at compile time");
                        dynamicError.setErrorCode("SXSE0002");
                        throw dynamicError;
                    }
                }
                result3 = result2;
                if (result2 instanceof Emitter) {
                    emitter = (Emitter)result2;
                } else {
                    return result2;
                }
            }
            emitter.setOutputProperties(properties);
            result2 = (StreamResult)result;
            emitter.setStreamResult((StreamResult)result2);
            return result3;
        }
        if (pipelineConfiguration != null) {
            List list = pipelineConfiguration.getConfiguration().getExternalObjectModels();
            for (int i = 0; i < list.size(); ++i) {
                ExternalObjectModel externalObjectModel = (ExternalObjectModel)list.get(i);
                Receiver receiver = externalObjectModel.getDocumentBuilder(result);
                if (receiver == null) continue;
                receiver.setSystemId(result.getSystemId());
                receiver.setPipelineConfiguration(pipelineConfiguration);
                return receiver;
            }
        }
        if (result instanceof DOMResult) {
            throw new UnsupportedOperationException("Saxon cannot write a DOMResult unless saxon8-dom.jar is on the classpath");
        }
        throw new IllegalArgumentException("Unknown type of result: " + result.getClass());
    }

    protected Receiver createHTMLSerializer(Emitter emitter, Properties properties, PipelineConfiguration pipelineConfiguration, CharacterMapExpander characterMapExpander, ProxyReceiver proxyReceiver) throws XPathException {
        ProxyReceiver proxyReceiver2;
        Receiver receiver = emitter;
        if (!"no".equals(properties.getProperty("indent"))) {
            proxyReceiver2 = this.newHTMLIndenter(pipelineConfiguration, properties);
            proxyReceiver2.setUnderlyingReceiver(receiver);
            receiver = proxyReceiver2;
        }
        if (!"no".equals(properties.getProperty("include-content-type"))) {
            proxyReceiver2 = this.newHTMLMetaTagAdjuster(pipelineConfiguration, properties);
            proxyReceiver2.setUnderlyingReceiver(receiver);
            receiver = proxyReceiver2;
        }
        if (proxyReceiver != null) {
            proxyReceiver.setUnderlyingReceiver(receiver);
            receiver = proxyReceiver;
        }
        if (characterMapExpander != null) {
            characterMapExpander.setUnderlyingReceiver(receiver);
            receiver = characterMapExpander;
        }
        if (!"no".equals(properties.getProperty("escape-uri-attibutes"))) {
            proxyReceiver2 = this.newHTMLURIEscaper(pipelineConfiguration, properties);
            proxyReceiver2.setUnderlyingReceiver(receiver);
            receiver = proxyReceiver2;
        }
        return receiver;
    }

    protected Receiver createTextSerializer(Emitter emitter, CharacterMapExpander characterMapExpander, ProxyReceiver proxyReceiver) {
        Receiver receiver = emitter;
        if (characterMapExpander != null) {
            characterMapExpander.setUnderlyingReceiver(receiver);
            characterMapExpander.setUseNullMarkers(false);
            receiver = characterMapExpander;
        }
        if (proxyReceiver != null) {
            proxyReceiver.setUnderlyingReceiver(receiver);
            receiver = proxyReceiver;
        }
        return receiver;
    }

    protected Receiver createXHTMLSerializer(Emitter emitter, Properties properties, PipelineConfiguration pipelineConfiguration, ProxyReceiver proxyReceiver, CharacterMapExpander characterMapExpander) throws XPathException {
        ProxyReceiver proxyReceiver2;
        Object object;
        Object object2 = emitter;
        if (!"no".equals(properties.getProperty("indent"))) {
            object = this.newXHTMLIndenter(pipelineConfiguration, properties);
            ((ProxyReceiver)object).setUnderlyingReceiver((Receiver)object2);
            object2 = object;
        }
        if (!"no".equals(properties.getProperty("include-content-type"))) {
            object = this.newXHTMLMetaTagAdjuster(pipelineConfiguration, properties);
            ((ProxyReceiver)object).setUnderlyingReceiver((Receiver)object2);
            object2 = object;
        }
        if (proxyReceiver != null) {
            proxyReceiver.setUnderlyingReceiver((Receiver)object2);
            object2 = proxyReceiver;
        }
        if (characterMapExpander != null) {
            characterMapExpander.setUnderlyingReceiver((Receiver)object2);
            characterMapExpander.setPipelineConfiguration(pipelineConfiguration);
            object2 = characterMapExpander;
        }
        if ((object = properties.getProperty("cdata-section-elements")) != null && ((String)object).length() > 0) {
            proxyReceiver2 = this.newCDATAFilter(pipelineConfiguration, properties);
            proxyReceiver2.setUnderlyingReceiver((Receiver)object2);
            object2 = proxyReceiver2;
        }
        if (!"no".equals(properties.getProperty("escape-uri-attibutes"))) {
            proxyReceiver2 = this.newHTMLURIEscaper(pipelineConfiguration, properties);
            proxyReceiver2.setUnderlyingReceiver((Receiver)object2);
            object2 = proxyReceiver2;
        }
        return object2;
    }

    protected Receiver createXMLSerializer(Emitter emitter, Properties properties, PipelineConfiguration pipelineConfiguration, ProxyReceiver proxyReceiver, CharacterMapExpander characterMapExpander) throws XPathException {
        Object object;
        Object object2 = emitter;
        if ("1.0".equals(properties.getProperty("version")) && pipelineConfiguration.getConfiguration().getXMLVersion() == 11) {
            object = this.newXML10ContentChecker(pipelineConfiguration, properties);
            ((ProxyReceiver)object).setUnderlyingReceiver((Receiver)object2);
            object2 = object;
        }
        if ("yes".equals(properties.getProperty("indent"))) {
            object = this.newXMLIndenter(pipelineConfiguration, properties);
            ((ProxyReceiver)object).setUnderlyingReceiver((Receiver)object2);
            object2 = object;
        }
        if (proxyReceiver != null) {
            proxyReceiver.setUnderlyingReceiver((Receiver)object2);
            object2 = proxyReceiver;
        }
        if (characterMapExpander != null) {
            characterMapExpander.setUnderlyingReceiver((Receiver)object2);
            object2 = characterMapExpander;
        }
        if ((object = properties.getProperty("cdata-section-elements")) != null && ((String)object).length() > 0) {
            ProxyReceiver proxyReceiver2 = this.newCDATAFilter(pipelineConfiguration, properties);
            proxyReceiver2.setUnderlyingReceiver((Receiver)object2);
            object2 = proxyReceiver2;
        }
        return object2;
    }

    protected ContentHandlerProxy newContentHandlerProxy() {
        return new ContentHandlerProxy();
    }

    protected UncommittedSerializer newUncommittedSerializer(Result result, Properties properties) {
        return new UncommittedSerializer(result, properties);
    }

    protected Emitter newXMLEmitter() {
        return new XMLEmitter();
    }

    protected Emitter newHTMLEmitter() {
        return new HTMLEmitter();
    }

    protected Emitter newXHTMLEmitter() {
        return new XHTMLEmitter();
    }

    protected Emitter newTEXTEmitter() {
        return new TEXTEmitter();
    }

    protected ProxyReceiver newXMLIndenter(PipelineConfiguration pipelineConfiguration, Properties properties) {
        XMLIndenter xMLIndenter = new XMLIndenter();
        xMLIndenter.setPipelineConfiguration(pipelineConfiguration);
        xMLIndenter.setOutputProperties(properties);
        return xMLIndenter;
    }

    protected ProxyReceiver newHTMLIndenter(PipelineConfiguration pipelineConfiguration, Properties properties) {
        HTMLIndenter hTMLIndenter = new HTMLIndenter();
        hTMLIndenter.setPipelineConfiguration(pipelineConfiguration);
        hTMLIndenter.setOutputProperties(properties);
        return hTMLIndenter;
    }

    protected ProxyReceiver newXHTMLIndenter(PipelineConfiguration pipelineConfiguration, Properties properties) {
        XHTMLIndenter xHTMLIndenter = new XHTMLIndenter();
        xHTMLIndenter.setPipelineConfiguration(pipelineConfiguration);
        xHTMLIndenter.setOutputProperties(properties);
        return xHTMLIndenter;
    }

    protected MetaTagAdjuster newXHTMLMetaTagAdjuster(PipelineConfiguration pipelineConfiguration, Properties properties) {
        MetaTagAdjuster metaTagAdjuster = new MetaTagAdjuster();
        metaTagAdjuster.setPipelineConfiguration(pipelineConfiguration);
        metaTagAdjuster.setOutputProperties(properties);
        metaTagAdjuster.setIsXHTML(true);
        return metaTagAdjuster;
    }

    protected MetaTagAdjuster newHTMLMetaTagAdjuster(PipelineConfiguration pipelineConfiguration, Properties properties) {
        MetaTagAdjuster metaTagAdjuster = new MetaTagAdjuster();
        metaTagAdjuster.setPipelineConfiguration(pipelineConfiguration);
        metaTagAdjuster.setOutputProperties(properties);
        metaTagAdjuster.setIsXHTML(false);
        return metaTagAdjuster;
    }

    protected ProxyReceiver newHTMLURIEscaper(PipelineConfiguration pipelineConfiguration, Properties properties) {
        HTMLURIEscaper hTMLURIEscaper = new HTMLURIEscaper();
        hTMLURIEscaper.setPipelineConfiguration(pipelineConfiguration);
        return hTMLURIEscaper;
    }

    protected ProxyReceiver newCDATAFilter(PipelineConfiguration pipelineConfiguration, Properties properties) throws XPathException {
        CDATAFilter cDATAFilter = new CDATAFilter();
        cDATAFilter.setPipelineConfiguration(pipelineConfiguration);
        cDATAFilter.setOutputProperties(properties);
        return cDATAFilter;
    }

    protected ProxyReceiver newXML10ContentChecker(PipelineConfiguration pipelineConfiguration, Properties properties) {
        XML10ContentChecker xML10ContentChecker = new XML10ContentChecker();
        xML10ContentChecker.setPipelineConfiguration(pipelineConfiguration);
        return xML10ContentChecker;
    }

    protected ProxyReceiver newUnicodeNormalizer(PipelineConfiguration pipelineConfiguration, Properties properties) throws XPathException {
        String string = properties.getProperty("normalization-form");
        UnicodeNormalizer unicodeNormalizer = new UnicodeNormalizer(string);
        unicodeNormalizer.setPipelineConfiguration(pipelineConfiguration);
        return unicodeNormalizer;
    }

    public CharacterMapExpander newCharacterMapExpander() {
        CharacterMapExpander characterMapExpander = new CharacterMapExpander();
        return characterMapExpander;
    }
}

