/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.taeconfigurator.editors.ui.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.apache.uima.analysis_engine.TypeOrFeature;
import org.apache.uima.resource.metadata.Capability;
import org.apache.uima.taeconfigurator.editors.ui.AbstractSection;
import org.apache.uima.taeconfigurator.editors.ui.CapabilitySection;
import org.apache.uima.taeconfigurator.editors.ui.dialogs.AbstractDialogMultiColTable;
import org.eclipse.swt.custom.TableTreeItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class AddCapabilityTypeDialog
extends AbstractDialogMultiColTable {
    public String[] types;
    public boolean[] inputs;
    public boolean[] outputs;
    private static final int NAME = 0;
    private static final int INPUT = 1;
    private static final int OUTPUT = 2;
    private static final int NAMESPACE = 3;
    CapabilitySection capabilitySection;
    private Capability capability;
    private TableTreeItem existing = null;
    private static List excludedTypes = new ArrayList();

    public AddCapabilityTypeDialog(AbstractSection aSection, Capability c) {
        super(aSection, "Add Types to a Capability Set", "Mark one or more types as " + (aSection.isCasConsumerDescriptor() ? "Input" : (aSection.isCasInitializerDescriptor() || aSection.isCollectionReaderDescriptor() ? "Output" : "Input and/or Output")) + " by clicking the mouse in the corresponding column, and press OK");
        excludedTypes.add("uima.cas.ArrayBase");
        excludedTypes.add("uima.cas.EmptyFSList");
        excludedTypes.add("uima.cas.EmptyFloatList");
        excludedTypes.add("uima.cas.EmptyIntegerList");
        excludedTypes.add("uima.cas.EmptyStringList");
        excludedTypes.add("uima.cas.FSArray");
        excludedTypes.add("uima.cas.FSList");
        excludedTypes.add("uima.cas.Float");
        excludedTypes.add("uima.cas.FloatArray");
        excludedTypes.add("uima.cas.FloatList");
        excludedTypes.add("uima.cas.Integer");
        excludedTypes.add("uima.cas.IntegerArray");
        excludedTypes.add("uima.cas.IntegerList");
        excludedTypes.add("uima.cas.Boolean");
        excludedTypes.add("uima.cas.BooleanArray");
        excludedTypes.add("uima.cas.Byte");
        excludedTypes.add("uima.cas.ByteArray");
        excludedTypes.add("uima.cas.Short");
        excludedTypes.add("uima.cas.ShortArray");
        excludedTypes.add("uima.cas.Long");
        excludedTypes.add("uima.cas.LongArray");
        excludedTypes.add("uima.cas.Double");
        excludedTypes.add("uima.cas.DoubleArray");
        excludedTypes.add("uima.cas.ListBase");
        excludedTypes.add("uima.cas.NonEmptyFSList");
        excludedTypes.add("uima.cas.NonEmptyFloatList");
        excludedTypes.add("uima.cas.NonEmptyIntegerList");
        excludedTypes.add("uima.cas.NonEmptyStringList");
        excludedTypes.add("uima.cas.Sofa");
        excludedTypes.add("uima.cas.String");
        excludedTypes.add("uima.cas.StringArray");
        excludedTypes.add("uima.cas.StringList");
        excludedTypes.add("uima.cas.TOP");
        this.capabilitySection = (CapabilitySection)aSection;
        this.capability = c;
        this.enableCol1 = !aSection.isCasInitializerDescriptor() && !aSection.isCollectionReaderDescriptor();
        this.enableCol2 = !aSection.isCasConsumerDescriptor();
    }

    public AddCapabilityTypeDialog(AbstractSection aSection, Capability c, TableTreeItem aExisting) {
        this(aSection, c);
        this.existing = aExisting;
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent, this.existing);
        this.table = this.newTable(composite, 68098);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        new TableColumn(this.table, 0).setText("Type Name");
        new TableColumn(this.table, 0).setText("Input");
        new TableColumn(this.table, 0).setText("Output");
        new TableColumn(this.table, 0).setText("Type Namespace");
        if (null == this.existing) {
            String[] allTypes = this.getAllTypesAsSortedArray();
            for (int i = 0; i < allTypes.length; ++i) {
                if (excludedTypes.contains(allTypes[i]) || this.hasType(this.capability.getInputs(), allTypes[i]) || this.hasType(this.capability.getOutputs(), allTypes[i])) continue;
                TableItem item = new TableItem(this.table, 0);
                this.setGuiTypeName(item, allTypes[i]);
            }
        } else {
            TableItem item = new TableItem(this.table, 0);
            item.setText(0, this.existing.getText(1));
            item.setText(3, this.existing.getText(4));
            TypeOrFeature tof = CapabilitySection.getTypeOrFeature(this.capability.getInputs(), this.capabilitySection.getFullyQualifiedName(this.existing));
            this.setChecked(item, 1, null != tof);
            tof = CapabilitySection.getTypeOrFeature(this.capability.getOutputs(), this.capabilitySection.getFullyQualifiedName(this.existing));
            this.setChecked(item, 2, null != tof);
        }
        this.section.packTable(this.table);
        this.table.removeListener(13, (Listener)this);
        this.table.addListener(3, (Listener)this);
        this.newErrorMessage(composite);
        return composite;
    }

    private boolean hasType(TypeOrFeature[] items, String name) {
        if (null == items) {
            return false;
        }
        for (int i = 0; i < items.length; ++i) {
            if (!items[i].isType() || !items[i].getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void copyValuesFromGUI() {
        int i;
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<Boolean> ins = new ArrayList<Boolean>();
        ArrayList<Boolean> outs = new ArrayList<Boolean>();
        for (i = this.table.getItemCount() - 1; i >= 0; --i) {
            TableItem item = this.table.getItem(i);
            if (!item.getText(1).equals(this.checkedIndicator(1)) && !item.getText(2).equals(this.checkedIndicator(2))) continue;
            names.add(this.capabilitySection.getFullyQualifiedName(item.getText(3), item.getText(0)));
            ins.add(item.getText(1).equals(this.checkedIndicator(1)));
            outs.add(item.getText(2).equals(this.checkedIndicator(2)));
        }
        this.types = names.toArray(stringArray0);
        this.inputs = new boolean[this.types.length];
        this.outputs = new boolean[this.types.length];
        for (i = 0; i < this.types.length; ++i) {
            this.inputs[i] = (Boolean)ins.get(i);
            this.outputs[i] = (Boolean)outs.get(i);
        }
    }

    public void setGuiTypeName(TableItem item, String typeName) {
        item.setText(0, AbstractSection.getShortName(typeName));
        item.setText(3, AbstractSection.getNameSpace(typeName));
    }

    @Override
    public boolean isValid() {
        for (int i = 0; i < this.types.length; ++i) {
            if (this.inputs[i]) continue;
            if (this.someFeatureOnType(this.types[i], 1)) {
                this.setErrorMessage("This type has one or more features marked for input and can''t be removed as an Input.\nIf you want to do this, first remove the Input designation for all features on this type.");
                return false;
            }
            if (this.outputs[i] || !this.someFeatureOnType(this.types[i], 2) || this.inputs[i]) continue;
            this.setErrorMessage("This type has features which are output, and so must either be specified as INPUT (meaning features are populated or \"outputted\" on existing instances), or OUTPUT (meaning new instances of this type are created).  It can't be removed completely.\nIf you want to do this, first remove the features which are output for this type.");
            return false;
        }
        return true;
    }

    private boolean someFeatureOnType(String typeName, int IO) {
        TypeOrFeature[] tofs = IO == 1 ? this.capability.getInputs() : this.capability.getOutputs();
        String typeNamePlusColon = typeName + ':';
        for (int i = 0; i < tofs.length; ++i) {
            if (tofs[i].isType() || !tofs[i].getName().startsWith(typeNamePlusColon)) continue;
            return true;
        }
        return false;
    }
}

