/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.application.metadata.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.apache.uima.ResourceSpecifierFactory;
import org.apache.uima.UIMAFramework;
import org.apache.uima.UIMA_IllegalStateException;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.TaeDescription;
import org.apache.uima.analysis_engine.metadata.AnalysisEngineMetaData;
import org.apache.uima.application.metadata.IRuntimeContext;
import org.apache.uima.application.metadata.IStringSubstitution;
import org.apache.uima.application.metadata.UimaApplication;
import org.apache.uima.application.metadata.UimaCasProcessor;
import org.apache.uima.application.metadata.impl.AbstractUimaCasProcessor;
import org.apache.uima.application.metadata.impl.RuntimeContext;
import org.apache.uima.application.metadata.impl.UimaCasProcessor_impl;
import org.apache.uima.application.util.UimaXmlParsingUtil;
import org.apache.uima.collection.CasConsumerDescription;
import org.apache.uima.collection.CasInitializerDescription;
import org.apache.uima.collection.CollectionReaderDescription;
import org.apache.uima.collection.impl.metadata.cpe.CpeCasProcessorsImpl;
import org.apache.uima.collection.impl.metadata.cpe.CpeDescriptionImpl;
import org.apache.uima.collection.impl.metadata.cpe.CpeDescriptorFactory;
import org.apache.uima.collection.metadata.CasProcessorConfigurationParameterSettings;
import org.apache.uima.collection.metadata.CasProcessorErrorHandling;
import org.apache.uima.collection.metadata.CasProcessorErrorRateThreshold;
import org.apache.uima.collection.metadata.CasProcessorMaxRestarts;
import org.apache.uima.collection.metadata.CpeCasProcessor;
import org.apache.uima.collection.metadata.CpeCheckpoint;
import org.apache.uima.collection.metadata.CpeCollectionReader;
import org.apache.uima.collection.metadata.CpeCollectionReaderCasInitializer;
import org.apache.uima.collection.metadata.CpeComponentDescriptor;
import org.apache.uima.collection.metadata.CpeConfiguration;
import org.apache.uima.collection.metadata.CpeDescription;
import org.apache.uima.collection.metadata.CpeDescriptorException;
import org.apache.uima.collection.metadata.CpeIntegratedCasProcessor;
import org.apache.uima.cpe.model.ConfigParameterModel;
import org.apache.uima.cpe.model.ConfigParametersModel;
import org.apache.uima.cpe.model.CpeCasProcessorsSettings;
import org.apache.uima.cpe.model.DefaultCasProcessorSettings;
import org.apache.uima.cpe.model.UimaCasInitializer;
import org.apache.uima.cpe.model.UimaCollectionReader;
import org.apache.uima.resource.CustomResourceSpecifier;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.URISpecifier;
import org.apache.uima.resource.metadata.ProcessingResourceMetaData;
import org.apache.uima.resource.metadata.TypePriorities;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.resource.metadata.impl.MetaDataObject_impl;
import org.apache.uima.resource.metadata.impl.PropertyXmlInfo;
import org.apache.uima.resource.metadata.impl.XmlizationInfo;
import org.apache.uima.tools.debug.util.Trace;
import org.apache.uima.util.CasCreationUtils;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;
import org.apache.uima.util.XMLParser;
import org.apache.uima.util.XMLSerializer;
import org.apache.uima.util.XMLizable;
import org.eclipse.core.variables.VariablesPlugin;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class UimaApplication_Impl
extends MetaDataObject_impl
implements UimaApplication {
    private static final long serialVersionUID = -8677679822323086638L;
    private static XMLParser uimaXMLParser;
    private static UimaApplication instance;
    protected IRuntimeContext runtimeContext = new RuntimeContext();
    private CpeConfiguration cpeConfiguration = null;
    private DefaultCasProcessorSettings defaultCasProcessorSettings = null;
    private CasProcessorErrorHandling cpeDefaultErrorHandling = null;
    private CpeCasProcessorsSettings cpeCasProcessorsSettings = new CpeCasProcessorsSettings();
    private List uimaCollectionReaders = new ArrayList();
    private List uimaCasInitializers = new ArrayList();
    private List uimaCasProcessors = new ArrayList();
    private String cpeHref = null;
    static boolean isInitialized_UimaApplicationFramework;
    private static IStringSubstitution stringSubstitutionManager;
    private static final int CPE_DEFAULT_BATCHSIZE = 10000;
    private String currentDir = null;
    private transient ResourceManager resourceManager;
    private static final XmlizationInfo XMLIZATION_INFO;

    public static IStringSubstitution getStringSubstitutionManager() {
        return stringSubstitutionManager;
    }

    public static void setStringSubstitutionManager(IStringSubstitution manager) {
        stringSubstitutionManager = manager;
    }

    public static String resolveUimaXmlDescriptor(String xmlDescriptor) {
        if (stringSubstitutionManager != null) {
            return stringSubstitutionManager.resolveUimaXmlDescriptor(xmlDescriptor);
        }
        return xmlDescriptor;
    }

    public static String generateVariableExpression(String variableName, String arg) {
        return VariablesPlugin.getDefault().getStringVariableManager().generateVariableExpression(variableName, arg);
    }

    protected String toWorkspaceRelativePath(String xml) {
        String resolvedFileName = UimaApplication_Impl.resolveUimaXmlDescriptor(xml);
        File f = new File(resolvedFileName);
        if (!f.isAbsolute() && !f.exists()) {
            f = new File(this.currentDir, resolvedFileName);
            if (!f.exists()) {
                Trace.err("*** ERROR: Cannot find file: " + resolvedFileName);
            } else {
                resolvedFileName = f.getAbsolutePath();
            }
        }
        resolvedFileName = UimaApplication_Impl.generateVariableExpression("workspace_loc", resolvedFileName);
        return resolvedFileName;
    }

    public static void initUimaApplicationFramework() {
        if (isInitialized_UimaApplicationFramework) {
            return;
        }
        isInitialized_UimaApplicationFramework = true;
        uimaXMLParser = UIMAFramework.getXMLParser();
        try {
            uimaXMLParser.addMapping("uimaApplication", "org.apache.uima.application.metadata.impl.UimaApplication_Impl");
            uimaXMLParser.addMapping("uimaCollectionReader", "org.apache.uima.cpe.model.UimaCollectionReader");
            uimaXMLParser.addMapping("uimaCasProcessor", "org.apache.uima.application.metadata.impl.UimaCasProcessor_impl");
            uimaXMLParser.addMapping("deploymentOverrides", "org.apache.uima.application.metadata.impl.DeploymentOverrides_impl");
            uimaXMLParser.addMapping("configParamOverrides", "org.apache.uima.application.metadata.impl.ConfigParamOverrides_impl");
            uimaXMLParser.addMapping("configParamOverrideSet", "org.apache.uima.application.metadata.impl.OverrideSet_impl");
            uimaXMLParser.addMapping("analysisEngineDeploymentDescription", "org.apache.uima.aae.deployment.impl.AEDeploymentDescription_Impl");
            uimaXMLParser.addMapping("service", "org.apache.uima.aae.deployment.impl.AEService_Impl");
            uimaXMLParser.addMapping("analysisEngine", "org.apache.uima.aae.deployment.impl.AEDeploymentMetaData_Impl");
            uimaXMLParser.addMapping("remoteAnalysisEngine", "org.apache.uima.aae.deployment.impl.RemoteAEDeploymentMetaData_Impl");
            uimaXMLParser.addMapping("asyncAggregateErrorConfiguration", "org.apache.uima.aae.deployment.impl.AsyncAggregateErrorConfiguration_Impl");
            uimaXMLParser.addMapping("asyncPrimitiveErrorConfiguration", "org.apache.uima.aae.deployment.impl.AsyncPrimitiveErrorConfiguration_Impl");
            ResourceSpecifierFactory factory = UIMAFramework.getResourceSpecifierFactory();
            factory.addMapping("org.apache.uima.aae.deployment.AEDeploymentDescription", "org.apache.uima.aae.deployment.impl.AEDeploymentDescription_Impl");
            factory.addMapping("org.apache.uima.aae.deployment.AEDeploymentMetaData", "org.apache.uima.aae.deployment.impl.AEDeploymentMetaData_Impl");
            factory.addMapping("org.apache.uima.aae.deployment.RemoteAEDeploymentMetaData", "org.apache.uima.aae.deployment.impl.RemoteAEDeploymentMetaData_Impl");
            factory.addMapping("org.apache.uima.aae.deployment.AsyncAggregateErrorConfiguration", "org.apache.uima.aae.deployment.impl.AsyncAggregateErrorConfiguration_Impl");
            factory.addMapping("org.apache.uima.aae.deployment.AsyncPrimitiveErrorConfiguration", "org.apache.uima.aae.deployment.impl.AsyncPrimitiveErrorConfiguration_Impl");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public UimaApplication_Impl() {
        instance = this;
        this.defaultCasProcessorSettings = new DefaultCasProcessorSettings();
        this.cpeDefaultErrorHandling = UimaApplication_Impl.getCpeDefaultErrorHandling();
        this.cpeCasProcessorsSettings = new CpeCasProcessorsSettings();
    }

    public static XMLizable parseUimaXmlDescriptor(String xmlDescriptorFileName) {
        boolean validArgs;
        XMLizable descriptionObject = null;
        File descFile = new File(xmlDescriptorFileName);
        boolean bl = validArgs = descFile.exists() && !descFile.isDirectory();
        if (!validArgs) {
            Trace.err("Cannot find: " + xmlDescriptorFileName);
            return null;
        }
        try {
            UIMAFramework.getLogger().setOutputStream(new PrintStream(new FileOutputStream("uima.log")));
            XMLInputSource in = new XMLInputSource(descFile);
            descriptionObject = UIMAFramework.getXMLParser().parse(in);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        catch (InvalidXMLException e) {
            Trace.err("xmlDescriptorFileName: " + xmlDescriptorFileName);
            e.printStackTrace();
            return null;
        }
        catch (UIMA_IllegalStateException e) {
            Trace.err("xmlDescriptorFileName: " + xmlDescriptorFileName);
            return null;
        }
        return descriptionObject;
    }

    public static TypeSystemDescription getTypeSystemDescription(ResourceSpecifier specifier) {
        TypeSystemDescription tsDescription = null;
        try {
            if (specifier instanceof TaeDescription) {
                TaeDescription tae = (TaeDescription)specifier;
                tsDescription = tae.isPrimitive() ? tae.getAnalysisEngineMetaData().getTypeSystem() : CasCreationUtils.mergeDelegateAnalysisEngineTypeSystems((AnalysisEngineDescription)tae);
            } else if (specifier instanceof CasConsumerDescription) {
                CasConsumerDescription ccDescr = (CasConsumerDescription)specifier;
                tsDescription = ccDescr.getCasConsumerMetaData().getTypeSystem();
            } else if (specifier instanceof CollectionReaderDescription) {
                CollectionReaderDescription crDescr = (CollectionReaderDescription)specifier;
                tsDescription = crDescr.getCollectionReaderMetaData().getTypeSystem();
            }
        }
        catch (ResourceInitializationException e) {
            e.printStackTrace();
        }
        return tsDescription;
    }

    public TypeSystemDescription getTypeSystemDescription() {
        TypeSystemDescription mergedTypeSystemDescription = null;
        ArrayList<TypeSystemDescription> typeSystemList = new ArrayList<TypeSystemDescription>();
        String resolvedXmlFile = null;
        String aCollectionReaderPath = "";
        List list = this.getUimaCollectionReaders();
        if (list != null && list.size() > 0) {
            aCollectionReaderPath = ((UimaCollectionReader)((Object)list.get(0))).getXmlDescriptor();
            resolvedXmlFile = UimaApplication_Impl.resolveUimaXmlDescriptor(aCollectionReaderPath);
            CollectionReaderDescription crDescr = (CollectionReaderDescription)UimaApplication_Impl.parseUimaXmlDescriptor(resolvedXmlFile);
            typeSystemList.add(crDescr.getCollectionReaderMetaData().getTypeSystem());
        }
        list = this.getUimaCasProcessors();
        for (int i = 0; i < list.size(); ++i) {
            UimaCasProcessor u = (UimaCasProcessor)list.get(i);
            resolvedXmlFile = UimaApplication_Impl.resolveUimaXmlDescriptor(u.getXmlDescriptor());
            ResourceSpecifier specifier = null;
            try {
                specifier = UIMAFramework.getXMLParser().parseResourceSpecifier(new XMLInputSource(resolvedXmlFile));
            }
            catch (InvalidXMLException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (specifier == null) continue;
            typeSystemList.add(UimaApplication_Impl.getTypeSystemDescription(specifier));
        }
        try {
            mergedTypeSystemDescription = CasCreationUtils.mergeTypeSystems(typeSystemList);
        }
        catch (ResourceInitializationException e) {
            e.printStackTrace();
            return null;
        }
        mergedTypeSystemDescription.setName("Merged Type System for ???");
        String descr = "Merge TSs of: ";
        for (int i = 0; i < typeSystemList.size(); ++i) {
            if (i > 0) {
                descr = descr + ", ";
            }
            descr = descr + ((TypeSystemDescription)typeSystemList.get(i)).getName();
        }
        mergedTypeSystemDescription.setDescription(descr);
        return mergedTypeSystemDescription;
    }

    public static String toXML(TypeSystemDescription typeSystemDescription) {
        String tsDescString = null;
        StringWriter sw = new StringWriter();
        try {
            typeSystemDescription.toXML((Writer)sw);
            tsDescString = sw.toString();
            sw.close();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return tsDescString;
    }

    public void printErrorHandling(CasProcessorErrorHandling errorHandling) {
        Trace.trace("ErrorRateThreshold().getAction: " + errorHandling.getErrorRateThreshold().getAction());
        Trace.trace("ErrorRateThreshold().getMaxErrorCount: " + errorHandling.getErrorRateThreshold().getMaxErrorCount());
        Trace.trace("ErrorRateThreshold().getMaxErrorSampleSize: " + errorHandling.getErrorRateThreshold().getMaxErrorSampleSize());
    }

    public static UimaApplication getInstance() {
        return instance;
    }

    public void removeAll() {
        this.cpeHref = null;
        this.cpeConfiguration = null;
        this.defaultCasProcessorSettings.removeAll();
        this.uimaCollectionReaders.clear();
        this.uimaCasProcessors.clear();
    }

    public static CpeCheckpoint getCpeDefaultCheckpoint() {
        CpeCheckpoint c = CpeDescriptorFactory.produceCpeCheckpoint();
        c.setFrequency(600000, true);
        return c;
    }

    public static CasProcessorErrorHandling getCpeDefaultErrorHandling() {
        CpeIntegratedCasProcessor casProc = CpeDescriptorFactory.produceCasProcessor((String)"dummy name");
        return casProc.getErrorHandling();
    }

    public static void setCasProcessorErrorHandling(CpeCasProcessor casProc, CasProcessorErrorHandling errorHandling) {
        if (errorHandling == null) {
            return;
        }
        casProc.setActionOnMaxError(errorHandling.getErrorRateThreshold().getAction());
        casProc.setMaxErrorCount(errorHandling.getErrorRateThreshold().getMaxErrorCount());
        casProc.setMaxErrorSampleSize(errorHandling.getErrorRateThreshold().getMaxErrorSampleSize());
        casProc.setMaxRestartCount(errorHandling.getMaxConsecutiveRestarts().getRestartCount());
        casProc.setActionOnMaxRestart(errorHandling.getMaxConsecutiveRestarts().getAction());
        casProc.setTimeout(errorHandling.getTimeout().get());
    }

    public static UimaApplication createUimaApplication(ResourceManager rm) {
        UimaApplication_Impl.initUimaApplicationFramework();
        instance = new UimaApplication_Impl();
        instance.setResourceManager(rm);
        return instance;
    }

    public static UimaApplication createUimaApplication(String appXmlDescriptorFile) {
        UimaApplication_Impl.initUimaApplicationFramework();
        UimaApplication_Impl u = null;
        try {
            u = (UimaApplication_Impl)uimaXMLParser.parse(new XMLInputSource(appXmlDescriptorFile));
            String cpeXml = u.getCpeDescriptor();
            if (cpeXml != null && cpeXml.trim().length() > 0) {
                u.cpeHref = cpeXml;
                u.initUimaCasProcessors();
            }
        }
        catch (InvalidXMLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        instance = u;
        return u;
    }

    public static void populateCpeDescriptor(UimaApplication uimaApp) throws InvalidXMLException, ResourceInitializationException, CpeDescriptorException {
        UimaApplication_Impl u = (UimaApplication_Impl)uimaApp;
        String cpeXml = UimaApplication_Impl.resolveUimaXmlDescriptor(uimaApp.getCpeDescriptor());
        if (cpeXml != null && cpeXml.trim().length() > 0) {
            u.cpeHref = cpeXml;
            CpeDescription cpeDescription = null;
            try {
                cpeDescription = UIMAFramework.getXMLParser().parseCpeDescription(new XMLInputSource(new File(cpeXml)));
            }
            catch (InvalidXMLException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            u.addXMLizable(cpeXml, (XMLizable)cpeDescription);
        }
        instance = u;
    }

    public static UimaApplication createUimaApplication(String cpeXml, CpeDescription cpeDescription) {
        UimaApplication_Impl uimaApp = new UimaApplication_Impl();
        uimaApp.cpeHref = cpeXml;
        instance = uimaApp;
        return uimaApp;
    }

    public static UimaApplication createUimaApplication(UimaApplication uimaApp, String xmlFile, ResourceManager rm) throws InvalidXMLException, ResourceInitializationException, CpeDescriptorException, IOException {
        String resolvedXmlFile = UimaApplication_Impl.resolveUimaXmlDescriptor(xmlFile);
        XMLizable xmlLizable = null;
        InvalidXMLException invalidXMLException = null;
        try {
            xmlLizable = UimaXmlParsingUtil.parseUimaXmlDescriptor(resolvedXmlFile);
        }
        catch (InvalidXMLException e) {
            invalidXMLException = e;
            e.printStackTrace();
        }
        if (xmlLizable == null) {
            try {
                xmlLizable = UIMAFramework.getXMLParser().parseCpeDescription(new XMLInputSource(new File(resolvedXmlFile)));
            }
            catch (InvalidXMLException e) {
                invalidXMLException = e;
                e.printStackTrace();
            }
            if (xmlLizable == null) {
                if (invalidXMLException != null) {
                    throw invalidXMLException;
                }
                return null;
            }
        }
        if (xmlLizable instanceof UimaApplication) {
            uimaApp.setResourceManager(rm);
            UimaApplication_Impl.populateCpeDescriptor((UimaApplication)xmlLizable);
        } else if (xmlLizable instanceof CpeDescription) {
            if (uimaApp == null) {
                uimaApp = UimaApplication_Impl.createUimaApplication(rm);
            }
            uimaApp.addXMLizable(xmlFile, (XMLizable)((CpeDescription)xmlLizable));
        } else if (xmlLizable instanceof XMLizable) {
            if (uimaApp == null) {
                uimaApp = UimaApplication_Impl.createUimaApplication(rm);
            }
            uimaApp.addXMLizable(xmlFile, xmlLizable);
        }
        return uimaApp;
    }

    public static AbstractUimaCasProcessor createUimaComponent(String xmlDescriptor) throws InvalidXMLException, ResourceInitializationException, IOException {
        XMLizable xmlizable = UimaXmlParsingUtil.parseUimaXmlDescriptor(xmlDescriptor);
        if (xmlizable == null) {
            return null;
        }
        UimaCasProcessor_impl u = new UimaCasProcessor_impl();
        u.xmlizableDescriptor = xmlizable;
        u.xmlDescriptor = xmlDescriptor;
        if (xmlizable instanceof AnalysisEngineDescription) {
            AnalysisEngineMetaData a = ((AnalysisEngineDescription)xmlizable).getAnalysisEngineMetaData();
            u.setCasProcessorCategory(2);
            u.setInstanceName(a.getName());
            u.configParamDecls = a.getConfigurationParameterDeclarations();
            u.configParamSettings = a.getConfigurationParameterSettings();
        } else if (xmlizable instanceof CasConsumerDescription) {
            ProcessingResourceMetaData p = ((CasConsumerDescription)xmlizable).getCasConsumerMetaData();
            u.setCasProcessorCategory(4);
            u.setInstanceName(p.getName());
            u.configParamDecls = p.getConfigurationParameterDeclarations();
            u.configParamSettings = p.getConfigurationParameterSettings();
        } else if (xmlizable instanceof URISpecifier) {
            URISpecifier uriSpecifier = (URISpecifier)xmlizable;
            u.setCasProcessorCategory(6);
            String name = "Unknow";
            try {
                name = new URI(uriSpecifier.getUri()).getPath();
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
            u.setInstanceName(name);
        }
        u.configParamsModel = new ConfigParametersModel(u.configParamDecls, u.configParamSettings, null);
        return u;
    }

    public static TypePriorities getAnalysisEngineTypePriorities(XMLizable xmlizable, ResourceManager rm) throws InvalidXMLException, ResourceInitializationException {
        TypePriorities tp = null;
        if (xmlizable instanceof AnalysisEngineDescription) {
            AnalysisEngineDescription ae = (AnalysisEngineDescription)xmlizable;
            if (ae.isPrimitive()) {
                AnalysisEngineMetaData a = ((AnalysisEngineDescription)xmlizable).getAnalysisEngineMetaData();
                tp = ae.getAnalysisEngineMetaData().getTypePriorities();
            } else {
                tp = rm != null ? CasCreationUtils.mergeDelegateAnalysisEngineTypePriorities((AnalysisEngineDescription)ae, (ResourceManager)rm) : CasCreationUtils.mergeDelegateAnalysisEngineTypePriorities((AnalysisEngineDescription)ae);
            }
            if (tp != null) {
                if (rm != null) {
                    tp.resolveImports(rm);
                } else {
                    tp.resolveImports();
                }
                try {
                    tp.toXML((OutputStream)System.out);
                }
                catch (SAXException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return tp;
    }

    public TypePriorities getMergedTypePriorities() throws InvalidXMLException, ResourceInitializationException {
        TypePriorities tp;
        CollectionReaderDescription crDescr;
        TypePriorities mergedTp = null;
        ArrayList<TypePriorities> typePrioritiesList = new ArrayList<TypePriorities>();
        String aCollectionReaderPath = "";
        List list = this.getUimaCollectionReaders();
        Object cr = null;
        if (list != null && list.size() > 0 && (crDescr = (CollectionReaderDescription)((UimaCollectionReader)((Object)list.get(0))).getXmlizable()) != null && (tp = crDescr.getCollectionReaderMetaData().getTypePriorities()) != null) {
            typePrioritiesList.add(tp);
        }
        list = this.getUimaCasProcessors();
        for (int i = 0; i < list.size(); ++i) {
            UimaCasProcessor u = (UimaCasProcessor)list.get(i);
            XMLizable specifier = ((UimaCasProcessor_impl)u).getXmlizable();
            if (specifier == null || (tp = UimaApplication_Impl.getAnalysisEngineTypePriorities(specifier, this.getResourceManager())) == null) continue;
            typePrioritiesList.add(tp);
        }
        if (typePrioritiesList.size() > 0) {
            mergedTp = CasCreationUtils.mergeTypePriorities(typePrioritiesList, (ResourceManager)this.getResourceManager());
        }
        return mergedTp;
    }

    public void setCurrentDirectory(String currDir) {
        this.currentDir = currDir;
    }

    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public void setResourceManager(ResourceManager rm) {
        this.resourceManager = rm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String generateUimaApplicationXmlDescriptor(String xmlDescriptorFileName, boolean resolve) {
        StringWriter w = new StringWriter();
        FileOutputStream out = null;
        try {
            if (xmlDescriptorFileName != null && xmlDescriptorFileName.trim().length() > 0) {
                out = new FileOutputStream(xmlDescriptorFileName);
                this.toXML(out);
            }
            this.toXML(w);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return w.toString();
    }

    public String generateCpeXmlDescriptor(String outputXmlDescriptorFileName, boolean resolve) throws CpeDescriptorException, SAXException, IOException {
        ConfigParameterModel m;
        int k;
        CasProcessorConfigurationParameterSettings settings;
        List cpeOverrideList;
        StringWriter w = new StringWriter();
        CpeDescription cpeDesc = CpeDescriptorFactory.produceDescriptor();
        List list = this.getUimaCollectionReaders();
        if (list != null && list.size() > 0) {
            String aCollectionReaderPath = "";
            CpeCollectionReader cr = null;
            aCollectionReaderPath = ((UimaCollectionReader)((Object)list.get(0))).getXmlDescriptor();
            cr = resolve ? cpeDesc.addCollectionReader(UimaApplication_Impl.resolveUimaXmlDescriptor(aCollectionReaderPath)) : cpeDesc.addCollectionReader(aCollectionReaderPath);
            UimaCollectionReader ucr = (UimaCollectionReader)((Object)list.get(0));
            if (ucr.getConfigParamsModel() != null && (cpeOverrideList = ucr.getConfigParamsModel().getCpeParamModelList()) != null && cpeOverrideList.size() > 0) {
                settings = CpeDescriptorFactory.produceCasProcessorConfigurationParameterSettings();
                cr.setConfigurationParameterSettings(settings);
                for (k = 0; k < cpeOverrideList.size(); ++k) {
                    m = (ConfigParameterModel)cpeOverrideList.get(k);
                    if (m.getCpeValue() == null) continue;
                    settings.setParameterValue(m.getName(), m.getCpeValue());
                }
            }
        }
        if ((list = this.getUimaCasInitializers()) != null && list.size() > 0) {
            String aCasInitializerPath = "";
            CpeCollectionReaderCasInitializer ci = null;
            aCasInitializerPath = ((UimaCasInitializer)((Object)list.get(0))).getXmlDescriptor();
            ci = resolve ? cpeDesc.addCasInitializer(UimaApplication_Impl.resolveUimaXmlDescriptor(aCasInitializerPath)) : cpeDesc.addCasInitializer(aCasInitializerPath);
            UimaCasInitializer uci = (UimaCasInitializer)((Object)list.get(0));
            if (uci.getConfigParamsModel() != null && (cpeOverrideList = uci.getConfigParamsModel().getCpeParamModelList()) != null && cpeOverrideList.size() > 0) {
                settings = CpeDescriptorFactory.produceCasProcessorConfigurationParameterSettings();
                ci.setConfigurationParameterSettings(settings);
                for (k = 0; k < cpeOverrideList.size(); ++k) {
                    m = (ConfigParameterModel)cpeOverrideList.get(k);
                    if (m.getCpeValue() == null) continue;
                    settings.setParameterValue(m.getName(), m.getCpeValue());
                }
            }
        }
        list = this.getUimaCasProcessors();
        for (int i = 0; i < list.size(); ++i) {
            UimaCasProcessor u = (UimaCasProcessor)list.get(i);
            CpeIntegratedCasProcessor casProc = CpeDescriptorFactory.produceCasProcessor((String)u.getInstanceName());
            if (resolve) {
                casProc.setDescriptor(UimaApplication_Impl.resolveUimaXmlDescriptor(u.getXmlDescriptor()));
            } else {
                casProc.setDescriptor(u.getXmlDescriptor());
            }
            if (u.getCasProcessorErrorHandling() != null) {
                UimaApplication_Impl.setCasProcessorErrorHandling((CpeCasProcessor)casProc, u.getCasProcessorErrorHandling());
            }
            if (u.getBatchSize() != -1) {
                casProc.setBatchSize(u.getBatchSize());
            } else if (this.getDefaultCasProcessorSettings().getCasProcBatchSize() != -1) {
                casProc.setBatchSize(this.getDefaultCasProcessorSettings().getCasProcBatchSize());
            }
            cpeOverrideList = u.getConfigParamsModel().getCpeParamModelList();
            if (cpeOverrideList != null && cpeOverrideList.size() > 0) {
                settings = CpeDescriptorFactory.produceCasProcessorConfigurationParameterSettings();
                casProc.setConfigurationParameterSettings(settings);
                for (k = 0; k < cpeOverrideList.size(); ++k) {
                    m = (ConfigParameterModel)cpeOverrideList.get(k);
                    if (m.getCpeValue() == null) continue;
                    settings.setParameterValue(m.getName(), m.getCpeValue());
                }
            }
            cpeDesc.addCasProcessor((CpeCasProcessor)casProc);
        }
        CpeConfiguration cpeConfiguration = this.getCpeConfiguration();
        if (cpeConfiguration != null) {
            cpeDesc.getCpeConfiguration().setNumToProcess(cpeConfiguration.getNumToProcess());
            cpeDesc.getCpeConfiguration().setDeployment(cpeConfiguration.getDeployment());
            cpeDesc.getCpeConfiguration().getCheckpoint().setFrequency(cpeConfiguration.getCheckpoint().getFrequency(), cpeConfiguration.getCheckpoint().isTimeBased());
        }
        if (cpeDesc.getCpeCasProcessors() != null) {
            cpeDesc.getCpeCasProcessors().setPoolSize(this.cpeCasProcessorsSettings.getCasPoolSize());
        }
        cpeDesc.setProcessingUnitThreadCount(this.cpeCasProcessorsSettings.getProcessingUnitThreadCount());
        ((CpeCasProcessorsImpl)cpeDesc.getCpeCasProcessors()).setDropCasOnException(this.cpeCasProcessorsSettings.isDropCasOnException());
        FileOutputStream out = null;
        try {
            if (outputXmlDescriptorFileName != null && outputXmlDescriptorFileName.trim().length() > 0) {
                out = new FileOutputStream(outputXmlDescriptorFileName);
                cpeDesc.toXML((OutputStream)out);
            }
            ((CpeDescriptionImpl)cpeDesc).toXML((Writer)w);
        }
        catch (SAXException e) {
            e.printStackTrace();
            throw e;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw e;
                }
            }
        }
        return w.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int generateTypeSystemXmlDescriptor(String xmlFileName) {
        TypeSystemDescription tsd = this.getTypeSystemDescription();
        FileOutputStream out = null;
        try {
            if (xmlFileName != null && xmlFileName.trim().length() > 0) {
                out = new FileOutputStream(xmlFileName);
                tsd.toXML((OutputStream)out);
            }
        }
        catch (SAXException e) {
            e.printStackTrace();
            int n = -1;
            return n;
        }
        catch (IOException e) {
            e.printStackTrace();
            int n = -2;
            return n;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return -3;
                }
            }
        }
        return 0;
    }

    private boolean isCasConsumerSpecifier(ResourceSpecifier specifier) {
        if (specifier instanceof CasConsumerDescription) {
            return true;
        }
        if (specifier instanceof URISpecifier) {
            URISpecifier uriSpec = (URISpecifier)specifier;
            return "CasConsumer".equals(uriSpec.getResourceType());
        }
        return false;
    }

    public boolean compareWithDefaultCasProcessorErrorRateThreshold(CasProcessorErrorRateThreshold threshold1, CasProcessorErrorRateThreshold threshold2) {
        if (threshold1.getMaxErrorCount() != threshold2.getMaxErrorCount()) {
            return false;
        }
        if (threshold1.getMaxErrorSampleSize() != threshold2.getMaxErrorSampleSize()) {
            return false;
        }
        return threshold1.getAction().equalsIgnoreCase(threshold2.getAction());
    }

    public boolean compareWithDefaultCasProcessorMaxRestarts(CasProcessorMaxRestarts maxRestart1, CasProcessorMaxRestarts maxRestart2) {
        if (maxRestart1.getRestartCount() != maxRestart2.getRestartCount()) {
            return false;
        }
        return maxRestart1.getAction().equalsIgnoreCase(maxRestart2.getAction());
    }

    public boolean compareWithCpeDefaultErrorHandling(CasProcessorErrorHandling errorHandling) {
        CasProcessorErrorHandling def = null;
        if (this.defaultCasProcessorSettings != null) {
            def = this.defaultCasProcessorSettings.getErrorHandling();
        }
        if (def == null) {
            def = this.cpeDefaultErrorHandling;
        }
        if (def != null) {
            if (!this.compareWithDefaultCasProcessorErrorRateThreshold(errorHandling.getErrorRateThreshold(), def.getErrorRateThreshold())) {
                return false;
            }
            if (!this.compareWithDefaultCasProcessorMaxRestarts(errorHandling.getMaxConsecutiveRestarts(), def.getMaxConsecutiveRestarts())) {
                return false;
            }
            return errorHandling.getTimeout().get() == def.getTimeout().get();
        }
        Trace.bug("Cannot get CpeDefaultErrorHandling");
        return false;
    }

    public void addCpeDescription(String cpeXml, CpeDescription cpeDescription) throws InvalidXMLException, ResourceInitializationException, CpeDescriptorException {
        String newFileLocation;
        int error = 0;
        int details = 0;
        this.cpeHref = cpeXml;
        try {
            if (this.cpeConfiguration != null) {
                this.cpeConfiguration = cpeDescription.getCpeConfiguration();
            }
        }
        catch (CpeDescriptorException e1) {
            e1.printStackTrace();
        }
        CpeCollectionReader[] collRdrs = null;
        try {
            collRdrs = cpeDescription.getAllCollectionCollectionReaders();
        }
        catch (CpeDescriptorException e) {
            e.printStackTrace();
        }
        boolean testIt = false;
        if (testIt && collRdrs != null && collRdrs.length > 0) {
            String xml;
            AbstractUimaCasProcessor u;
            for (int i = 0; i < collRdrs.length; ++i) {
                File f;
                CpeComponentDescriptor cpeComponentDescriptor = collRdrs[i].getDescriptor();
                String xml2 = null;
                if (cpeComponentDescriptor.getInclude() != null) {
                    xml2 = cpeComponentDescriptor.getInclude().get();
                } else if (cpeComponentDescriptor.getImport() != null && (xml2 = cpeComponentDescriptor.getImport().getLocation()) == null) {
                    xml2 = cpeComponentDescriptor.getImport().getName();
                }
                if (xml2 == null || xml2.trim().length() == 0) continue;
                newFileLocation = xml2;
                String resolvedFileName = UimaApplication_Impl.resolveUimaXmlDescriptor(xml2);
                if (resolvedFileName != null && !(f = new File(resolvedFileName)).isAbsolute() && !f.exists()) {
                    f = new File(this.currentDir, resolvedFileName);
                    if (!f.exists()) {
                        Trace.trace("*** ERROR: Cannot find file: " + resolvedFileName);
                        error = 2;
                        details = 1;
                    }
                    newFileLocation = resolvedFileName = f.getAbsolutePath();
                }
                u = UimaCollectionReader.createUimaCasProcessor(collRdrs[i], newFileLocation, (UimaApplication)this);
                if (error > 0) {
                    u.setStatus(error);
                    u.setStatusDetails(details);
                }
                this.uimaCollectionReaders.add(u);
            }
            CpeCollectionReaderCasInitializer casInit = null;
            try {
                casInit = collRdrs[0].getCasInitializer();
            }
            catch (CpeDescriptorException e) {
                e.printStackTrace();
            }
            if (casInit != null && (xml = casInit.getDescriptor().getInclude().get()) != null && xml.trim().length() != 0) {
                String newFileLocation2 = xml;
                String resolvedFileName = UimaApplication_Impl.resolveUimaXmlDescriptor(xml);
                File f = new File(resolvedFileName);
                error = 0;
                details = 0;
                if (!f.isAbsolute() && !f.exists()) {
                    f = new File(this.currentDir, resolvedFileName);
                    if (!f.exists()) {
                        error = 2;
                        details = 1;
                    }
                    newFileLocation2 = resolvedFileName = f.getAbsolutePath();
                }
                u = UimaCasInitializer.createUimaCasProcessor(casInit, newFileLocation2, (UimaApplication)this);
                if (error > 0) {
                    u.setStatus(error);
                    u.setStatusDetails(details);
                }
                this.uimaCasInitializers.add(u);
            }
        }
        if (this.cpeCasProcessorsSettings == null) {
            this.cpeCasProcessorsSettings = new CpeCasProcessorsSettings();
        }
        try {
            this.cpeCasProcessorsSettings.setCasPoolSize(((CpeCasProcessorsImpl)cpeDescription.getCpeCasProcessors()).getPoolSize());
            this.cpeCasProcessorsSettings.setDropCasOnException(((CpeCasProcessorsImpl)cpeDescription.getCpeCasProcessors()).getDropCasOnException());
        }
        catch (CpeDescriptorException e1) {
            e1.printStackTrace();
        }
        CpeCasProcessor[] casProcs = null;
        try {
            casProcs = cpeDescription.getCpeCasProcessors().getAllCpeCasProcessors();
        }
        catch (CpeDescriptorException e) {
            e.printStackTrace();
        }
        if (casProcs == null) {
            return;
        }
        for (int i = 0; i < casProcs.length; ++i) {
            UimaCasProcessor u;
            CpeComponentDescriptor cpeComponentDescriptor = casProcs[i].getCpeComponentDescriptor();
            newFileLocation = null;
            if (cpeComponentDescriptor.getInclude() != null) {
                newFileLocation = cpeComponentDescriptor.getInclude().get();
            } else if (cpeComponentDescriptor.getImport() != null && (newFileLocation = cpeComponentDescriptor.getImport().getLocation()) == null) {
                newFileLocation = cpeComponentDescriptor.getImport().getName();
            }
            String specifierFile = UimaApplication_Impl.resolveUimaXmlDescriptor(newFileLocation);
            ResourceSpecifier specifier = null;
            if (specifierFile == null || specifierFile.trim().length() == 0) continue;
            File f = new File(specifierFile);
            error = 0;
            details = 0;
            if (!f.isAbsolute()) {
                if (!f.exists()) {
                    f = new File(this.currentDir, specifierFile);
                    if (!f.exists()) {
                        error = 2;
                        details = 1;
                    }
                    newFileLocation = specifierFile = f.getAbsolutePath();
                }
            } else if (!f.exists()) {
                error = 2;
                details = 1;
            }
            if (error == 0) {
                try {
                    specifier = UIMAFramework.getXMLParser().parseResourceSpecifier(new XMLInputSource(specifierFile));
                }
                catch (InvalidXMLException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    continue;
                }
            }
            if ((u = this.getUimaCasProcessor(casProcs[i].getName())) != null) {
                Trace.err("Duplicate with CasProcessor from CPE: " + casProcs[i].getName());
                if (testIt) {
                    UimaCasProcessor_impl.createUimaCasProcessorFrom(u, casProcs[i], specifier, this);
                } else {
                    u.setCpeCasProcessor(casProcs[i]);
                }
            } else {
                u = UimaCasProcessor_impl.createUimaCasProcessor(casProcs[i], specifier, (UimaApplication)this);
                this.uimaCasProcessors.add(u);
            }
            if (error > 0) {
                u.setStatus(error);
                u.setStatusDetails(details);
            }
            ((AbstractUimaCasProcessor)((Object)u)).setXmlDescriptor(newFileLocation);
            if (this.cpeDefaultErrorHandling == null) {
                this.cpeDefaultErrorHandling = CpeDescriptorFactory.produceCasProcessorErrorHandling();
            }
            if (!this.compareWithCpeDefaultErrorHandling(casProcs[i].getErrorHandling())) {
                u.setCasProcessorErrorHandling(casProcs[i].getErrorHandling());
            }
            u.setBatchSize(casProcs[i].getBatchSize());
        }
    }

    public Object addXMLizable(String xmlizableXmlFile, XMLizable xmlizable) throws InvalidXMLException, ResourceInitializationException, CpeDescriptorException {
        Object component = null;
        if (xmlizable instanceof CollectionReaderDescription) {
            UimaCollectionReader u = UimaCollectionReader.createUimaCasProcessor((CollectionReaderDescription)xmlizable, xmlizableXmlFile, (UimaApplication)this);
            this.uimaCollectionReaders.add(u);
            component = u;
        } else if (xmlizable instanceof CasInitializerDescription) {
            UimaCasInitializer ci = UimaCasInitializer.createUimaCasProcessor((CasInitializerDescription)xmlizable, xmlizableXmlFile, (UimaApplication)this);
            this.uimaCasInitializers.add(ci);
            component = ci;
        } else if (xmlizable instanceof CpeDescription) {
            this.addCpeDescription(xmlizableXmlFile, (CpeDescription)xmlizable);
            component = this;
        } else {
            CpeIntegratedCasProcessor cpeCasProcessor = CpeDescriptorFactory.produceCasProcessor((String)"xmlizableXmlFile");
            cpeCasProcessor.setDescriptor(xmlizableXmlFile);
            UimaCasProcessor u = UimaCasProcessor_impl.createUimaCasProcessor((CpeCasProcessor)cpeCasProcessor, xmlizable, (UimaApplication)this);
            this.uimaCasProcessors.add(u);
            cpeCasProcessor.setName(u.getInstanceName());
            component = u;
        }
        return component;
    }

    public static boolean isValidXMLizableComponent(XMLizable xmlizable) {
        return xmlizable instanceof CollectionReaderDescription || xmlizable instanceof CasInitializerDescription || xmlizable instanceof AnalysisEngineDescription || xmlizable instanceof TaeDescription || xmlizable instanceof CasConsumerDescription || xmlizable instanceof URISpecifier || xmlizable instanceof CustomResourceSpecifier || xmlizable instanceof CpeDescription;
    }

    public UimaCollectionReader getUimaCollectionReader() {
        if (this.uimaCollectionReaders != null && this.uimaCollectionReaders.size() > 0) {
            return (UimaCollectionReader)((Object)this.uimaCollectionReaders.get(0));
        }
        return null;
    }

    public UimaCollectionReader getUimaCollectionReader(String name) {
        if (this.uimaCollectionReaders != null) {
            for (int i = 0; i < this.uimaCollectionReaders.size(); ++i) {
                if (!name.equalsIgnoreCase(((UimaCollectionReader)((Object)this.uimaCollectionReaders.get(i))).getInstanceName())) continue;
                return (UimaCollectionReader)((Object)this.uimaCollectionReaders.get(i));
            }
        }
        return null;
    }

    public UimaCasProcessor getUimaCasProcessor(String name) {
        if (this.uimaCasProcessors != null) {
            for (int i = 0; i < this.uimaCasProcessors.size(); ++i) {
                if (!name.equalsIgnoreCase(((UimaCasProcessor)this.uimaCasProcessors.get(i)).getInstanceName())) continue;
                return (UimaCasProcessor)this.uimaCasProcessors.get(i);
            }
        }
        return null;
    }

    public boolean deleteUimaCasProcessor(AbstractUimaCasProcessor u) {
        List list = u.isUimaCollectionReader() ? this.uimaCollectionReaders : (u.isUimaCasInitializer() ? this.uimaCasInitializers : this.uimaCasProcessors);
        for (int i = 0; i < list.size(); ++i) {
            if (u != list.get(i)) continue;
            list.remove(i);
            return true;
        }
        return false;
    }

    public boolean moveUimaCasProcessor(AbstractUimaCasProcessor u, boolean moveUp) {
        List list = u.isUimaCollectionReader() ? this.uimaCollectionReaders : this.uimaCasProcessors;
        int index = list.indexOf((Object)u);
        if (moveUp) {
            if (index != 0) {
                list.remove(index);
                list.add(index - 1, u);
                return true;
            }
        } else if (index != list.size() - 1) {
            list.remove(index);
            list.add(index + 1, u);
            return true;
        }
        return false;
    }

    public int isMovable(AbstractUimaCasProcessor u) {
        List list = u.isUimaCollectionReader() ? this.uimaCollectionReaders : (u.isUimaCasInitializer() ? this.uimaCasInitializers : this.uimaCasProcessors);
        int index = list.indexOf((Object)u);
        int flags = 0;
        if (index != 0) {
            flags = 1;
        }
        if (index != list.size() - 1) {
            flags |= 2;
        }
        return flags;
    }

    public boolean deleteUimaCasProcessor_1(UimaCasProcessor u) {
        for (int i = 0; i < this.uimaCasProcessors.size(); ++i) {
            if (u != this.uimaCasProcessors.get(i)) continue;
            this.uimaCasProcessors.remove(i);
            return true;
        }
        Trace.bug("CANNOT find for deletion: " + u.getInstanceName());
        return false;
    }

    public boolean moveUimaCasProcessor_1(UimaCasProcessor u, boolean moveUp) {
        int index = this.uimaCasProcessors.indexOf(u);
        if (moveUp) {
            if (index != 0) {
                this.uimaCasProcessors.remove(index);
                this.uimaCasProcessors.add(index - 1, u);
                return true;
            }
        } else if (index != this.uimaCasProcessors.size() - 1) {
            this.uimaCasProcessors.remove(index);
            this.uimaCasProcessors.add(index + 1, u);
            return true;
        }
        return false;
    }

    public String prettyPrintModel(XMLizable trueDescriptor) {
        StringWriter writer = new StringWriter();
        String parsedText = null;
        try {
            XMLSerializer xmlSerializer = new XMLSerializer(true);
            xmlSerializer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            xmlSerializer.setWriter((Writer)writer);
            ContentHandler contentHandler = xmlSerializer.getContentHandler();
            contentHandler.startDocument();
            if (trueDescriptor instanceof AnalysisEngineDescription) {
                AnalysisEngineDescription aed = (AnalysisEngineDescription)trueDescriptor;
                aed.toXML(contentHandler, true, true);
            } else {
                trueDescriptor.toXML(contentHandler, true);
            }
            contentHandler.endDocument();
            writer.close();
            parsedText = writer.toString();
        }
        catch (SAXException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        return parsedText;
    }

    public void toXML(ContentHandler aContentHandler, boolean aWriteDefaultNamespaceAttribute) throws SAXException {
        int i;
        AttributesImpl attrs = new AttributesImpl();
        aContentHandler.startElement(this.getXmlizationInfo().namespace, "uimaApplication", "uimaApplication", attrs);
        if (this.getCpeDescriptor() != null) {
            attrs.addAttribute("", "href", "href", null, this.getCpeDescriptor());
        }
        aContentHandler.startElement(this.getXmlizationInfo().namespace, "", "cpeDescription", attrs);
        aContentHandler.endElement(this.getXmlizationInfo().namespace, "", "cpeDescription");
        attrs.clear();
        aContentHandler.startElement(this.getXmlizationInfo().namespace, "", "deploymentDefaultSettings", attrs);
        aContentHandler.startElement(this.getXmlizationInfo().namespace, "", "errorHandling", attrs);
        attrs.clear();
        CasProcessorErrorHandling errorHandling = this.getDefaultCasProcessorSettings().getErrorHandling();
        if (errorHandling != null) {
            attrs.addAttribute("", "action", "action", null, errorHandling.getErrorRateThreshold().getAction());
            attrs.addAttribute("", "count", "count", null, "" + errorHandling.getErrorRateThreshold().getMaxErrorCount());
            attrs.addAttribute("", "sample_size", "sample_size", null, "" + errorHandling.getErrorRateThreshold().getMaxErrorSampleSize());
            aContentHandler.startElement(this.getXmlizationInfo().namespace, "", "errorRateThreshold", attrs);
            aContentHandler.endElement(this.getXmlizationInfo().namespace, "", "errorRateThreshold");
        }
        aContentHandler.endElement(this.getXmlizationInfo().namespace, "", "errorHandling");
        attrs.clear();
        attrs.addAttribute("", "batch", "batch", null, "" + this.getDefaultCasProcessorSettings().getCasProcBatchSize());
        aContentHandler.startElement(this.getXmlizationInfo().namespace, "", "checkpoint", attrs);
        aContentHandler.endElement(this.getXmlizationInfo().namespace, "", "checkpoint");
        aContentHandler.endElement(this.getXmlizationInfo().namespace, "", "deploymentDefaultSettings");
        List list = this.getUimaCollectionReaders();
        for (i = 0; i < list.size(); ++i) {
            ((UimaCollectionReader)((Object)list.get(i))).toXML(aContentHandler, aWriteDefaultNamespaceAttribute);
        }
        list = this.getUimaCasInitializers();
        for (i = 0; i < list.size(); ++i) {
            attrs.clear();
            UimaCasInitializer u = (UimaCasInitializer)((Object)list.get(i));
            attrs.addAttribute("", "name", "name", null, "" + u.getInstanceName());
            aContentHandler.startElement(this.getXmlizationInfo().namespace, "", "deploymentOverrides", attrs);
            attrs.clear();
            aContentHandler.startElement(this.getXmlizationInfo().namespace, "", "deploymentSettings", attrs);
            aContentHandler.endElement(this.getXmlizationInfo().namespace, "", "deploymentSettings");
            List cpeOverrideList = u.getConfigParamsModel().getCpeParamModelList();
            if (cpeOverrideList != null && cpeOverrideList.size() > 0) {
                aContentHandler.startElement(this.getXmlizationInfo().namespace, "", "configurationParameterSettings", attrs);
                CasProcessorConfigurationParameterSettings settings = CpeDescriptorFactory.produceCasProcessorConfigurationParameterSettings();
                for (int k = 0; k < cpeOverrideList.size(); ++k) {
                    ConfigParameterModel m = (ConfigParameterModel)cpeOverrideList.get(k);
                    if (m.getCpeValue() == null) continue;
                    settings.setParameterValue(m.getName(), m.getCpeValue());
                    m.toXML(aContentHandler, aWriteDefaultNamespaceAttribute);
                }
                aContentHandler.endElement(this.getXmlizationInfo().namespace, "", "configurationParameterSettings");
            }
            aContentHandler.endElement(this.getXmlizationInfo().namespace, "", "deploymentOverrides");
        }
        list = this.getUimaCasProcessors();
        for (i = 0; i < list.size(); ++i) {
            ((UimaCasProcessor)list.get(i)).toXML(aContentHandler, aWriteDefaultNamespaceAttribute);
        }
        aContentHandler.endElement(this.getXmlizationInfo().namespace, "uimaApplication", "uimaApplication");
    }

    protected XmlizationInfo getXmlizationInfo() {
        return new XmlizationInfo(null, null);
    }

    public void buildFromXMLElement(Element aElement, XMLParser aParser, XMLParser.ParsingOptions aOptions) throws InvalidXMLException {
        NodeList childNodes = aElement.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node curNode = childNodes.item(i);
            if (!(curNode instanceof Element)) continue;
            Element elem = (Element)curNode;
            if ("cpeDescription".equals(elem.getTagName())) {
                this.setCpeDescriptor(elem.getAttribute("href"));
                continue;
            }
            if ("uimaCollectionReader".equals(elem.getTagName())) {
                this.uimaCollectionReaders.add(aParser.buildObject(elem, aOptions));
                continue;
            }
            if ("uimaCasProcessor".equals(elem.getTagName())) {
                this.uimaCasProcessors.add(aParser.buildObject(elem, aOptions));
                continue;
            }
            if ("deploymentDefaultSettings".equals(elem.getTagName())) {
                this.buildDefaultCasProcessorSettings(elem, aParser);
                continue;
            }
            Trace.err("Unknown Tag: " + elem.getTagName());
        }
    }

    private void buildCasProcessorSettingsOverride(Element aElement, XMLParser aParser) throws InvalidXMLException {
        NodeList childNodes = aElement.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Element elem;
            Node curNode = childNodes.item(i);
            if (curNode instanceof Element && !"errorHandling".equals((elem = (Element)curNode).getTagName())) continue;
        }
    }

    private void buildDefaultCasProcessorSettings(Element aElement, XMLParser aParser) throws InvalidXMLException {
        NodeList childNodes = aElement.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node curNode = childNodes.item(i);
            if (!(curNode instanceof Element)) continue;
            Element elem = (Element)curNode;
            if ("errorHandling".equals(elem.getTagName())) {
                NodeList cNodes = elem.getChildNodes();
                CasProcessorErrorHandling errorHandling = null;
                for (int j = 0; j < cNodes.getLength(); ++j) {
                    Node node = cNodes.item(j);
                    if (!(node instanceof Element)) continue;
                    Element e = (Element)node;
                    if ("errorRateThreshold".equals(e.getTagName())) {
                        if (errorHandling == null) {
                            errorHandling = UimaApplication_Impl.getCpeDefaultErrorHandling();
                        }
                        errorHandling.getErrorRateThreshold().setAction(e.getAttribute("action"));
                        errorHandling.getErrorRateThreshold().setMaxErrorCount(Integer.parseInt(e.getAttribute("count")));
                        errorHandling.getErrorRateThreshold().setMaxErrorSampleSize(Integer.parseInt(e.getAttribute("sample_size")));
                        continue;
                    }
                    if ("maxConsecutiveRestarts".equals(e.getTagName())) {
                        if (errorHandling != null) continue;
                        errorHandling = UimaApplication_Impl.getCpeDefaultErrorHandling();
                        continue;
                    }
                    if (!"timeout".equals(e.getTagName()) || errorHandling != null) continue;
                    errorHandling = UimaApplication_Impl.getCpeDefaultErrorHandling();
                }
                if (errorHandling == null) continue;
                this.getDefaultCasProcessorSettings().setErrorHandling(errorHandling);
                continue;
            }
            if ("checkpoint".equals(elem.getTagName())) continue;
            throw new InvalidXMLException("unknown_element", new Object[]{elem.getTagName()});
        }
    }

    public String getCpeDescriptor() {
        return this.cpeHref;
    }

    public void setCpeDescriptor(String descriptor) {
        this.cpeHref = descriptor;
    }

    public void test() {
    }

    public void initUimaCasProcessors() {
    }

    public List getUimaCollectionReaders() {
        return this.uimaCollectionReaders;
    }

    public List getUimaCasInitializers() {
        return this.uimaCasInitializers;
    }

    public List getUimaCasProcessors() {
        return this.uimaCasProcessors;
    }

    public CpeConfiguration getCpeConfiguration() {
        return this.cpeConfiguration;
    }

    public void setCpeConfiguration(CpeConfiguration cpeConfiguration) {
        this.cpeConfiguration = cpeConfiguration;
    }

    public DefaultCasProcessorSettings getDefaultCasProcessorSettings() {
        return this.defaultCasProcessorSettings;
    }

    public void setDefaultCasProcessorSettings(DefaultCasProcessorSettings defaultCasProcessorSettings) {
        this.defaultCasProcessorSettings = defaultCasProcessorSettings;
    }

    public void printMe() {
        Trace.out("Cpe xml:" + this.getCpeDescriptor());
    }

    public CpeCasProcessorsSettings getCpeCasProcessorsSettings() {
        return this.cpeCasProcessorsSettings;
    }

    public void setCpeCasProcessorsSettings(CpeCasProcessorsSettings cpeCasProcessorsSettings) {
        this.cpeCasProcessorsSettings = cpeCasProcessorsSettings;
    }

    public IRuntimeContext getRuntimeContext() {
        return this.runtimeContext;
    }

    public void setRuntimeContext(IRuntimeContext runtimeContext) {
        this.runtimeContext = runtimeContext;
    }

    static {
        instance = null;
        isInitialized_UimaApplicationFramework = false;
        stringSubstitutionManager = null;
        XMLIZATION_INFO = new XmlizationInfo("uimaApplication", new PropertyXmlInfo[]{new PropertyXmlInfo("cpeDescriptor", false), new PropertyXmlInfo("defaultCasProcessorSettings", false)});
    }
}

