/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.dde.internal.provider;

import java.util.List;
import org.apache.uima.aae.deployment.AEDeploymentDescription;
import org.apache.uima.aae.deployment.AEDeploymentMetaData;
import org.apache.uima.aae.deployment.AsyncAggregateErrorConfiguration;
import org.apache.uima.aae.deployment.AsyncPrimitiveErrorConfiguration;
import org.apache.uima.aae.deployment.CollectionProcessCompleteErrors;
import org.apache.uima.aae.deployment.GetMetadataErrors;
import org.apache.uima.aae.deployment.ProcessCasErrors;
import org.apache.uima.aae.deployment.RemoteAEDeploymentMetaData;
import org.apache.uima.aae.deployment.impl.AEDelegates_Impl;
import org.apache.uima.tools.debug.util.Trace;
import org.apache.uima.util.InvalidXMLException;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class DDTreeContentProvider
implements IStructuredContentProvider,
ITreeContentProvider {
    private static final Object[] EMPTY_ARRAY = new Object[0];

    public Object[] getChildren(Object parent) {
        Object[] objs = null;
        int count = 0;
        if (parent instanceof AEDeploymentMetaData) {
            AEDeploymentMetaData metaData = (AEDeploymentMetaData)parent;
            if (metaData.isAsync() && metaData.getDelegates() != null) {
                List list = metaData.getDelegates().getDelegates();
                return list.toArray();
            }
        } else if (parent instanceof RemoteAEDeploymentMetaData) {
            RemoteAEDeploymentMetaData metaData = (RemoteAEDeploymentMetaData)parent;
        } else {
            if (parent instanceof AEDelegates_Impl) {
                return ((AEDelegates_Impl)parent).getDelegates().toArray();
            }
            if (parent instanceof AsyncAggregateErrorConfiguration) {
                AsyncAggregateErrorConfiguration errorConfig = (AsyncAggregateErrorConfiguration)parent;
            } else {
                if (parent instanceof GetMetadataErrors) {
                    GetMetadataErrors getMetadataErrors = (GetMetadataErrors)parent;
                    objs = new Object[]{"MaxRetries: " + getMetadataErrors.getMaxRetries(), "Timeout: " + getMetadataErrors.getTimeout(), "Error Action: " + getMetadataErrors.getErrorAction()};
                    return objs;
                }
                if (parent instanceof ProcessCasErrors) {
                    ProcessCasErrors processCasErrors = (ProcessCasErrors)parent;
                    objs = new Object[]{"MaxRetries: " + processCasErrors.getMaxRetries(), "Timeout: " + processCasErrors.getTimeout(), "ContinueOnRetryFailure: " + processCasErrors.isContinueOnRetryFailure(), "Threshold Count: " + processCasErrors.getThresholdCount(), "Threshold Window: " + processCasErrors.getThresholdWindow(), "Threshold Action: " + processCasErrors.getThresholdAction()};
                    return objs;
                }
                if (parent instanceof CollectionProcessCompleteErrors) {
                    CollectionProcessCompleteErrors completeErrors = (CollectionProcessCompleteErrors)parent;
                    objs = new Object[]{"Timeout: " + completeErrors.getTimeout(), "Additional Error Action: " + completeErrors.getAdditionalErrorAction()};
                    return objs;
                }
                if (parent instanceof AsyncPrimitiveErrorConfiguration) {
                    AsyncPrimitiveErrorConfiguration errorConfig = (AsyncPrimitiveErrorConfiguration)parent;
                    if (errorConfig.hasImport()) {
                        String importBy = "import ";
                        importBy = errorConfig.isImportByLocation() ? importBy + " location=" + errorConfig.getImportedDescriptor() : importBy + " name=" + errorConfig.getImportedDescriptor();
                        objs = new Object[]{importBy};
                        return objs;
                    }
                    if (errorConfig.getGetMetadataErrors() != null) {
                        ++count;
                    }
                    if (errorConfig.getProcessCasErrors() != null) {
                        ++count;
                    }
                    if (errorConfig.getCollectionProcessCompleteErrors() != null) {
                        ++count;
                    }
                    objs = new Object[count];
                    int index = 0;
                    if (errorConfig.getGetMetadataErrors() != null) {
                        objs[index++] = errorConfig.getGetMetadataErrors();
                    }
                    if (errorConfig.getProcessCasErrors() != null) {
                        objs[index++] = errorConfig.getProcessCasErrors();
                    }
                    if (errorConfig.getCollectionProcessCompleteErrors() != null) {
                        objs[index++] = errorConfig.getCollectionProcessCompleteErrors();
                    }
                    return objs;
                }
            }
        }
        return EMPTY_ARRAY;
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object parent) {
        return this.getChildren(parent).length > 0;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof AEDeploymentDescription) {
            AEDeploymentMetaData metaData = null;
            try {
                metaData = ((AEDeploymentDescription)inputElement).getAeService().getAnalysisEngineDeploymentMetaData();
            }
            catch (InvalidXMLException e) {
                e.printStackTrace();
            }
            if (metaData != null) {
                Object[] objs = new Object[]{metaData};
                return objs;
            }
        }
        Trace.err((String)("inputElement: " + inputElement.getClass().getName()));
        return EMPTY_ARRAY;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

