/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.textruler.core;

import org.apache.uima.ruta.textruler.core.TextRulerBasicLearner;

public class TextRulerTarget {
    public String[] slotNames;
    public MLTargetType type;
    private TextRulerBasicLearner learner;
    private int maxShiftDistance = 0;

    public TextRulerTarget(TextRulerTarget copyFrom, TextRulerBasicLearner owner) {
        this.slotNames = (String[])copyFrom.slotNames.clone();
        this.type = copyFrom.type;
        this.learner = owner;
    }

    public TextRulerTarget(String[] slotNames, TextRulerBasicLearner owner) {
        this.slotNames = slotNames;
        this.type = MLTargetType.MULTI_SLOT;
        this.learner = owner;
    }

    public TextRulerTarget(String slotName, TextRulerBasicLearner owner) {
        this.slotNames = new String[1];
        this.slotNames[0] = slotName;
        this.type = MLTargetType.SINGLE_WHOLE_SLOT;
        this.learner = owner;
    }

    public TextRulerBasicLearner getLearner() {
        return this.learner;
    }

    public TextRulerTarget(String slotName, MLTargetType type, TextRulerBasicLearner owner) {
        this.slotNames = new String[1];
        this.slotNames[0] = slotName;
        this.type = type;
        this.learner = owner;
    }

    public String getMultiSlotTypeName(int slotIndex) {
        return this.slotNames[slotIndex];
    }

    public String getSingleSlotRawTypeName() {
        return this.slotNames[0];
    }

    public String getSingleSlotTypeName() {
        return TextRulerTarget.getSingleSlotTypeName(this.type, this.slotNames[0]);
    }

    public static String getSingleSlotTypeName(MLTargetType t, String slotName) {
        if (t == MLTargetType.MULTI_SLOT) {
            return null;
        }
        if (t == MLTargetType.SINGLE_LEFT_BOUNDARY) {
            return slotName + "START";
        }
        if (t == MLTargetType.SINGLE_RIGHT_BOUNDARY) {
            return slotName + "END";
        }
        return slotName;
    }

    public String[] getRawSlotNames() {
        return this.slotNames;
    }

    public String[] getSlotTypeNames() {
        if (this.type == MLTargetType.MULTI_SLOT) {
            return this.slotNames;
        }
        String[] result = new String[]{this.getSingleSlotTypeName()};
        return result;
    }

    public boolean isMultiSlot() {
        return this.type == MLTargetType.MULTI_SLOT;
    }

    public boolean isBoundary() {
        return this.type == MLTargetType.SINGLE_LEFT_BOUNDARY || this.type == MLTargetType.SINGLE_RIGHT_BOUNDARY;
    }

    public boolean isLeftBoundary() {
        return this.type == MLTargetType.SINGLE_LEFT_BOUNDARY;
    }

    public boolean isRightBoundary() {
        return this.type == MLTargetType.SINGLE_RIGHT_BOUNDARY;
    }

    public boolean isLeftCorrection() {
        return this.type == MLTargetType.SINGLE_LEFT_CORRECTION;
    }

    public boolean isRightCorrection() {
        return this.type == MLTargetType.SINGLE_RIGHT_CORRECTION;
    }

    public TextRulerTarget getCounterPartBoundaryTarget() {
        if (!this.isBoundary()) {
            return null;
        }
        if (this.type == MLTargetType.SINGLE_LEFT_BOUNDARY) {
            return new TextRulerTarget(this.slotNames[0], MLTargetType.SINGLE_RIGHT_BOUNDARY, this.learner);
        }
        return new TextRulerTarget(this.slotNames[0], MLTargetType.SINGLE_LEFT_BOUNDARY, this.learner);
    }

    public int getMaxShiftDistance() {
        return this.maxShiftDistance;
    }

    public void setMaxShiftDistance(int maxShiftDistance) {
        this.maxShiftDistance = maxShiftDistance;
    }

    public boolean equals(Object o) {
        TextRulerTarget t = (TextRulerTarget)o;
        if (t.slotNames.length != this.slotNames.length) {
            return false;
        }
        for (int i = 0; i < this.slotNames.length; ++i) {
            if (this.slotNames[i].equals(t.slotNames[i])) continue;
            return false;
        }
        return this.type == t.type;
    }

    public int hashCode() {
        return this.slotNames.hashCode() * this.type.hashCode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MLTargetType {
        MULTI_SLOT,
        SINGLE_WHOLE_SLOT,
        SINGLE_LEFT_BOUNDARY,
        SINGLE_RIGHT_BOUNDARY,
        SINGLE_LEFT_CORRECTION,
        SINGLE_RIGHT_CORRECTION;

    }
}

