/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.testing.evaluator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.CASRuntimeException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.seed.DefaultSeeder;
import org.apache.uima.ruta.testing.evaluator.AbstractCasEvaluator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WordAccuracyCasEvaluator
extends AbstractCasEvaluator {
    @Override
    public CAS evaluate(CAS test, CAS run, Collection<String> excludedTypes) throws CASRuntimeException, CASException {
        Type annotationType = test.getAnnotationType();
        Type falsePositiveType = run.getTypeSystem().getType("org.apache.uima.ruta.type.FalsePositive");
        Type falseNegativeType = run.getTypeSystem().getType("org.apache.uima.ruta.type.FalseNegative");
        Type truePositveType = run.getTypeSystem().getType("org.apache.uima.ruta.type.TruePositive");
        Feature feature = falsePositiveType.getFeatureByBaseName("original");
        List allTypes = test.getTypeSystem().getProperlySubsumedTypes(annotationType);
        ArrayList<Type> types = new ArrayList<Type>();
        for (Type eachType : allTypes) {
            int size = test.getAnnotationIndex(eachType).size();
            if (excludedTypes.contains(eachType.getName()) || size <= 0 || eachType.equals(test.getDocumentAnnotation().getType())) continue;
            types.add(eachType);
        }
        List<AnnotationFS> testAnnotations = this.getAnnotations(types, test);
        List<AnnotationFS> runAnnotations = this.getAnnotations(types, run);
        HashSet<AnnotationFS> matched = new HashSet<AnnotationFS>();
        ArrayList<AnnotationFS> fp = new ArrayList<AnnotationFS>();
        ArrayList<AnnotationFS> fn = new ArrayList<AnnotationFS>();
        ArrayList<AnnotationFS> tp = new ArrayList<AnnotationFS>();
        DefaultSeeder scanner = new DefaultSeeder();
        scanner.seed(test.getDocumentText(), test);
        testAnnotations = this.expand(testAnnotations, test, this.getWordTypes(test));
        runAnnotations = this.expand(runAnnotations, run, this.getWordTypes(run));
        for (AnnotationFS eachTest : testAnnotations) {
            AnnotationFS original;
            Type type;
            AnnotationFS createAnnotation;
            boolean found = false;
            for (AnnotationFS eachRun : runAnnotations) {
                if (!this.match(eachTest, eachRun)) continue;
                matched.add(eachRun);
                found = true;
                break;
            }
            if (!found) {
                createAnnotation = run.createAnnotation(falseNegativeType, eachTest.getBegin(), eachTest.getEnd());
                type = run.getTypeSystem().getType(eachTest.getType().getName());
                original = run.createAnnotation(type, eachTest.getBegin(), eachTest.getEnd());
                createAnnotation.setFeatureValue(feature, (FeatureStructure)original);
                fn.add(createAnnotation);
                continue;
            }
            createAnnotation = run.createAnnotation(truePositveType, eachTest.getBegin(), eachTest.getEnd());
            type = run.getTypeSystem().getType(eachTest.getType().getName());
            original = run.createAnnotation(type, eachTest.getBegin(), eachTest.getEnd());
            createAnnotation.setFeatureValue(feature, (FeatureStructure)original);
            tp.add(createAnnotation);
        }
        for (AnnotationFS each : runAnnotations) {
            if (matched.contains(each)) continue;
            AnnotationFS createAnnotation = run.createAnnotation(falsePositiveType, each.getBegin(), each.getEnd());
            Type type = run.getTypeSystem().getType(each.getType().getName());
            AnnotationFS original = run.createAnnotation(type, each.getBegin(), each.getEnd());
            createAnnotation.setFeatureValue(feature, (FeatureStructure)original);
            fp.add(createAnnotation);
        }
        for (AnnotationFS annotationFS : fn) {
            run.addFsToIndexes((FeatureStructure)annotationFS);
        }
        for (AnnotationFS annotationFS : fp) {
            run.addFsToIndexes((FeatureStructure)annotationFS);
        }
        for (AnnotationFS annotationFS : tp) {
            run.addFsToIndexes((FeatureStructure)annotationFS);
        }
        return run;
    }

    private List<Type> getWordTypes(CAS test) {
        ArrayList<Type> result = new ArrayList<Type>();
        result.add(test.getTypeSystem().getType("org.apache.uima.ruta.type.W"));
        result.add(test.getTypeSystem().getType("org.apache.uima.ruta.type.NUM"));
        return result;
    }

    private List<AnnotationFS> expand(List<AnnotationFS> list, CAS cas, List<Type> basicTypes) {
        LinkedList<AnnotationFS> result = new LinkedList<AnnotationFS>();
        for (Type basicType : basicTypes) {
            for (AnnotationFS each : list) {
                AnnotationFS window = cas.createAnnotation(basicType, each.getBegin(), each.getEnd());
                FSIterator iterator = cas.getAnnotationIndex(basicType).subiterator(window);
                while (iterator.isValid()) {
                    AnnotationFS basic = (AnnotationFS)iterator.get();
                    if (cas.getTypeSystem().subsumes(basicType, basic.getType()) && basic.getBegin() >= each.getBegin() && basic.getEnd() <= each.getEnd()) {
                        result.add(cas.createAnnotation(each.getType(), basic.getBegin(), basic.getEnd()));
                    }
                    iterator.moveToNext();
                }
            }
        }
        return result;
    }
}

