/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.ide.parser.ast;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.antlr.runtime.Token;
import org.apache.uima.ruta.ide.parser.ast.AbstractFactory;
import org.apache.uima.ruta.ide.parser.ast.ComponentReference;
import org.apache.uima.ruta.ide.parser.ast.RutaAction;
import org.apache.uima.ruta.ide.parser.ast.RutaLogAction;
import org.apache.uima.ruta.ide.parser.ast.RutaStructureAction;
import org.eclipse.dltk.ast.expressions.Expression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionFactory
extends AbstractFactory {
    public static RutaAction createAction(Token type, List exprsRaw) {
        int[] bounds = ActionFactory.getBounds(type);
        int nameStart = bounds[0];
        int nameEnd = bounds[1];
        ArrayList<Expression> exprs = new ArrayList<Expression>();
        if (exprsRaw != null) {
            for (Object expressionObj : exprsRaw) {
                Expression expr = (Expression)expressionObj;
                if (expr == null) continue;
                exprs.add(expr);
            }
            if (!exprs.isEmpty()) {
                Expression lastExpr = (Expression)exprs.get(exprs.size() - 1);
                bounds[1] = Math.max(bounds[1], lastExpr.sourceEnd());
            }
        }
        return new RutaAction(bounds[0], bounds[1], exprs, 10000 + type.getType(), type.getText(), nameStart, nameEnd);
    }

    public static RutaAction createAction(Token type, Expression ... exprsArray) {
        ArrayList<Expression> listOfExpressions = new ArrayList<Expression>();
        if (exprsArray != null) {
            for (int i = 0; i < exprsArray.length; ++i) {
                Expression expression = exprsArray[i];
                if (expression == null) continue;
                listOfExpressions.add(expression);
            }
        }
        return ActionFactory.createAction(type, listOfExpressions);
    }

    public static RutaAction createEmptyAction(Token token) {
        int[] bounds = ActionFactory.getBounds(token);
        return new RutaAction(bounds[0], bounds[0], new ArrayList<Expression>(), 10000, "", bounds[0], bounds[0]);
    }

    public static RutaAction createAction(Token type, Map<Expression, Expression> map, Expression ... exprsArray) {
        ArrayList<Expression> listOfExpressions = new ArrayList<Expression>();
        if (exprsArray != null) {
            for (int i = 0; i < exprsArray.length; ++i) {
                Expression expression = exprsArray[i];
                if (expression == null) continue;
                listOfExpressions.add(expression);
            }
        }
        return ActionFactory.createAction(type, listOfExpressions);
    }

    public static RutaAction createCallAction(Token callToken, ComponentReference ref) {
        return ActionFactory.createAction(callToken, new Expression[]{ref});
    }

    public static RutaAction createCallAction(Token callToken, ComponentReference ref, Expression list) {
        return ActionFactory.createAction(callToken, new Expression[]{ref, list});
    }

    public static RutaAction createStructureAction(Token type, Expression structure, List<Expression> indexes, List<Expression> left, List<Expression> right) {
        ArrayList<Expression> args = new ArrayList<Expression>();
        if (indexes != null) {
            args.addAll(indexes);
        }
        return ActionFactory.createStructureAction(type, args, left, right, structure);
    }

    private static void filterNullObjsAndSetBounds(List left, int[] bounds, List<Expression> exprs) {
        if (left != null) {
            for (Object expressionObj : left) {
                Expression expr = (Expression)expressionObj;
                if (expr == null) continue;
                exprs.add(expr);
            }
            if (!exprs.isEmpty()) {
                Expression lastExpr = exprs.get(exprs.size() - 1);
                bounds[1] = Math.max(bounds[1], lastExpr.sourceEnd());
            }
        }
    }

    public static RutaAction createLogAction(Token type, Expression logString, Token level) {
        int[] bounds;
        int[] nameBounds = ActionFactory.getBounds(type);
        int[] levelBounds = new int[]{-1, -1};
        if (level != null) {
            levelBounds = ActionFactory.getBounds(level);
            bounds = ActionFactory.getBounds(type, level);
        } else {
            bounds = ActionFactory.getBounds(type);
        }
        if (logString != null) {
            bounds[1] = Math.max(bounds[1], logString.sourceEnd());
        }
        ArrayList<Expression> exprs = new ArrayList<Expression>();
        exprs.add(logString);
        return new RutaLogAction(bounds[0], bounds[1], type.getText(), nameBounds[0], nameBounds[1], exprs, levelBounds[0], levelBounds[1]);
    }

    public static RutaAction createStructureAction(Token type, Expression structure, Expression index, Expression table, List left, List right) {
        int[] bounds = ActionFactory.getBounds(type);
        int nameStart = bounds[0];
        int nameEnd = bounds[1];
        ArrayList<Expression> numExprs = new ArrayList<Expression>();
        LinkedHashMap<Expression, Expression> assignments = new LinkedHashMap<Expression, Expression>();
        ArrayList<Expression> indexes = new ArrayList<Expression>();
        indexes.add(table);
        indexes.add(index);
        indexes.add(structure);
        ActionFactory.filterNullObjsAndSetBounds(indexes, bounds, numExprs);
        if (left != null && right != null) {
            Iterator keysIt = left.iterator();
            Iterator valsIt = right.iterator();
            Expression val = null;
            while (keysIt.hasNext()) {
                Expression key = (Expression)keysIt.next();
                if (!valsIt.hasNext()) break;
                val = (Expression)valsIt.next();
                assignments.put(key, val);
            }
            if (val != null) {
                bounds[1] = val.sourceEnd();
            }
        }
        return new RutaStructureAction(bounds[0], bounds[1], numExprs, 10000 + type.getType(), type.getText(), nameStart, nameEnd, assignments, structure);
    }

    public static RutaAction createAction(Token name, Expression f, List<Expression> list) {
        ArrayList<Expression> list2 = new ArrayList<Expression>();
        list2.add(f);
        list2.addAll(list);
        return ActionFactory.createAction(name, list2);
    }

    public static RutaAction createAction(Token name, Expression a1, Expression a2, List<Expression> list) {
        ArrayList<Expression> complete = new ArrayList<Expression>();
        complete.add(a1);
        complete.add(a2);
        complete.addAll(list);
        return ActionFactory.createAction(name, complete);
    }

    public static RutaAction createConfigureAction(Token name, ComponentReference ns, List<Expression> left, List<Expression> right) {
        ArrayList<ComponentReference> exprs = new ArrayList<ComponentReference>();
        exprs.add(ns);
        if (left != null && right != null) {
            for (int i = 0; i < Math.min(left.size(), right.size()); ++i) {
                exprs.add((ComponentReference)left.get(i));
                exprs.add((ComponentReference)right.get(i));
            }
        }
        return ActionFactory.createAction(name, exprs);
    }

    public static RutaAction createStructureAction(Token name, List<Expression> args, List<Expression> left, List<Expression> right, Expression structure) {
        int[] bounds = ActionFactory.getBounds(name);
        int nameStart = bounds[0];
        int nameEnd = bounds[1];
        ArrayList<Expression> numExprs = new ArrayList<Expression>();
        LinkedHashMap<Expression, Expression> assignments = new LinkedHashMap<Expression, Expression>();
        ActionFactory.filterNullObjsAndSetBounds(args, bounds, numExprs);
        if (left != null && right != null) {
            Iterator<Expression> keysIt = left.iterator();
            Iterator<Expression> valsIt = right.iterator();
            Expression val = null;
            while (keysIt.hasNext()) {
                Expression key = keysIt.next();
                if (!valsIt.hasNext()) break;
                val = valsIt.next();
                assignments.put(key, val);
            }
            if (val != null) {
                bounds[1] = val.sourceEnd();
            }
        }
        return new RutaStructureAction(bounds[0], bounds[1], numExprs, 10000 + name.getType(), name.getText(), nameStart, nameEnd, assignments, structure);
    }
}

