/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.ide.launching;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.uima.ruta.ide.RutaIdePlugin;
import org.apache.uima.ruta.ide.core.builder.RutaProjectUtils;
import org.apache.uima.ruta.ide.launching.RutaLauncher;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.launching.AbstractScriptLaunchConfigurationDelegate;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.launching.JavaLaunchDelegate;
import org.eclipse.jface.preference.IPreferenceStore;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RutaLaunchConfigurationDelegate
extends JavaLaunchDelegate {
    private String mode;

    public String getProgramArguments(ILaunchConfiguration configuration) throws CoreException {
        String output;
        StringBuilder cmdline = new StringBuilder();
        IScriptProject proj = AbstractScriptLaunchConfigurationDelegate.getScriptProject((ILaunchConfiguration)configuration);
        String mainScriptAttribute = configuration.getAttribute("mainScript", "");
        String encoding = proj.getProject().getDefaultCharset();
        String view = configuration.getAttribute("org.apache.uima.ruta.ide.launching.view", "_InitialView");
        if (StringUtils.isBlank((CharSequence)view)) {
            view = "_InitialView";
        }
        boolean recursive = configuration.getAttribute("org.apache.uima.ruta.ide.launching.recursive", false);
        IResource member = proj.getProject().findMember(mainScriptAttribute);
        IPath projectPath = proj.getResource().getLocation();
        IPath inputDirPath = projectPath.append(RutaProjectUtils.getDefaultInputLocation());
        IPath outputDirPath = projectPath.append(RutaProjectUtils.getDefaultOutputLocation());
        String engine = RutaProjectUtils.getEngineDescriptorPath(member.getLocation(), proj.getProject()).toPortableString();
        String input = configuration.getAttribute("org.apache.uima.ruta.ide.launching.inputFolder", inputDirPath.toPortableString());
        if (StringUtils.isBlank((CharSequence)input)) {
            input = inputDirPath.toPortableString();
        }
        if (StringUtils.isBlank((CharSequence)(output = configuration.getAttribute("org.apache.uima.ruta.ide.launching.outputFolder", outputDirPath.toPortableString())))) {
            output = outputDirPath.toPortableString();
        }
        cmdline.append("-descriptor ");
        cmdline.append(engine + " ");
        cmdline.append("-inputFolder ");
        cmdline.append(this.makeAbsolute(input, configuration) + " ");
        cmdline.append("-outputFolder ");
        cmdline.append(this.makeAbsolute(output, configuration) + " ");
        cmdline.append("-mode ");
        cmdline.append(this.mode + " ");
        cmdline.append("-encoding ");
        cmdline.append(encoding + " ");
        cmdline.append("-view ");
        cmdline.append(view + " ");
        cmdline.append("-inputRecursive ");
        cmdline.append(recursive + " ");
        return cmdline.toString();
    }

    private String makeAbsolute(String input, ILaunchConfiguration configuration) throws CoreException {
        IResource member = ResourcesPlugin.getWorkspace().getRoot().findMember(input);
        if (member != null) {
            return member.getLocation().toPortableString();
        }
        return input;
    }

    public String getMainTypeName(ILaunchConfiguration configuration) throws CoreException {
        return "org.apache.uima.ruta.ide.launching.RutaLauncher";
    }

    public String[] getClasspath(ILaunchConfiguration configuration) throws CoreException {
        RutaIdePlugin d = RutaIdePlugin.getDefault();
        ArrayList<String> extendedClasspath = new ArrayList<String>();
        Collections.addAll(extendedClasspath, super.getClasspath(configuration));
        if (!Platform.inDevelopmentMode()) {
            try {
                extendedClasspath.add(d.pluginIdToJarPath("org.apache.uima.ruta.ide"));
                extendedClasspath.add(d.pluginIdToJarPath("org.apache.uima.runtime"));
                extendedClasspath.add(d.pluginIdToJarPath("org.apache.uima.ruta.engine"));
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "org.apache.uima.ruta.ide", 0, "Failed to compose classpath!", (Throwable)e));
            }
        }
        try {
            Bundle bundle2;
            extendedClasspath.add(d.pluginIdToJarPath("org.apache.uima.ruta.ide") + "target/classes");
            Bundle bundle = RutaIdePlugin.getDefault().getBundle("org.apache.uima.runtime");
            if (bundle != null) {
                Enumeration jarEnum = bundle.findEntries("/", "*.jar", true);
                if (jarEnum == null) {
                    extendedClasspath.add(d.pluginIdToJarPath("org.apache.uima.runtime"));
                }
                while (jarEnum != null && jarEnum.hasMoreElements()) {
                    URL element = (URL)jarEnum.nextElement();
                    extendedClasspath.add(FileLocator.toFileURL((URL)element).getFile());
                }
            }
            if ((bundle2 = RutaIdePlugin.getDefault().getBundle("org.apache.uima.ruta.engine")) != null) {
                Enumeration jarEnum = bundle2.findEntries("/", "*.jar", true);
                while (jarEnum != null && jarEnum.hasMoreElements()) {
                    URL element = (URL)jarEnum.nextElement();
                    extendedClasspath.add(FileLocator.toFileURL((URL)element).getFile());
                }
            }
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.apache.uima.ruta.ide", 0, "Failed to compose classpath!", (Throwable)e));
        }
        Collection<String> dependencies = this.getDependencies(configuration);
        extendedClasspath.addAll(dependencies);
        Collection<String> extensions = this.getExtensions(configuration);
        extendedClasspath.addAll(extensions);
        return extendedClasspath.toArray(new String[extendedClasspath.size()]);
    }

    private Collection<String> getExtensions(ILaunchConfiguration configuration) throws CoreException {
        IExtension[] extensions;
        RutaIdePlugin d = RutaIdePlugin.getDefault();
        TreeSet<String> result = new TreeSet<String>();
        for (IExtension each : extensions = Platform.getExtensionRegistry().getExtensionPoint("org.apache.uima.ruta.ide", "actionExtension").getExtensions()) {
            String namespaceIdentifier = each.getNamespaceIdentifier();
            try {
                if (!Platform.inDevelopmentMode()) {
                    result.add(d.pluginIdToJarPath(namespaceIdentifier));
                    continue;
                }
                result.add(d.pluginIdToJarPath(namespaceIdentifier) + "target/classes");
                result.add(d.pluginIdToJarPath(namespaceIdentifier) + "bin");
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "org.apache.uima.ruta.ide", 0, "Failed to extend classpath with " + namespaceIdentifier + "!", (Throwable)e));
            }
        }
        return result;
    }

    private Collection<String> getDependencies(ILaunchConfiguration configuration) throws CoreException {
        IProject[] referencedProjects;
        TreeSet<String> result = new TreeSet<String>();
        IScriptProject scriptProject = AbstractScriptLaunchConfigurationDelegate.getScriptProject((ILaunchConfiguration)configuration);
        for (IProject eachProject : referencedProjects = scriptProject.getProject().getReferencedProjects()) {
            this.extendClasspathWithProject(result, eachProject, new HashSet<IProject>());
        }
        return result;
    }

    private void extendClasspathWithProject(Collection<String> result, IProject project, Collection<IProject> visited) throws CoreException, JavaModelException {
        IProjectNature nature = project.getNature("org.eclipse.jdt.core.javanature");
        if (nature != null) {
            IClasspathEntry[] rawClasspath;
            JavaProject javaProject = (JavaProject)JavaCore.create((IProject)project);
            IPath readOutputLocation = javaProject.readOutputLocation();
            IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(readOutputLocation);
            result.add(folder.getLocation().toPortableString());
            for (IClasspathEntry each : rawClasspath = javaProject.getRawClasspath()) {
                IClasspathEntry[] resolveClasspath;
                String segment;
                int entryKind = each.getEntryKind();
                IPath path = each.getPath();
                if (entryKind == 2) {
                    IProject p = RutaProjectUtils.getProject(path);
                    if (visited.contains(p)) continue;
                    visited.add(p);
                    this.extendClasspathWithProject(result, p, visited);
                    continue;
                }
                if (entryKind == 3 || (segment = path.segment(0)).equals("org.eclipse.jdt.launching.JRE_CONTAINER")) continue;
                for (IClasspathEntry eachResolved : resolveClasspath = javaProject.resolveClasspath(new IClasspathEntry[]{each})) {
                    if (eachResolved.getEntryKind() == 2) {
                        IProject p = RutaProjectUtils.getProject(eachResolved.getPath());
                        if (visited.contains(p)) continue;
                        visited.add(p);
                        this.extendClasspathWithProject(result, p, visited);
                        continue;
                    }
                    result.add(eachResolved.getPath().toPortableString());
                }
            }
        }
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        this.mode = mode;
        IContainer ouputFolder = null;
        IScriptProject proj = AbstractScriptLaunchConfigurationDelegate.getScriptProject((ILaunchConfiguration)configuration);
        IPath projectPath = proj.getResource().getLocation();
        IPath outputDirPath = projectPath.append(RutaProjectUtils.getDefaultOutputLocation());
        String outputFolderPath = configuration.getAttribute("-outputFolder", outputDirPath.toPortableString());
        if (outputFolderPath.length() != 0) {
            IPath path = Path.fromPortableString((String)outputFolderPath);
            ouputFolder = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation(path);
        }
        boolean recursive = configuration.getAttribute("org.apache.uima.ruta.ide.launching.recursive", false);
        this.clearOutputFolder(new File(ouputFolder.getLocation().toPortableString()), recursive);
        if (Platform.inDevelopmentMode()) {
            String[] args = this.getProgramArguments(configuration).split(" ");
            try {
                RutaLauncher.main(args);
            }
            catch (Exception e1) {
                RutaIdePlugin.error(e1);
            }
        } else {
            super.launch(configuration, mode, launch, monitor);
            while (!launch.isTerminated()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                }
            }
        }
        if (ouputFolder != null) {
            ouputFolder.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    private void clearOutputFolder(File outputDir, boolean recursive) {
        IPreferenceStore store = RutaIdePlugin.getDefault().getPreferenceStore();
        boolean clearOutput = store.getBoolean("ProjectClearOutput");
        if (clearOutput) {
            List<File> outputFiles = RutaLaunchConfigurationDelegate.getFiles(outputDir, recursive);
            for (File file : outputFiles) {
                file.delete();
            }
        }
    }

    private static List<File> getFiles(File dir, boolean recusive) {
        ArrayList<File> result = new ArrayList<File>();
        for (File each : dir.listFiles()) {
            if (each.getName().endsWith(".svn")) continue;
            result.add(each);
            if (!each.isDirectory() || !recusive) continue;
            result.addAll(RutaLaunchConfigurationDelegate.getFiles(each, recusive));
        }
        return result;
    }
}

