/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.rule;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaBlock;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.action.AbstractRutaAction;
import org.apache.uima.ruta.condition.AbstractRutaCondition;
import org.apache.uima.ruta.rule.AbstractRuleElement;
import org.apache.uima.ruta.rule.ComposedRuleElement;
import org.apache.uima.ruta.rule.ComposedRuleElementMatch;
import org.apache.uima.ruta.rule.EvaluatedCondition;
import org.apache.uima.ruta.rule.RuleApply;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.rule.RuleElementContainer;
import org.apache.uima.ruta.rule.RuleElementIsolator;
import org.apache.uima.ruta.rule.RuleElementMatch;
import org.apache.uima.ruta.rule.RuleMatch;
import org.apache.uima.ruta.rule.RutaMatcher;
import org.apache.uima.ruta.rule.quantifier.RuleElementQuantifier;
import org.apache.uima.ruta.visitor.InferenceCrowd;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RutaRuleElement
extends AbstractRuleElement {
    private RutaMatcher matcher;
    protected final InferenceCrowd emptyCrowd = new InferenceCrowd(Collections.EMPTY_LIST);

    public RutaRuleElement(RutaMatcher matcher, RuleElementQuantifier quantifier, List<AbstractRutaCondition> conditions, List<AbstractRutaAction> actions, RuleElementContainer container, RutaBlock parent) {
        super(quantifier, conditions, actions, container, parent);
        this.matcher = matcher;
    }

    @Override
    public Collection<AnnotationFS> getAnchors(RutaStream stream) {
        return this.matcher.getMatchingAnnotations(stream, this.getParent());
    }

    @Override
    public void startMatch(RuleMatch ruleMatch, RuleApply ruleApply, ComposedRuleElementMatch containerMatch, RuleElement entryPoint, RutaStream stream, InferenceCrowd crowd) {
        Collection<AnnotationFS> anchors = this.getAnchors(stream);
        boolean useAlternatives = entryPoint == null && anchors.size() != 1;
        for (AnnotationFS eachAnchor : anchors) {
            ComposedRuleElementMatch extendedContainerMatch = containerMatch;
            RuleMatch extendedMatch = ruleMatch;
            if (useAlternatives) {
                extendedContainerMatch = containerMatch.copy();
                extendedMatch = ruleMatch.copy(extendedContainerMatch);
            } else {
                extendedMatch.update(extendedContainerMatch);
            }
            this.doMatch(eachAnchor, extendedMatch, extendedContainerMatch, true, stream, crowd);
            if (extendedMatch.matched()) {
                RutaRuleElement sideStepOrigin;
                RuleElement after = this.getContainer().getNextElement(true, this);
                RuleElement before = this.getContainer().getNextElement(false, this);
                RutaRuleElement rutaRuleElement = sideStepOrigin = this.hasAncestor(false) ? this : null;
                if (this.quantifier.continueMatch(true, eachAnchor, this, extendedMatch, extendedContainerMatch, stream, crowd)) {
                    this.continueOwnMatch(true, eachAnchor, extendedMatch, ruleApply, extendedContainerMatch, sideStepOrigin, null, stream, crowd);
                    continue;
                }
                if (after != null) {
                    sideStepOrigin = this.hasAncestor(false) ? this : null;
                    after.continueMatch(true, eachAnchor, extendedMatch, ruleApply, extendedContainerMatch, sideStepOrigin, null, stream, crowd);
                } else if (stream.isDynamicAnchoring() && before != null) {
                    sideStepOrigin = this.hasAncestor(true) ? this : null;
                    before.continueMatch(false, eachAnchor, extendedMatch, ruleApply, extendedContainerMatch, sideStepOrigin, null, stream, crowd);
                }
                if (after != null || before != null) continue;
                if (this.getContainer() instanceof ComposedRuleElement) {
                    sideStepOrigin = this.hasAncestor(false) ? this : null;
                    ComposedRuleElement composed = (ComposedRuleElement)this.getContainer();
                    composed.fallbackContinue(true, false, eachAnchor, extendedMatch, ruleApply, extendedContainerMatch, sideStepOrigin, entryPoint, stream, crowd);
                    continue;
                }
                if (!(this.getContainer() instanceof RuleElementIsolator)) continue;
                this.doneMatching(extendedMatch, ruleApply, stream, crowd);
                continue;
            }
            if (!(this.getContainer() instanceof ComposedRuleElement)) continue;
            ComposedRuleElement composed = (ComposedRuleElement)this.getContainer();
            composed.fallbackContinue(true, true, eachAnchor, extendedMatch, ruleApply, extendedContainerMatch, null, null, stream, crowd);
        }
    }

    @Override
    public void continueOwnMatch(boolean after, AnnotationFS annotation, RuleMatch ruleMatch, RuleApply ruleApply, ComposedRuleElementMatch containerMatch, RutaRuleElement sideStepOrigin, RuleElement entryPoint, RutaStream stream, InferenceCrowd crowd) {
        if (this.quantifier.continueMatch(after, annotation, this, ruleMatch, containerMatch, stream, crowd)) {
            boolean stopMatching = false;
            AnnotationFS eachAnchor = annotation;
            AnnotationFS lastAnchor = annotation;
            ComposedRuleElementMatch extendedContainerMatch = containerMatch;
            RuleMatch extendedMatch = ruleMatch;
            extendedMatch.update(extendedContainerMatch);
            while (!stopMatching) {
                if (!this.quantifier.continueMatch(after, eachAnchor, this, extendedMatch, extendedContainerMatch, stream, crowd)) {
                    stopMatching = true;
                    this.stepbackMatch(after, lastAnchor, extendedMatch, ruleApply, extendedContainerMatch, sideStepOrigin, stream, crowd, entryPoint);
                    break;
                }
                Collection<AnnotationFS> nextAnnotations = this.getNextAnnotations(after, eachAnchor, stream);
                if (nextAnnotations.size() == 0) {
                    stopMatching = true;
                    this.stepbackMatch(after, eachAnchor, extendedMatch, ruleApply, extendedContainerMatch, sideStepOrigin, stream, crowd, entryPoint);
                    continue;
                }
                if (nextAnnotations.size() == 1) {
                    lastAnchor = eachAnchor;
                    eachAnchor = nextAnnotations.iterator().next();
                    this.doMatch(eachAnchor, extendedMatch, extendedContainerMatch, false, stream, crowd);
                    if (this.equals(entryPoint)) {
                        return;
                    }
                    if (extendedMatch.matched()) {
                        if (this.quantifier.continueMatch(after, eachAnchor, this, extendedMatch, extendedContainerMatch, stream, crowd)) continue;
                        stopMatching = true;
                        this.continueMatchSomewhereElse(after, false, eachAnchor, extendedMatch, ruleApply, extendedContainerMatch, sideStepOrigin, entryPoint, stream, crowd);
                        continue;
                    }
                    stopMatching = true;
                    this.stepbackMatch(after, lastAnchor, extendedMatch, ruleApply, extendedContainerMatch, sideStepOrigin, stream, crowd, entryPoint);
                    continue;
                }
                stopMatching = true;
                this.continueMatch(after, lastAnchor, extendedMatch, ruleApply, extendedContainerMatch, sideStepOrigin, entryPoint, stream, crowd);
            }
        } else {
            this.stepbackMatch(after, annotation, ruleMatch, ruleApply, containerMatch, sideStepOrigin, stream, crowd, entryPoint);
        }
    }

    private void continueMatchSomewhereElse(boolean after, boolean failed, AnnotationFS eachAnchor, RuleMatch extendedMatch, RuleApply ruleApply, ComposedRuleElementMatch extendedContainerMatch, RutaRuleElement sideStepOrigin, RuleElement entryPoint, RutaStream stream, InferenceCrowd crowd) {
        RuleElement nextRuleElement = this.getContainer().getNextElement(after, this);
        if (nextRuleElement != null) {
            nextRuleElement.continueMatch(after, eachAnchor, extendedMatch, ruleApply, extendedContainerMatch, sideStepOrigin, entryPoint, stream, crowd);
        } else if (this.getContainer() instanceof ComposedRuleElement) {
            ComposedRuleElement composed = (ComposedRuleElement)this.getContainer();
            composed.fallbackContinue(after, failed, eachAnchor, extendedMatch, ruleApply, extendedContainerMatch, sideStepOrigin, entryPoint, stream, crowd);
        }
    }

    @Override
    public void continueMatch(boolean after, AnnotationFS annotation, RuleMatch ruleMatch, RuleApply ruleApply, ComposedRuleElementMatch containerMatch, RutaRuleElement sideStepOrigin, RuleElement entryPoint, RutaStream stream, InferenceCrowd crowd) {
        if (this.quantifier.continueMatch(after, annotation, this, ruleMatch, containerMatch, stream, crowd)) {
            Collection<AnnotationFS> nextAnnotations = this.getNextAnnotations(after, annotation, stream);
            if (nextAnnotations.isEmpty()) {
                this.stepbackMatch(after, annotation, ruleMatch, ruleApply, containerMatch, sideStepOrigin, stream, crowd, entryPoint);
            }
            boolean useAlternatives = entryPoint == null && nextAnnotations.size() != 1;
            for (AnnotationFS eachAnchor : nextAnnotations) {
                ComposedRuleElementMatch extendedContainerMatch = containerMatch;
                RuleMatch extendedMatch = ruleMatch;
                if (useAlternatives) {
                    extendedContainerMatch = containerMatch.copy();
                    extendedMatch = ruleMatch.copy(extendedContainerMatch);
                } else {
                    extendedMatch.update(extendedContainerMatch);
                }
                this.doMatch(eachAnchor, extendedMatch, extendedContainerMatch, false, stream, crowd);
                if (this.equals(entryPoint) && ruleApply == null) {
                    return;
                }
                if (extendedMatch.matched()) {
                    if (this.quantifier.continueMatch(after, annotation, this, extendedMatch, extendedContainerMatch, stream, crowd)) {
                        this.continueOwnMatch(after, eachAnchor, extendedMatch, ruleApply, extendedContainerMatch, sideStepOrigin, entryPoint, stream, crowd);
                        continue;
                    }
                    this.continueMatchSomewhereElse(after, false, eachAnchor, extendedMatch, ruleApply, extendedContainerMatch, sideStepOrigin, entryPoint, stream, crowd);
                    continue;
                }
                this.stepbackMatch(after, annotation, extendedMatch, ruleApply, extendedContainerMatch, sideStepOrigin, stream, crowd, entryPoint);
            }
        } else {
            this.stepbackMatch(after, annotation, ruleMatch, ruleApply, containerMatch, sideStepOrigin, stream, crowd, entryPoint);
        }
    }

    private void stepbackMatch(boolean after, AnnotationFS annotation, RuleMatch ruleMatch, RuleApply ruleApply, ComposedRuleElementMatch containerMatch, RutaRuleElement sideStepOrigin, RutaStream stream, InferenceCrowd crowd, RuleElement entryPoint) {
        if (ruleApply == null) {
            return;
        }
        List<RuleElementMatch> matchInfo = this.getMatch(ruleMatch, containerMatch);
        if (matchInfo == null) {
            if (this.quantifier.isOptional(this.parent)) {
                this.continueMatchSomewhereElse(after, true, annotation, ruleMatch, ruleApply, containerMatch, sideStepOrigin, entryPoint, stream, crowd);
            } else if (this.getContainer() instanceof ComposedRuleElement) {
                RuleElementMatch failedMatch = new RuleElementMatch(this, containerMatch);
                failedMatch.setBaseConditionMatched(false);
                containerMatch.addInnerMatch(this, failedMatch);
                ComposedRuleElement composed = (ComposedRuleElement)this.getContainer();
                composed.fallbackContinue(after, true, annotation, ruleMatch, ruleApply, containerMatch, sideStepOrigin, entryPoint, stream, crowd);
            }
        } else {
            List<RuleElementMatch> evaluateMatches = this.quantifier.evaluateMatches(matchInfo, this.parent, crowd);
            ruleMatch.setMatched(evaluateMatches != null);
            if (ruleMatch.matched()) {
                this.continueMatchSomewhereElse(after, true, annotation, ruleMatch, ruleApply, containerMatch, sideStepOrigin, null, stream, crowd);
            } else {
                this.doneMatching(ruleMatch, ruleApply, stream, crowd);
            }
        }
    }

    public void continueSideStep(boolean after, RuleMatch ruleMatch, RuleApply ruleApply, ComposedRuleElementMatch containerMatch, RuleElement entryPoint, RutaStream stream, InferenceCrowd crowd) {
        boolean newDirection = !after;
        List<AnnotationFS> matchedAnnotationsOf = ruleMatch.getMatchedAnnotationsOf(this, stream);
        AnnotationFS annotation = null;
        annotation = newDirection ? matchedAnnotationsOf.get(matchedAnnotationsOf.size() - 1) : matchedAnnotationsOf.get(0);
        ComposedRuleElementMatch sideStepContainerMatch = containerMatch;
        if (!containerMatch.getRuleElement().equals(this.getContainer())) {
            List<RuleElementMatch> list;
            List<List<RuleElementMatch>> matchInfo = ruleMatch.getMatchInfo((ComposedRuleElement)this.getContainer());
            if (newDirection) {
                list = matchInfo.get(matchInfo.size() - 1);
                sideStepContainerMatch = (ComposedRuleElementMatch)list.get(list.size() - 1);
            } else {
                list = matchInfo.get(0);
                sideStepContainerMatch = (ComposedRuleElementMatch)list.get(0);
            }
        }
        if (this.quantifier.continueMatch(newDirection, annotation, this, ruleMatch, sideStepContainerMatch, stream, crowd)) {
            this.continueMatch(newDirection, annotation, ruleMatch, ruleApply, sideStepContainerMatch, null, entryPoint, stream, crowd);
        } else {
            RuleElement nextRuleElement = this.getContainer().getNextElement(newDirection, this);
            if (nextRuleElement != null) {
                nextRuleElement.continueMatch(newDirection, annotation, ruleMatch, ruleApply, sideStepContainerMatch, null, null, stream, crowd);
            } else if (this.getContainer() instanceof ComposedRuleElement) {
                ComposedRuleElement composed = (ComposedRuleElement)this.getContainer();
                composed.fallbackContinue(newDirection, false, annotation, ruleMatch, ruleApply, sideStepContainerMatch, null, entryPoint, stream, crowd);
            }
        }
    }

    private void doMatch(AnnotationFS annotation, RuleMatch ruleMatch, ComposedRuleElementMatch containerMatch, boolean ruleAnchor, RutaStream stream, InferenceCrowd crowd) {
        RuleElementMatch result = new RuleElementMatch(this, containerMatch);
        result.setRuleAnchor(ruleAnchor);
        ArrayList<EvaluatedCondition> evaluatedConditions = new ArrayList<EvaluatedCondition>(this.conditions.size());
        boolean base = this.matcher.match(annotation, stream, this.getParent());
        ArrayList<AnnotationFS> textsMatched = new ArrayList<AnnotationFS>(1);
        if (base) {
            for (AbstractRutaCondition condition : this.conditions) {
                crowd.beginVisit(condition, null);
                EvaluatedCondition eval = condition.eval(annotation, this, stream, crowd);
                crowd.endVisit(condition, null);
                evaluatedConditions.add(eval);
            }
        }
        if (annotation != null) {
            textsMatched.add(annotation);
        }
        result.setMatchInfo(base, textsMatched, evaluatedConditions);
        ruleMatch.setMatched(ruleMatch.matched() && result.matched());
        ArrayList<RuleElementMatch> rems = new ArrayList<RuleElementMatch>();
        rems.add(result);
        ruleMatch.processMatchInfo(this, rems, stream);
    }

    public String toString() {
        String simpleName = this.getQuantifier().getClass().getSimpleName();
        return this.matcher.toString() + " " + (simpleName.equals("NormalQuantifier") ? "" : simpleName) + (this.conditions.isEmpty() ? "" : "(" + this.conditions.toString() + ")" + "\\n") + (this.actions.isEmpty() ? "" : "{" + this.actions.toString() + "}");
    }

    public RutaMatcher getMatcher() {
        return this.matcher;
    }

    @Override
    public List<AbstractRutaCondition> getConditions() {
        return this.conditions;
    }

    @Override
    public List<AbstractRutaAction> getActions() {
        return this.actions;
    }

    @Override
    public RutaBlock getParent() {
        return this.parent;
    }

    @Override
    public int estimateAnchors(RutaStream stream) {
        if (this.quantifier.isOptional(this.getParent())) {
            return Integer.MAX_VALUE;
        }
        return this.matcher.estimateAnchors(this.parent, stream);
    }

    public Collection<AnnotationFS> getNextAnnotations(boolean after, AnnotationFS annotation, RutaStream stream) {
        if (after) {
            return this.matcher.getAnnotationsAfter(this, annotation, stream, this.getParent());
        }
        return this.matcher.getAnnotationsBefore(this, annotation, stream, this.getParent());
    }
}

