/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.resource;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.uima.ruta.resource.MultiTextNode;
import org.apache.uima.ruta.resource.TrieXMLEventHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class MultiTreeWordListPersistence {
    public void readMTWL(MultiTextNode root, String path) throws IOException {
        this.readMTWL(root, new FileInputStream(path), "UTF-8");
    }

    public void readMTWL(MultiTextNode root, InputStream stream, String encoding) throws IOException {
        try {
            InputStreamReader streamReader = new InputStreamReader(stream, encoding);
            TrieXMLEventHandler handler = new TrieXMLEventHandler(root);
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            SAXParser saxParser = saxParserFactory.newSAXParser();
            XMLReader reader = saxParser.getXMLReader();
            reader.setContentHandler(handler);
            reader.setErrorHandler(handler);
            reader.parse(new InputSource(streamReader));
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
    }

    public void createMTWLFile(MultiTextNode root, String path) {
        this.createMTWLFile(root, path, "UTF-8");
    }

    public void createMTWLFile(MultiTextNode root, String path, String encoding) {
        try {
            FileOutputStream output = new FileOutputStream(path);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)output, encoding);
            writer.write("<?xml version=\"1.0\" ?><root>");
            for (MultiTextNode node : root.getChildren().values()) {
                this.writeTextNode(writer, node);
            }
            writer.write("</root>");
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeTextNode(Writer writer, MultiTextNode node) {
        try {
            writer.write("\n");
            String s = "<n>";
            writer.write(s);
            writer.write("<c><![CDATA[" + node.getValue() + "]]></c>");
            if (Boolean.valueOf(node.isWordEnd()).booleanValue()) {
                for (String type : node.getTypes()) {
                    String t = "<t>" + type + "</t>";
                    writer.write(t);
                }
            }
            for (MultiTextNode child : node.getChildren().values()) {
                this.writeTextNode(writer, child);
            }
            writer.write("</n>");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

