/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.action;

import java.util.ArrayList;
import java.util.List;
import org.apache.uima.ruta.RutaBlock;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.action.AbstractRutaAction;
import org.apache.uima.ruta.expression.RutaExpression;
import org.apache.uima.ruta.expression.list.ListExpression;
import org.apache.uima.ruta.expression.string.StringExpression;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.rule.RuleMatch;
import org.apache.uima.ruta.visitor.InferenceCrowd;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetAction
extends AbstractRutaAction {
    private ListExpression<RutaExpression> listExpr;
    private String var;
    private StringExpression opExpr;

    public GetAction(ListExpression<RutaExpression> f, String string, StringExpression op) {
        this.listExpr = f;
        this.var = string;
        this.opExpr = op;
    }

    @Override
    public void execute(RuleMatch match, RuleElement element, RutaStream stream, InferenceCrowd crowd) {
        String op = this.opExpr.getStringValue(element.getParent());
        List<RutaExpression> list = this.listExpr.getList(element.getParent());
        if ("dominant".equals(op)) {
            element.getParent().getEnvironment().setVariableValue(this.var, this.getDominant(list, element.getParent()));
        }
    }

    private Object getDominant(List<?> list, RutaBlock parent) {
        ArrayList objs = new ArrayList();
        ArrayList<Integer> counts = new ArrayList<Integer>();
        for (Object each : list) {
            Object value = each;
            if (objs.contains(value)) {
                int indexOf = objs.indexOf(value);
                Integer i = (Integer)counts.get(indexOf);
                i = i + 1;
                counts.set(indexOf, i);
                continue;
            }
            counts.add(1);
            objs.add(each);
        }
        Object dominant = null;
        int dominantCount = -1;
        int i = 0;
        for (Object each : objs) {
            int count;
            if ((count = ((Integer)counts.get(i++)).intValue()) <= dominantCount) continue;
            dominantCount = count;
            dominant = each;
        }
        return dominant;
    }

    public ListExpression<RutaExpression> getListExpr() {
        return this.listExpr;
    }

    public String getVar() {
        return this.var;
    }

    public StringExpression getOpExpr() {
        return this.opExpr;
    }
}

