/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.action;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.action.AbstractStructureAction;
import org.apache.uima.ruta.expression.RutaExpression;
import org.apache.uima.ruta.expression.list.ListExpression;
import org.apache.uima.ruta.expression.list.NumberListExpression;
import org.apache.uima.ruta.expression.number.NumberExpression;
import org.apache.uima.ruta.expression.string.StringExpression;
import org.apache.uima.ruta.expression.type.TypeExpression;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.rule.RuleElementMatch;
import org.apache.uima.ruta.rule.RuleMatch;
import org.apache.uima.ruta.type.RutaFrame;
import org.apache.uima.ruta.utils.UIMAUtils;
import org.apache.uima.ruta.visitor.InferenceCrowd;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GatherAction
extends AbstractStructureAction {
    private TypeExpression structureType;
    private Map<StringExpression, RutaExpression> features;
    private List<NumberExpression> indexes;

    public GatherAction(TypeExpression structureType, Map<StringExpression, RutaExpression> features, List<NumberExpression> indexes) {
        this.structureType = structureType;
        this.features = features == null ? new HashMap() : features;
        this.indexes = indexes == null || indexes.isEmpty() ? null : indexes;
    }

    @Override
    public void execute(RuleMatch match, RuleElement element, RutaStream stream, InferenceCrowd crowd) {
        List<Integer> indexList = this.getIndexList(match, element);
        List<AnnotationFS> matchedAnnotations = match.getMatchedAnnotations(stream, indexList, element.getContainer());
        for (AnnotationFS matchedAnnotation : matchedAnnotations) {
            if (matchedAnnotation == null) {
                return;
            }
            Type type = this.structureType.getType(element.getParent());
            FeatureStructure newFS = stream.getCas().createFS(type);
            if (newFS instanceof Annotation) {
                Annotation a = (Annotation)newFS;
                a.setBegin(matchedAnnotation.getBegin());
                a.setEnd(matchedAnnotation.getEnd());
                stream.addAnnotation((AnnotationFS)a, match);
            }
            TOP newStructure = null;
            if (!(newFS instanceof TOP)) continue;
            newStructure = (TOP)newFS;
            this.gatherFeatures(newStructure, this.features, matchedAnnotation, element, match, stream);
            newStructure.addToIndexes();
        }
    }

    private void gatherFeatures(TOP structure, Map<StringExpression, RutaExpression> features, AnnotationFS matchedAnnotation, RuleElement element, RuleMatch match, RutaStream stream) {
        HashMap<String, List<Object>> map = new HashMap<String, List<Object>>();
        for (Map.Entry<StringExpression, RutaExpression> each : features.entrySet()) {
            StringExpression ne;
            String value = each.getKey().getStringValue(element.getParent());
            RutaExpression expr = each.getValue();
            ArrayList<Integer> ints = new ArrayList<Integer>();
            if (expr instanceof NumberExpression) {
                ne = (NumberExpression)expr;
                ints.add(((NumberExpression)ne).getIntegerValue(element.getParent()));
                map.put(value, ints);
                continue;
            }
            if (!(expr instanceof NumberListExpression)) continue;
            ne = (NumberListExpression)expr;
            map.put(value, ((ListExpression)ne).getList(element.getParent()));
        }
        TypeSystem typeSystem = stream.getCas().getTypeSystem();
        JCas jcas = stream.getJCas();
        List featuresList = structure.getType().getFeatures();
        for (int i = 0; i < featuresList.size(); ++i) {
            Feature targetFeature = (Feature)featuresList.get(i);
            String name = targetFeature.getName();
            String shortFName = name.substring(name.indexOf(":") + 1, name.length());
            List reIndexes = (List)map.get(shortFName);
            if (reIndexes == null || reIndexes.isEmpty()) continue;
            Type range = targetFeature.getRange();
            List<RuleElementMatch> tms = this.getMatchInfo(match, element, reIndexes);
            if (tms.size() == 0) continue;
            if (tms.size() == 1) {
                RuleElementMatch tm = tms.get(0);
                List<AnnotationFS> textsMatched = tm.getTextsMatched();
                if (textsMatched.size() != 1) continue;
                AnnotationFS fs = textsMatched.get(0);
                if (typeSystem.subsumes(jcas.getCasType(FSArray.type), range)) {
                    ArrayList<AnnotationFS> list = new ArrayList<AnnotationFS>();
                    list.add(fs);
                    structure.setFeatureValue(targetFeature, (FeatureStructure)UIMAUtils.toFSArray(jcas, list));
                    continue;
                }
                if (!typeSystem.subsumes(range, fs.getType())) continue;
                structure.setFeatureValue(targetFeature, (FeatureStructure)fs);
                continue;
            }
            List<AnnotationFS> textsMatched = this.getMatchedText(tms);
            if (typeSystem.subsumes(jcas.getCasType(FSArray.type), range)) {
                structure.setFeatureValue(targetFeature, (FeatureStructure)UIMAUtils.toFSArray(jcas, textsMatched));
                continue;
            }
            int begin = textsMatched.get(0).getBegin();
            int end = textsMatched.get(textsMatched.size() - 1).getEnd();
            RutaFrame frame = new RutaFrame(jcas, begin, end);
            FSIterator iterator = jcas.getAnnotationIndex(range).iterator((FeatureStructure)frame);
            AnnotationFS newA = null;
            while (iterator.isValid()) {
                Annotation a = (Annotation)iterator.get();
                if (a.getBegin() == begin && a.getEnd() == end && jcas.getTypeSystem().subsumes(range, a.getType())) {
                    newA = a;
                } else if (a.getBegin() > begin || a.getEnd() < end) break;
                iterator.moveToNext();
            }
            if (newA == null) {
                newA = jcas.getCas().createAnnotation(range, begin, end);
            }
            structure.setFeatureValue(targetFeature, newA);
        }
    }

    private List<AnnotationFS> getMatchedText(List<RuleElementMatch> tms) {
        ArrayList<AnnotationFS> result = new ArrayList<AnnotationFS>();
        for (RuleElementMatch each : tms) {
            result.addAll(each.getTextsMatched());
        }
        return result;
    }

    private List<RuleElementMatch> getMatchInfo(RuleMatch match, RuleElement element, List<Number> reIndexes) {
        ArrayList<RuleElementMatch> result = new ArrayList<RuleElementMatch>();
        List<RuleElement> elements = element.getContainer().getRuleElements();
        for (Number eachNumber : reIndexes) {
            int eachInt = eachNumber.intValue();
            RuleElement ruleElement = elements.get(eachInt - 1);
            List<List<RuleElementMatch>> matchInfo = match.getMatchInfo(ruleElement);
            for (List<RuleElementMatch> list : matchInfo) {
                result.addAll(list);
            }
        }
        return result;
    }

    protected List<Integer> getIndexList(RuleMatch match, RuleElement element) {
        ArrayList<Integer> indexList = new ArrayList<Integer>();
        if (this.indexes == null || this.indexes.isEmpty()) {
            int self = element.getContainer().getRuleElements().indexOf(element) + 1;
            indexList.add(self);
            return indexList;
        }
        int last = 0x7FFFFFFE;
        for (NumberExpression each : this.indexes) {
            int value = each.getIntegerValue(element.getParent());
            for (int i = Math.min(value, last + 1); i < value; ++i) {
                indexList.add(i);
            }
            indexList.add(value);
        }
        return indexList;
    }

    public TypeExpression getStructureType() {
        return this.structureType;
    }

    public Map<StringExpression, RutaExpression> getFeatures() {
        return this.features;
    }

    public List<NumberExpression> getIndexes() {
        return this.indexes;
    }
}

