/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.taeconfigurator.editors.ui.dialogs;

import org.apache.uima.resource.ExternalResourceDescription;
import org.apache.uima.resource.FileLanguageResourceSpecifier;
import org.apache.uima.resource.FileResourceSpecifier;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.taeconfigurator.editors.ui.AbstractSection;
import org.apache.uima.taeconfigurator.editors.ui.ExtnlResBindSection;
import org.apache.uima.taeconfigurator.editors.ui.Utility;
import org.apache.uima.taeconfigurator.editors.ui.dialogs.AbstractDialogKeyVerify;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class AddExternalResourceDialog
extends AbstractDialogKeyVerify {
    private ExternalResourceDescription existingXRD = null;
    private StyledText xrNameUI;
    private String originalXrName;
    private Text xrDescriptionUI;
    private StyledText xrUrlUI;
    private StyledText xrUrlSuffixUI;
    private StyledText xrImplementationUI;
    private ExtnlResBindSection extnlResBindSection;
    public String xrName;
    public String xrDescription;
    public String xrUrl;
    public String xrUrlSuffix;
    public String xrImplementation;

    public AddExternalResourceDialog(AbstractSection aSection) {
        super(aSection, "Add an External Resource Definition", "Define and name an external resource");
        this.extnlResBindSection = (ExtnlResBindSection)aSection;
    }

    public AddExternalResourceDialog(AbstractSection aSection, ExternalResourceDescription aExistingXRD) {
        this(aSection);
        this.existingXRD = aExistingXRD;
        this.originalXrName = this.existingXRD.getName();
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent, this.existingXRD);
        this.createWideLabel(composite, "The first URL field is used to identify the external resource.\nIf both URL fields are used, they form a name by concatenating the first with the document language and then with the second (suffix) URL.\nThe (optional) Implementation specifies a Java class which implements the interface used by the Analysis Engine to access the resource.");
        Composite twoCol = this.new2ColumnComposite(composite);
        this.xrNameUI = this.newLabeledSingleLineStyledText(twoCol, "Name:", "(Required) The name of this resource; it must be unique in this Analysis Engine.");
        this.xrDescriptionUI = this.newDescription(twoCol, "(Optional) Description of the External Resource");
        this.xrUrlUI = this.newLabeledSingleLineStyledText(twoCol, "URL:", "(Required) A URL for this resource, or the URL prefix if a suffix is being used");
        this.xrUrlSuffixUI = this.newLabeledSingleLineStyledText(twoCol, "URL Suffix", "(Optional) A URL part that will be suffixed to the prefix with the language being used inserted in-between");
        this.xrImplementationUI = this.newLabeledSingleLineStyledText(twoCol, "Implementation", "(Optional) The name of a Java class implementing the interface used by the Analysis Engine to access this resource.");
        this.newErrorMessage(twoCol, 2);
        if (null != this.existingXRD) {
            this.xrNameUI.setText(this.existingXRD.getName());
            this.xrDescriptionUI.setText(AddExternalResourceDialog.convertNull(this.existingXRD.getDescription()));
            ResourceSpecifier rs = this.existingXRD.getResourceSpecifier();
            if (rs instanceof FileResourceSpecifier) {
                this.xrUrlUI.setText(((FileResourceSpecifier)rs).getFileUrl());
            } else if (rs instanceof FileLanguageResourceSpecifier) {
                this.xrUrlUI.setText(((FileLanguageResourceSpecifier)rs).getFileUrlPrefix());
                this.xrUrlSuffixUI.setText(((FileLanguageResourceSpecifier)rs).getFileUrlSuffix());
            } else {
                Utility.popMessage("Unknown resource type", "The resource type '" + rs.getClass().getName() + "' is unknown.  Editing should be done by hand in the source view.", 4);
            }
            String impName = this.existingXRD.getImplementationName();
            this.xrImplementationUI.setText(AddExternalResourceDialog.convertNull(impName));
        }
        return composite;
    }

    @Override
    public void copyValuesFromGUI() {
        this.xrName = this.xrNameUI.getText();
        this.xrDescription = AddExternalResourceDialog.nullIf0lengthString(this.xrDescriptionUI.getText());
        this.xrUrl = this.xrUrlUI.getText();
        this.xrUrlSuffix = AddExternalResourceDialog.nullIf0lengthString(this.xrUrlSuffixUI.getText());
        this.xrImplementation = AddExternalResourceDialog.nullIf0lengthString(this.xrImplementationUI.getText());
    }

    @Override
    public boolean verifyKeyChecks(VerifyEvent event) {
        if (event.keyCode == 13 || event.keyCode == 9) {
            return true;
        }
        if (Character.isJavaIdentifierPart(event.character) || event.character == '.') {
            return true;
        }
        return !(event.widget != this.xrUrlUI && event.widget != this.xrUrlSuffixUI || event.character != '/' && event.character != ':');
    }

    @Override
    public boolean isValid() {
        if (this.xrName.length() == 0) {
            return false;
        }
        if (!this.xrName.equals(this.originalXrName) && this.extnlResBindSection.resourceNameAlreadyDefined(this.xrName)) {
            return false;
        }
        return this.xrUrl.length() != 0;
    }

    @Override
    public void enableOK() {
        this.copyValuesFromGUI();
        this.okButton.setEnabled(this.xrName.length() > 0 && this.xrUrl.length() > 0);
    }
}

