/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.textruler.learner.rapier;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.uima.ruta.textruler.core.TextRulerRule;
import org.apache.uima.ruta.textruler.core.TextRulerRuleItem;
import org.apache.uima.ruta.textruler.core.TextRulerSingleSlotRule;
import org.apache.uima.ruta.textruler.core.TextRulerWordConstraint;

public class RapierRuleItem
implements TextRulerRuleItem {
    protected Set<TextRulerWordConstraint> words = new HashSet<TextRulerWordConstraint>();
    protected Set<String> tags = new HashSet<String>();
    protected Set<String> classes = new HashSet<String>();
    protected int listLen = 0;
    protected boolean listBeginsAtZero = false;

    @Override
    public boolean equals(TextRulerRuleItem o) {
        return this.getStringForRuleString(null, null, 0, 1, 0, 1, 0).equals(o.getStringForRuleString(null, null, 0, 1, 0, 1, 0));
    }

    public String toStringAsNonPatternList() {
        int original = this.listLen;
        this.listLen = 0;
        String result = this.toString();
        this.listLen = original;
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getStringForRuleString(TextRulerRule rule, TextRulerRuleItem.MLRuleItemType type, int numberInPattern, int patternSize, int numberInRule, int ruleSize, int slotIndex) {
        int listStart = this.listBeginsAtZero ? 0 : 1;
        String quantifierString = this.isListItem() ? "[" + listStart + "," + this.listLen + "]?" : "";
        String anchor = null;
        ArrayList<String> constraints = new ArrayList<String>();
        if (this.words.size() > 0) {
            ArrayList<TextRulerWordConstraint> regExpConstraints = new ArrayList<TextRulerWordConstraint>();
            Iterator<String> tmTypeConstraints = new ArrayList();
            for (TextRulerWordConstraint w : this.words) {
                if (w.isRegExpConstraint()) {
                    regExpConstraints.add(w);
                    continue;
                }
                ((ArrayList)((Object)tmTypeConstraints)).add((String)((Object)w));
            }
            int regExpCount = regExpConstraints.size();
            int tmCount = ((ArrayList)((Object)tmTypeConstraints)).size();
            String regExpString = null;
            for (TextRulerWordConstraint textRulerWordConstraint : regExpConstraints) {
                if (regExpString == null) {
                    regExpString = textRulerWordConstraint.toString();
                    continue;
                }
                regExpString = regExpString + "|" + textRulerWordConstraint.toString();
            }
            if (regExpString != null) {
                regExpString = "REGEXP(\"" + regExpString + "\")";
            }
            String tmString = null;
            if (tmCount > 1 || regExpCount > 0 && tmCount > 0) {
                void var18_30;
                Iterator iterator = ((ArrayList)((Object)tmTypeConstraints)).iterator();
                while (iterator.hasNext()) {
                    TextRulerWordConstraint w2 = (TextRulerWordConstraint)iterator.next();
                    if (tmString == null) {
                        tmString = "IS(" + w2.toString() + ")";
                        continue;
                    }
                    tmString = tmString + ",IS(" + w2.toString() + ")";
                }
                String string = "OR(" + tmString;
                if (regExpCount > 0) {
                    void var18_28;
                    if (tmCount > 0) {
                        String string2 = string + ",";
                    }
                    String string3 = (String)var18_28 + regExpString;
                }
                String string4 = (String)var18_30 + ")";
                constraints.add(string4);
            } else if (tmCount == 1) {
                anchor = ((TextRulerWordConstraint)((ArrayList)((Object)tmTypeConstraints)).get(0)).toString();
            } else if (regExpCount > 0) {
                constraints.add(regExpString);
            }
        }
        if (this.tags.size() > 0) {
            if (this.tags.size() == 1 && anchor == null) {
                anchor = this.tags.iterator().next().toString();
            } else {
                String tagsString = null;
                for (String w : this.tags) {
                    if (tagsString == null) {
                        tagsString = "IS(" + w.toString() + ")";
                        continue;
                    }
                    tagsString = tagsString + ",IS(" + w.toString() + ")";
                }
                tagsString = "OR(" + tagsString + ")";
                constraints.add(tagsString);
            }
        }
        if (this.classes.size() > 0) {
            if (this.classes.size() == 1 && anchor == null) {
                anchor = this.classes.iterator().next().toString();
            } else {
                String classesString = null;
                for (String w : this.classes) {
                    if (classesString == null) {
                        classesString = "IS(" + w.toString() + ")";
                        continue;
                    }
                    classesString = classesString + ",IS(" + w.toString() + ")";
                }
                classesString = "OR(" + classesString + ")";
                constraints.add(classesString);
            }
        }
        if (anchor == null) {
            anchor = "ALL";
        }
        String result = anchor + quantifierString;
        if (constraints.size() > 0) {
            String cStr = null;
            for (String c : constraints) {
                if (cStr == null) {
                    cStr = c.toString();
                    continue;
                }
                cStr = cStr + "," + c.toString();
            }
            result = result + "{" + cStr;
        }
        if (type == TextRulerRuleItem.MLRuleItemType.FILLER && numberInPattern == 0) {
            if (constraints.size() == 0) {
                result = result + "{";
            }
            result = result + "->MARKONCE(" + ((TextRulerSingleSlotRule)rule).getMarkName();
            if (patternSize > 1) {
                result = result + ", " + (numberInRule + 1) + ", " + (numberInRule + patternSize);
            }
            result = result + ")}";
        } else if (constraints.size() != 0) {
            result = result + "}";
        }
        return result;
    }

    public Set<TextRulerWordConstraint> getWordConstraints() {
        return this.words;
    }

    public Set<String> getTagConstraints() {
        return this.tags;
    }

    public Set<String> getClassConstraints() {
        return this.classes;
    }

    public void setListLen(int val) {
        this.listLen = val;
    }

    public void setListBeginsAtZero(boolean flag) {
        this.listBeginsAtZero = flag;
    }

    public boolean listBeginsAtZero() {
        return this.listBeginsAtZero;
    }

    public int listLen() {
        return this.listLen;
    }

    public boolean isListItem() {
        return this.listBeginsAtZero && this.listLen > 0 || this.listLen > 1;
    }

    @Override
    public RapierRuleItem copy() {
        RapierRuleItem newItem = new RapierRuleItem();
        newItem.words = new HashSet<TextRulerWordConstraint>(this.words);
        newItem.tags = new HashSet<String>(this.tags);
        newItem.classes = new HashSet<String>(this.classes);
        newItem.listLen = this.listLen;
        newItem.listBeginsAtZero = this.listBeginsAtZero;
        return newItem;
    }

    public int getRuleSizePoints() {
        int result;
        int n = result = this.isListItem() ? 3 : 2;
        if (this.words.size() > 1) {
            result += (this.words.size() - 1) * 2;
        }
        if (this.tags.size() > 1) {
            result += this.tags.size() - 1;
        }
        if (this.classes.size() > 1) {
            result += this.classes.size() - 1;
        }
        return result;
    }

    public void addWordConstraints(Collection<TextRulerWordConstraint> constraints) {
        this.words.addAll(constraints);
    }

    public void addTagConstraints(Collection<String> constraints) {
        this.tags.addAll(constraints);
    }

    public void addClassConstraints(Collection<String> constraints) {
        this.classes.addAll(constraints);
    }

    public void addWordConstraint(TextRulerWordConstraint constraint) {
        this.words.add(constraint);
    }

    public void addTagConstraint(String constraint) {
        this.tags.add(constraint);
    }

    public void addClassConstraint(String constraint) {
        this.classes.add(constraint);
    }

    @Override
    public String toString() {
        return this.getStringForRuleString(null, null, 0, 0, 0, 0, 0);
    }
}

