/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.assemblerbroker.util.python;

import java.io.File;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.turbine.modules.Assembler;
import org.apache.turbine.modules.Loader;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.assemblerbroker.util.AssemblerFactory;
import org.python.core.Py;
import org.python.util.PythonInterpreter;

public abstract class PythonBaseFactory<T extends Assembler>
implements AssemblerFactory<T> {
    public static final String PYTHON_PATH = "python.path";
    public static final String PYTHON_CONFIG_FILE = "conf.py";
    private static Logger log = LogManager.getLogger(PythonBaseFactory.class);
    private final Configuration conf = TurbineServices.getInstance().getConfiguration("AssemblerBrokerService");

    public T getAssembler(String subDirectory, String name) throws Exception {
        String path = this.conf.getString(PYTHON_PATH);
        if (StringUtils.isEmpty((CharSequence)path)) {
            throw new Exception("Python path not found - check your Properties");
        }
        log.debug("Screen name for JPython: {}", (Object)name);
        Assembler assembler = null;
        String confName = path + "/" + PYTHON_CONFIG_FILE;
        StringBuilder fName = new StringBuilder();
        fName.append(path);
        fName.append("/");
        fName.append(subDirectory);
        fName.append("/");
        fName.append(name.toLowerCase());
        fName.append(".py");
        File f = new File(fName.toString());
        if (f.exists()) {
            try (PythonInterpreter interp = new PythonInterpreter();){
                Assembler t;
                Py.getSystemState().setClassLoader(this.getClass().getClassLoader());
                interp.exec("import sys");
                interp.execfile(confName);
                interp.execfile(fName.toString());
                try {
                    interp.exec("scr = " + name + "()");
                }
                catch (Throwable e) {
                    throw new Exception("\nCannot create an instance of the python class.\nYou probably gave your class the wrong name.\nYour class should have the same name as your filename.\nFilenames should be all lowercase and classnames should start with a capital.\nExpected class name: " + name + "\n");
                }
                assembler = t = (Assembler)interp.get("scr", Assembler.class);
            }
            catch (Exception e) {
                log.error("PYTHON SCRIPT SCREEN LOADER ERROR:", (Throwable)e);
                throw e;
            }
        }
        return (T)assembler;
    }

    @Override
    public abstract Loader<T> getLoader();

    @Override
    public int getCacheSize() {
        return this.getLoader().getCacheSize();
    }
}

