/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.hikari.pool;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.pool.BaseHikariPool;
import com.zaxxer.hikari.pool.PoolBagEntry;
import com.zaxxer.hikari.util.ConcurrentBag;
import com.zaxxer.hikari.util.IBagStateListener;
import com.zaxxer.hikari.util.Java6ConcurrentBag;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

public final class HikariPool
extends BaseHikariPool {
    public HikariPool(HikariConfig configuration) {
        this(configuration, configuration.getUsername(), configuration.getPassword());
    }

    public HikariPool(HikariConfig configuration, String username, String password) {
        super(configuration, username, password);
    }

    @Override
    public void softEvictConnections() {
        for (PoolBagEntry bagEntry : this.connectionBag.values(1)) {
            bagEntry.evicted = true;
        }
        for (PoolBagEntry bagEntry : this.connectionBag.values(0)) {
            if (!this.connectionBag.reserve(bagEntry)) continue;
            this.closeConnection(bagEntry, "(connection evicted by user)");
        }
    }

    @Override
    protected void closeConnection(PoolBagEntry bagEntry, final String closureReason) {
        bagEntry.cancelMaxLifeTermination();
        if (this.connectionBag.remove(bagEntry)) {
            int tc = this.totalConnections.decrementAndGet();
            if (tc < 0) {
                this.LOGGER.warn("Internal accounting inconsistency, totalConnections={}", (Object)tc, (Object)new Exception());
            }
            final Connection connection = bagEntry.connection;
            this.closeConnectionExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    HikariPool.this.poolUtils.quietlyCloseConnection(connection, closureReason);
                }
            });
        }
        bagEntry.connection = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean isConnectionAlive(Connection connection) {
        try {
            this.LOGGER.debug("Performing alive check for connection {}", (Object)connection);
            int timeoutSec = (int)TimeUnit.MILLISECONDS.toSeconds(this.validationTimeout);
            if (this.isUseJdbc4Validation) {
                return connection.isValid(timeoutSec);
            }
            int originalTimeout = this.poolUtils.getAndSetNetworkTimeout(connection, this.validationTimeout);
            Statement statement = connection.createStatement();
            try {
                this.poolUtils.setQueryTimeout(statement, timeoutSec);
                statement.executeQuery(this.configuration.getConnectionTestQuery());
            }
            finally {
                statement.close();
            }
            if (this.isIsolateInternalQueries && !this.isAutoCommit) {
                connection.rollback();
            }
            this.poolUtils.setNetworkTimeout(connection, originalTimeout);
            return true;
        }
        catch (SQLException e) {
            this.LOGGER.warn("Exception during keep alive check, that means the connection ({}) must be dead.", (Object)connection, (Object)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void abortActiveConnections(ExecutorService assassinExecutor) throws InterruptedException {
        for (PoolBagEntry bagEntry : this.connectionBag.values(1)) {
            try {
                bagEntry.evicted = true;
                bagEntry.aborted = true;
                bagEntry.connection.abort(assassinExecutor);
            }
            catch (Throwable e) {
                if (e instanceof InterruptedException) {
                    throw (InterruptedException)e;
                }
                this.poolUtils.quietlyCloseConnection(bagEntry.connection, "(connection aborted during shutdown)");
            }
            finally {
                bagEntry.connection = null;
                if (!this.connectionBag.remove(bagEntry)) continue;
                this.totalConnections.decrementAndGet();
            }
        }
    }

    @Override
    protected Runnable getHouseKeeper() {
        return new HouseKeeper();
    }

    @Override
    protected ConcurrentBag<PoolBagEntry> createConcurrentBag(IBagStateListener listener) {
        return new Java6ConcurrentBag(listener);
    }

    private class HouseKeeper
    implements Runnable {
        private HouseKeeper() {
        }

        @Override
        public void run() {
            HikariPool.this.logPoolState("Before cleanup ");
            HikariPool.this.connectionTimeout = HikariPool.this.configuration.getConnectionTimeout();
            long now = System.currentTimeMillis();
            long idleTimeout = HikariPool.this.configuration.getIdleTimeout();
            for (PoolBagEntry bagEntry : HikariPool.this.connectionBag.values(0)) {
                if (!HikariPool.this.connectionBag.reserve(bagEntry)) continue;
                if (bagEntry.evicted) {
                    HikariPool.this.closeConnection(bagEntry, "(connection evicted)");
                    continue;
                }
                if (idleTimeout > 0L && now > bagEntry.lastAccess + idleTimeout) {
                    HikariPool.this.closeConnection(bagEntry, "(connection passed idleTimeout)");
                    continue;
                }
                HikariPool.this.connectionBag.unreserve(bagEntry);
            }
            HikariPool.this.logPoolState("After cleanup ");
            HikariPool.this.fillPool();
        }
    }
}

