/*
 * Decompiled with CFR 0.152.
 */
package net.sf.qualitycheck;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.sf.qualitycheck.ArgumentsChecked;
import net.sf.qualitycheck.Check;
import net.sf.qualitycheck.Throws;
import net.sf.qualitycheck.exception.IllegalArgumentNotContainedException;
import net.sf.qualitycheck.exception.IllegalEmptyArgumentException;
import net.sf.qualitycheck.exception.IllegalInstanceOfArgumentException;
import net.sf.qualitycheck.exception.IllegalMissingAnnotationException;
import net.sf.qualitycheck.exception.IllegalNaNArgumentException;
import net.sf.qualitycheck.exception.IllegalNegativeArgumentException;
import net.sf.qualitycheck.exception.IllegalNotEqualException;
import net.sf.qualitycheck.exception.IllegalNotGreaterOrEqualThanException;
import net.sf.qualitycheck.exception.IllegalNotGreaterThanException;
import net.sf.qualitycheck.exception.IllegalNotLesserThanException;
import net.sf.qualitycheck.exception.IllegalNotNullArgumentException;
import net.sf.qualitycheck.exception.IllegalNullArgumentException;
import net.sf.qualitycheck.exception.IllegalNullElementsException;
import net.sf.qualitycheck.exception.IllegalNumberArgumentException;
import net.sf.qualitycheck.exception.IllegalNumericArgumentException;
import net.sf.qualitycheck.exception.IllegalPatternArgumentException;
import net.sf.qualitycheck.exception.IllegalPositionIndexException;
import net.sf.qualitycheck.exception.IllegalPositiveArgumentException;
import net.sf.qualitycheck.exception.IllegalRangeException;
import net.sf.qualitycheck.exception.IllegalStateOfArgumentException;
import net.sf.qualitycheck.exception.RuntimeInstantiationException;

public final class ConditionalCheck {
    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalArgumentNotContainedException.class})
    public static <T> void contains(boolean condition, @Nonnull Collection<T> haystack, @Nonnull T needle) {
        if (condition) {
            Check.contains(haystack, needle);
        }
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalArgumentNotContainedException.class})
    public static <T> void contains(boolean condition, @Nonnull Collection<T> haystack, @Nonnull T needle, @Nonnull String name) {
        if (condition) {
            Check.contains(haystack, needle, name);
        }
    }

    @Throws(value={IllegalNotEqualException.class})
    public static void equals(boolean condition, @Nonnull boolean expected, @Nonnull boolean check) {
        if (condition) {
            Check.equals(expected, check);
        }
    }

    @Throws(value={IllegalNotEqualException.class})
    public static void equals(boolean condition, @Nonnull boolean expected, @Nonnull boolean check, String message) {
        if (condition) {
            Check.equals(expected, check, message);
        }
    }

    @Throws(value={IllegalNotEqualException.class})
    public static void equals(boolean condition, @Nonnull byte expected, @Nonnull byte check) {
        if (condition) {
            Check.equals(expected, check);
        }
    }

    @Throws(value={IllegalNotEqualException.class})
    public static void equals(boolean condition, @Nonnull byte expected, @Nonnull byte check, String message) {
        if (condition) {
            Check.equals(expected, check, message);
        }
    }

    @Throws(value={IllegalNotEqualException.class})
    public static void equals(boolean condition, @Nonnull char expected, @Nonnull char check) {
        if (condition) {
            Check.equals(expected, check);
        }
    }

    @Throws(value={IllegalNotEqualException.class})
    public static void equals(boolean condition, @Nonnull char expected, @Nonnull char check, String message) {
        if (condition) {
            Check.equals(expected, check, message);
        }
    }

    @Throws(value={IllegalNotEqualException.class})
    public static void equals(boolean condition, @Nonnull int expected, @Nonnull int check) {
        if (condition) {
            Check.equals(expected, check);
        }
    }

    @Throws(value={IllegalNotEqualException.class})
    public static void equals(boolean condition, @Nonnull int expected, @Nonnull int check, String message) {
        if (condition) {
            Check.equals(expected, check, message);
        }
    }

    @Throws(value={IllegalNotEqualException.class})
    public static void equals(boolean condition, @Nonnull long expected, @Nonnull long check) {
        if (condition) {
            Check.equals(expected, check);
        }
    }

    @Throws(value={IllegalNotEqualException.class})
    public static void equals(boolean condition, @Nonnull long expected, @Nonnull long check, String message) {
        if (condition) {
            Check.equals(expected, check, message);
        }
    }

    @Throws(value={IllegalNotEqualException.class})
    public static void equals(boolean condition, @Nonnull short expected, @Nonnull short check) {
        if (condition) {
            Check.equals(expected, check);
        }
    }

    @Throws(value={IllegalNotEqualException.class})
    public static void equals(boolean condition, @Nonnull short expected, @Nonnull short check, String message) {
        if (condition) {
            Check.equals(expected, check, message);
        }
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalNotEqualException.class})
    public static <T> T equals(boolean condition, @Nonnull T expected, @Nonnull T check) {
        if (condition) {
            return Check.equals(expected, check);
        }
        return check;
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalNotEqualException.class})
    public static <T> void equals(boolean condition, @Nonnull T expect, @Nonnull T check, String msg) {
        if (condition) {
            Check.equals(expect, check);
        }
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalNotGreaterOrEqualThanException.class})
    public static <T extends Comparable<T>> void greaterOrEqualThan(boolean condition, @Nonnull T expected, @Nonnull T check) {
        Check.notNull(expected, "expected");
        Check.notNull(check, "check");
        if (condition) {
            Check.greaterOrEqualThan(expected, check);
        }
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalNotGreaterOrEqualThanException.class})
    public static <T extends Comparable<T>> void greaterOrEqualThan(boolean condition, @Nonnull T expected, @Nonnull T check, String message) {
        Check.notNull(expected, "expected");
        Check.notNull(check, "check");
        if (condition) {
            Check.greaterOrEqualThan(expected, check, message);
        }
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalNotGreaterThanException.class})
    public static <T extends Comparable<T>> void greaterThan(boolean condition, @Nonnull T expected, @Nonnull T check) {
        Check.notNull(expected, "expected");
        Check.notNull(check, "check");
        if (condition) {
            Check.greaterThan(expected, check);
        }
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalNotGreaterThanException.class})
    public static <T extends Comparable<T>> void greaterThan(boolean condition, @Nonnull T expected, @Nonnull T check, String message) {
        Check.notNull(expected, "expected");
        Check.notNull(check, "check");
        if (condition) {
            Check.greaterThan(expected, check, message);
        }
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalMissingAnnotationException.class})
    public static void hasAnnotation(boolean condition, @Nonnull Class<?> clazz, @Nonnull Class<? extends Annotation> annotation) {
        Check.notNull(clazz, "clazz");
        Check.notNull(annotation, "annotation");
        if (condition) {
            Check.hasAnnotation(clazz, annotation);
        }
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalInstanceOfArgumentException.class})
    public static <T> T instanceOf(boolean condition, @Nonnull Class<?> type, @Nonnull Object obj) {
        if (condition) {
            return Check.instanceOf(type, obj);
        }
        return (T)obj;
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalInstanceOfArgumentException.class})
    public static <T> T instanceOf(boolean condition, @Nonnull Class<?> type, @Nonnull Object obj, @Nullable String name) {
        if (condition) {
            return Check.instanceOf(type, obj, name);
        }
        return (T)obj;
    }

    @Throws(value={IllegalNotNullArgumentException.class})
    public static void isNull(boolean condition, @Nullable Object reference) {
        if (condition) {
            Check.isNull(reference);
        }
    }

    @Throws(value={IllegalNotNullArgumentException.class})
    public static void isNull(boolean condition, @Nullable Object reference, @Nullable String name) {
        if (condition) {
            Check.isNull(reference, name);
        }
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalNumberArgumentException.class})
    public static void isNumber(boolean condition, @Nonnull String value) {
        if (condition) {
            Check.isNumber(value);
        }
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalNumberArgumentException.class})
    public static <T extends Number> void isNumber(boolean condition, @Nonnull String value, @Nonnull Class<T> type) {
        if (condition) {
            Check.isNumber(value, type);
        }
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalNumberArgumentException.class})
    public static void isNumber(boolean condition, @Nonnull String value, @Nullable String name) {
        if (condition) {
            Check.isNumber(value, name);
        }
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalNumberArgumentException.class})
    public static <T extends Number> void isNumber(boolean condition, @Nonnull String value, @Nullable String name, @Nonnull Class<T> type) {
        if (condition) {
            Check.isNumber(value, name, type);
        }
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalNumberArgumentException.class})
    public static <T extends CharSequence> void isNumeric(boolean condition, @Nonnull T value) {
        if (condition) {
            Check.isNumeric(value);
        }
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalNumericArgumentException.class})
    public static <T extends CharSequence> void isNumeric(boolean condition, @Nonnull T value, @Nullable String name) {
        if (condition) {
            Check.isNumeric(value, name);
        }
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalNotLesserThanException.class})
    public static <T extends Comparable<T>> void lesserThan(boolean condition, @Nonnull T expected, @Nonnull T check) {
        Check.notNull(expected, "expected");
        Check.notNull(check, "check");
        if (condition) {
            Check.lesserThan(expected, check);
        }
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalNotLesserThanException.class})
    public static <T extends Comparable<T>> void lesserThan(boolean condition, @Nonnull T expected, @Nonnull T check, String message) {
        Check.notNull(expected, "expected");
        Check.notNull(check, "check");
        if (condition) {
            Check.lesserThan(expected, check, message);
        }
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class})
    public static <T extends CharSequence> void matchesPattern(boolean condition, @Nonnull Pattern pattern, @Nonnull T chars) {
        if (condition) {
            Check.matchesPattern(pattern, chars);
        }
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalPatternArgumentException.class})
    public static <T extends CharSequence> void matchesPattern(boolean condition, @Nonnull Pattern pattern, @Nonnull T chars, @Nullable String name) {
        if (condition) {
            Check.matchesPattern(pattern, chars, name);
        }
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalNullElementsException.class})
    public static <T extends Iterable<?>> void noNullElements(boolean condition, @Nonnull T iterable) {
        if (condition) {
            Check.noNullElements(iterable);
        }
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalNullElementsException.class})
    public static <T extends Iterable<?>> void noNullElements(boolean condition, @Nonnull T iterable, String name) {
        if (condition) {
            Check.noNullElements(iterable, name);
        }
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalNullElementsException.class})
    public static <T> void noNullElements(boolean condition, @Nonnull T[] array) {
        if (condition) {
            Check.noNullElements(array);
        }
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalNullElementsException.class})
    public static <T> void noNullElements(boolean condition, @Nonnull T[] array, @Nullable String name) {
        if (condition) {
            Check.noNullElements(array, name);
        }
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalEmptyArgumentException.class})
    public static void notEmpty(boolean condition, boolean expression) {
        if (condition) {
            Check.notEmpty(expression);
        }
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalEmptyArgumentException.class})
    public static void notEmpty(boolean condition, boolean expression, @Nullable String name) {
        if (condition) {
            Check.notEmpty(expression, name);
        }
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalEmptyArgumentException.class})
    public static <T extends CharSequence> void notEmpty(boolean condition, @Nonnull T chars) {
        if (condition) {
            Check.notEmpty(chars);
        }
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalEmptyArgumentException.class})
    public static <T extends Collection<?>> void notEmpty(boolean condition, @Nonnull T collection) {
        if (condition) {
            Check.notEmpty(collection);
        }
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalEmptyArgumentException.class})
    public static <T extends Map<?, ?>> void notEmpty(boolean condition, @Nonnull T map) {
        if (condition) {
            Check.notEmpty(map);
        }
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalEmptyArgumentException.class})
    public static <T> void notEmpty(boolean condition, @Nonnull T reference, boolean expression, @Nullable String name) {
        if (condition) {
            Check.notEmpty(reference, expression, name);
        }
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalEmptyArgumentException.class})
    public static <T extends CharSequence> void notEmpty(boolean condition, @Nonnull T chars, @Nullable String name) {
        if (condition) {
            Check.notEmpty(chars, name);
        }
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalEmptyArgumentException.class})
    public static <T extends Map<?, ?>> void notEmpty(boolean condition, @Nonnull T map, @Nullable String name) {
        if (condition) {
            Check.notEmpty(map, name);
        }
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalEmptyArgumentException.class})
    public static <T extends Collection<?>> void notEmpty(boolean condition, @Nonnull T collection, @Nullable String name) {
        if (condition) {
            Check.notEmpty(collection, name);
        }
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalEmptyArgumentException.class})
    public static <T> void notEmpty(boolean condition, @Nonnull T[] array) {
        if (condition) {
            Check.notEmpty(array);
        }
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalEmptyArgumentException.class})
    public static <T> void notEmpty(boolean condition, @Nonnull T[] array, @Nullable String name) {
        if (condition) {
            Check.notEmpty(array, name);
        }
    }

    @Throws(value={IllegalNaNArgumentException.class})
    public static void notNaN(boolean condition, double value) {
        if (condition) {
            Check.notNaN(value);
        }
    }

    @Throws(value={IllegalNaNArgumentException.class})
    public static void notNaN(boolean condition, double value, @Nullable String name) {
        if (condition) {
            Check.notNaN(value, name);
        }
    }

    @Throws(value={IllegalNaNArgumentException.class})
    public static void notNaN(boolean condition, float value) {
        if (condition) {
            Check.notNaN(value);
        }
    }

    @Throws(value={IllegalNaNArgumentException.class})
    public static void notNaN(boolean condition, float value, @Nullable String name) {
        if (condition) {
            Check.notNaN(value, name);
        }
    }

    @Throws(value={IllegalNegativeArgumentException.class})
    public static void notNegative(boolean condition, @Nonnull int value) {
        if (condition) {
            Check.notNegative(value);
        }
    }

    @Throws(value={IllegalNegativeArgumentException.class})
    public static void notNegative(boolean condition, @Nonnull int value, @Nullable String name) {
        if (condition) {
            Check.notNegative(value, name);
        }
    }

    @Throws(value={IllegalNullArgumentException.class})
    public static <T> void notNull(boolean condition, @Nonnull T reference) {
        if (condition) {
            Check.notNull(reference);
        }
    }

    @Throws(value={IllegalNullArgumentException.class})
    public static <T> void notNull(boolean condition, @Nonnull T reference, @Nullable String name) {
        if (condition) {
            Check.notNull(reference, name);
        }
    }

    @Throws(value={IllegalPositiveArgumentException.class})
    public static void notPositive(boolean condition, @Nonnull int value) {
        if (condition) {
            Check.notPositive(value);
        }
    }

    @Throws(value={IllegalPositiveArgumentException.class})
    public static void notPositive(boolean condition, @Nonnull int value, @Nullable String name) {
        if (condition) {
            Check.notPositive(value, name);
        }
    }

    @Throws(value={IllegalPositionIndexException.class})
    public static void positionIndex(boolean condition, int index, int size) {
        if (condition) {
            Check.positionIndex(index, size);
        }
    }

    @Throws(value={IllegalRangeException.class})
    public static void range(boolean condition, @Nonnegative int start, @Nonnegative int end, @Nonnegative int size) {
        if (condition) {
            Check.range(start, end, size);
        }
    }

    @Throws(value={IllegalStateOfArgumentException.class})
    public static void stateIsTrue(boolean condition, boolean expression) {
        if (condition) {
            Check.stateIsTrue(expression);
        }
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, RuntimeInstantiationException.class})
    public static void stateIsTrue(boolean condition, boolean expression, Class<? extends RuntimeException> clazz) {
        if (condition) {
            Check.stateIsTrue(expression, clazz);
        }
    }

    @Throws(value={IllegalStateOfArgumentException.class})
    public static void stateIsTrue(boolean condition, boolean expression, @Nonnull String description) {
        if (condition) {
            Check.stateIsTrue(expression, description);
        }
    }

    @Throws(value={IllegalStateOfArgumentException.class})
    public static void stateIsTrue(boolean condition, boolean expression, @Nonnull String descriptionTemplate, Object ... descriptionTemplateArgs) {
        if (condition) {
            Check.stateIsTrue(expression, descriptionTemplate, descriptionTemplateArgs);
        }
    }

    private ConditionalCheck() {
    }
}

