/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.schedule;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.turbine.modules.ScheduledJobLoader;
import org.apache.turbine.services.schedule.JobEntry;

public class WorkerThread
implements Runnable {
    private JobEntry je = null;
    private static Log log = LogFactory.getLog((String)"scheduler");

    public WorkerThread(JobEntry je) {
        this.je = je;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.je == null || this.je.isActive()) {
            return;
        }
        try {
            if (!this.je.isActive()) {
                this.je.setActive(true);
                this.logStateChange("started");
                ScheduledJobLoader.getInstance().exec(this.je, this.je.getTask());
            }
        }
        catch (Exception e) {
            log.error((Object)("Error in WorkerThread for scheduled job #" + this.je.getJobId() + ", task: " + this.je.getTask()), (Throwable)e);
        }
        finally {
            if (this.je.isActive()) {
                this.je.setActive(false);
                this.logStateChange("completed");
            }
        }
    }

    private final void logStateChange(String state) {
        log.debug((Object)("Scheduled job #" + this.je.getJobId() + ' ' + state + ", task: " + this.je.getTask()));
    }
}

