/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.logger.factory;

import org.apache.avalon.excalibur.logger.LogTargetFactory;
import org.apache.avalon.excalibur.logger.LogTargetFactoryManageable;
import org.apache.avalon.excalibur.logger.LogTargetFactoryManager;
import org.apache.avalon.excalibur.logger.factory.AbstractTargetFactory;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.log.LogTarget;
import org.apache.log.Priority;
import org.apache.log.output.PriorityFilteringTarget;

public final class PriorityFilterTargetFactory
extends AbstractTargetFactory
implements LogTargetFactoryManageable {
    protected LogTargetFactoryManager m_logTargetFactoryManager;

    public final LogTarget createTarget(Configuration configuration) throws ConfigurationException {
        String loglevel = configuration.getAttribute("log-level", "INFO");
        this.getLogger().debug("loglevel is " + loglevel);
        boolean closeWrappedTargets = configuration.getAttributeAsBoolean("close-wrapped-targets", true);
        PriorityFilteringTarget filter = new PriorityFilteringTarget(Priority.getPriorityForName((String)loglevel), closeWrappedTargets);
        Configuration[] configs = configuration.getChildren();
        for (int i = 0; i < configs.length; ++i) {
            LogTargetFactory factory = this.m_logTargetFactoryManager.getLogTargetFactory(configs[i].getName());
            if (null == factory) {
                throw new ConfigurationException("Unknown target type '" + configs[i].getName() + "' at " + configs[i].getLocation());
            }
            this.getLogger().debug("creating target " + configs[i].getName() + ": " + configs[i].toString());
            LogTarget logtarget = factory.createTarget(configs[i]);
            filter.addTarget(logtarget);
        }
        return filter;
    }

    public final void setLogTargetFactoryManager(LogTargetFactoryManager logTargetFactoryManager) {
        this.m_logTargetFactoryManager = logTargetFactoryManager;
    }
}

