/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.intake.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool.BaseKeyedPoolableObjectFactory;
import org.apache.fulcrum.intake.IntakeException;
import org.apache.fulcrum.intake.IntakeServiceFacade;
import org.apache.fulcrum.intake.Retrievable;
import org.apache.fulcrum.intake.model.Field;
import org.apache.fulcrum.intake.model.FieldFactory;
import org.apache.fulcrum.intake.xmlmodel.AppData;
import org.apache.fulcrum.intake.xmlmodel.XmlField;
import org.apache.fulcrum.intake.xmlmodel.XmlGroup;
import org.apache.fulcrum.parser.ValueParser;

public class Group {
    public static final String EMPTY = "";
    public static final String NEW = "_0";
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$fulcrum$intake$model$Group == null ? (class$org$apache$fulcrum$intake$model$Group = Group.class$("org.apache.fulcrum.intake.model.Group")) : class$org$apache$fulcrum$intake$model$Group));
    private static final boolean isDebugEnabled = log.isDebugEnabled();
    protected final String gid;
    protected final String name;
    private final int poolCapacity;
    protected Map fields;
    protected Map mapToObjectFields;
    protected Field[] fieldsArray;
    protected String oid;
    protected ValueParser pp;
    protected boolean isDeclared;
    static /* synthetic */ Class class$org$apache$fulcrum$intake$model$Group;

    public Group(XmlGroup group) throws IntakeException {
        this.gid = group.getKey();
        this.name = group.getName();
        this.poolCapacity = Integer.parseInt(group.getPoolCapacity());
        List inputFields = group.getFields();
        int size = inputFields.size();
        this.fields = new HashMap((int)(1.25 * (double)size + 1.0));
        this.mapToObjectFields = new HashMap((int)(1.25 * (double)size + 1.0));
        this.fieldsArray = new Field[size];
        for (int i = size - 1; i >= 0; --i) {
            Field field;
            XmlField f = (XmlField)inputFields.get(i);
            this.fieldsArray[i] = field = FieldFactory.getInstance(f, this);
            this.fields.put(f.getName(), field);
            ArrayList<Field> tmpFields = (ArrayList<Field>)this.mapToObjectFields.get(f.getMapToObject());
            if (tmpFields == null) {
                tmpFields = new ArrayList<Field>(size);
                this.mapToObjectFields.put(f.getMapToObject(), tmpFields);
            }
            tmpFields.add(field);
        }
        Iterator keys = this.mapToObjectFields.keySet().iterator();
        while (keys.hasNext()) {
            Object key = keys.next();
            List tmpFields = (List)this.mapToObjectFields.get(key);
            this.mapToObjectFields.put(key, tmpFields.toArray(new Field[tmpFields.size()]));
        }
    }

    public Group init(ValueParser pp) throws IntakeException {
        return this.init(NEW, pp);
    }

    public Group init(String key, ValueParser pp) throws IntakeException {
        this.oid = key;
        this.pp = pp;
        for (int i = this.fieldsArray.length - 1; i >= 0; --i) {
            this.fieldsArray[i].init(pp);
        }
        return this;
    }

    public Group init(Retrievable obj) {
        this.oid = obj.getQueryKey();
        for (Class<?> cls = obj.getClass(); cls != null; cls = cls.getSuperclass()) {
            Field[] flds = (Field[])this.mapToObjectFields.get(cls.getName());
            if (flds != null) {
                for (int i = flds.length - 1; i >= 0; --i) {
                    flds[i].init(obj);
                }
            }
            Class<?>[] interfaces = cls.getInterfaces();
            for (int idx = 0; idx < interfaces.length; ++idx) {
                Field[] interfaceFields = (Field[])this.mapToObjectFields.get(interfaces[idx].getName());
                if (interfaceFields == null) continue;
                for (int i = 0; i < interfaceFields.length; ++i) {
                    interfaceFields[i].init(obj);
                }
            }
        }
        return this;
    }

    public String[] getFieldNames() {
        String[] nameList = new String[this.fieldsArray.length];
        for (int i = 0; i < nameList.length; ++i) {
            nameList[i] = this.fieldsArray[i].name;
        }
        return nameList;
    }

    public String getIntakeGroupName() {
        return this.name;
    }

    public int getPoolCapacity() {
        return this.poolCapacity;
    }

    public String getGID() {
        return this.gid;
    }

    public String getOID() {
        return this.oid;
    }

    public String getObjectKey() {
        return this.gid + this.oid;
    }

    public ArrayList getObjects(ValueParser pp) throws IntakeException {
        ArrayList<Group> objs = null;
        String[] oids = pp.getStrings(this.gid);
        if (oids != null) {
            objs = new ArrayList<Group>(oids.length);
            for (int i = oids.length - 1; i >= 0; --i) {
                objs.add(IntakeServiceFacade.getGroup(this.name).init(oids[i], pp));
            }
        }
        return objs;
    }

    public Field get(String fieldName) throws IntakeException {
        if (this.fields.containsKey(fieldName)) {
            return (Field)this.fields.get(fieldName);
        }
        throw new IntakeException("Intake Field name: " + fieldName + " not found in Group " + this.name);
    }

    public boolean isAllValid() {
        boolean valid = true;
        for (int i = this.fieldsArray.length - 1; i >= 0; --i) {
            valid &= this.fieldsArray[i].isValid();
            if (!isDebugEnabled || this.fieldsArray[i].isValid()) continue;
            log.debug((Object)("Group(" + this.oid + "): " + this.name + "; Field: " + this.fieldsArray[i].name + "; value=" + this.fieldsArray[i].getValue() + " is invalid!"));
        }
        return valid;
    }

    public void setProperties(Object obj) throws IntakeException {
        for (Class<?> cls = obj.getClass(); cls != null; cls = cls.getSuperclass()) {
            Field[] flds;
            if (isDebugEnabled) {
                log.debug((Object)("setProperties(" + cls.getName() + ")"));
            }
            if ((flds = (Field[])this.mapToObjectFields.get(cls.getName())) != null) {
                for (int i = flds.length - 1; i >= 0; --i) {
                    flds[i].setProperty(obj);
                }
            }
            Class<?>[] interfaces = cls.getInterfaces();
            for (int idx = 0; idx < interfaces.length; ++idx) {
                Field[] interfaceFields = (Field[])this.mapToObjectFields.get(interfaces[idx].getName());
                if (interfaceFields == null) continue;
                for (int i = 0; i < interfaceFields.length; ++i) {
                    interfaceFields[i].setProperty(obj);
                }
            }
        }
        log.debug((Object)"setProperties() finished");
    }

    public void setValidProperties(Object obj) {
        for (Class<?> cls = obj.getClass(); cls != null; cls = cls.getSuperclass()) {
            Field[] flds = (Field[])this.mapToObjectFields.get(cls.getName());
            if (flds != null) {
                for (int i = flds.length - 1; i >= 0; --i) {
                    try {
                        flds[i].setProperty(obj);
                        continue;
                    }
                    catch (IntakeException e) {
                        // empty catch block
                    }
                }
            }
            Class<?>[] interfaces = cls.getInterfaces();
            for (int idx = 0; idx < interfaces.length; ++idx) {
                Field[] interfaceFields = (Field[])this.mapToObjectFields.get(interfaces[idx].getName());
                if (interfaceFields == null) continue;
                for (int i = 0; i < interfaceFields.length; ++i) {
                    try {
                        interfaceFields[i].setProperty(obj);
                        continue;
                    }
                    catch (IntakeException e) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public void getProperties(Object obj) throws IntakeException {
        for (Class<?> cls = obj.getClass(); cls != null; cls = cls.getSuperclass()) {
            Field[] flds = (Field[])this.mapToObjectFields.get(cls.getName());
            if (flds != null) {
                for (int i = flds.length - 1; i >= 0; --i) {
                    flds[i].getProperty(obj);
                }
            }
            Class<?>[] interfaces = cls.getInterfaces();
            for (int idx = 0; idx < interfaces.length; ++idx) {
                Field[] interfaceFields = (Field[])this.mapToObjectFields.get(interfaces[idx].getName());
                if (interfaceFields == null) continue;
                for (int i = 0; i < interfaceFields.length; ++i) {
                    interfaceFields[i].getProperty(obj);
                }
            }
        }
    }

    public void removeFromRequest() {
        String[] groups;
        if (this.pp != null && (groups = this.pp.getStrings(this.gid)) != null) {
            int i;
            this.pp.remove(this.gid);
            for (i = 0; i < groups.length; ++i) {
                if (groups[i] == null || groups[i].equals(this.oid)) continue;
                this.pp.add(this.gid, groups[i]);
            }
            for (i = this.fieldsArray.length - 1; i >= 0; --i) {
                this.fieldsArray[i].removeFromRequest();
            }
        }
    }

    public void resetDeclared() {
        this.isDeclared = false;
    }

    public String getHtmlFormInput() {
        StringBuffer sb = new StringBuffer(64);
        this.appendHtmlFormInput(sb);
        return sb.toString();
    }

    public void appendHtmlFormInput(StringBuffer sb) {
        if (!this.isDeclared) {
            this.isDeclared = true;
            sb.append("<input type=\"hidden\" name=\"").append(this.gid).append("\" value=\"").append(this.oid).append("\"/>\n");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class GroupFactory
    extends BaseKeyedPoolableObjectFactory {
        private AppData appData;

        public GroupFactory(AppData appData) {
            this.appData = appData;
        }

        public Object makeObject(Object key) throws IntakeException {
            return new Group(this.appData.getGroup((String)key));
        }

        public void passivateObject(Object key, Object obj) {
            Group group = (Group)obj;
            group.oid = null;
            group.pp = null;
            for (int i = group.fieldsArray.length - 1; i >= 0; --i) {
                group.fieldsArray[i].dispose();
            }
            group.isDeclared = false;
        }
    }
}

