/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.security.torque;

import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.TorqueException;
import org.apache.torque.om.Persistent;
import org.apache.torque.util.BasePeer;
import org.apache.torque.util.Criteria;
import org.apache.turbine.om.security.Permission;
import org.apache.turbine.om.security.Role;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.security.TurbineSecurity;
import org.apache.turbine.services.security.torque.PermissionPeerManagerConstants;
import org.apache.turbine.services.security.torque.TorquePermission;
import org.apache.turbine.services.security.torque.om.TurbineRolePermissionPeer;
import org.apache.turbine.util.security.DataBackendException;
import org.apache.turbine.util.security.PermissionSet;

public class PermissionPeerManager
implements PermissionPeerManagerConstants {
    private static Class persistentPeerClass = null;
    private static Class permissionObject = null;
    private static String tableName = null;
    private static String nameColumn = null;
    private static String idColumn = null;
    private static PropertyDescriptor namePropDesc = null;
    private static PropertyDescriptor idPropDesc = null;
    static Log log = LogFactory.getLog((Class)PermissionPeerManager.class);

    public static void init(Configuration conf) throws InitializationException {
        block6: {
            String persistentPeerClassName = conf.getString("torque.permissionPeer.class", PERMISSION_PEER_CLASS_DEFAULT);
            String permissionObjectName = null;
            try {
                persistentPeerClass = Class.forName(persistentPeerClassName);
                tableName = (String)persistentPeerClass.getField("TABLE_NAME").get(null);
                permissionObject = PermissionPeerManager.getPersistenceClass();
                permissionObjectName = conf.getString("torque.permission.class", permissionObject.getName());
                permissionObject = Class.forName(permissionObjectName);
                nameColumn = (String)persistentPeerClass.getField(conf.getString("torque.permissionPeer.column.name", "PERMISSION_NAME")).get(null);
                idColumn = (String)persistentPeerClass.getField(conf.getString("torque.permissionPeer.column.id", "PERMISSION_ID")).get(null);
                namePropDesc = new PropertyDescriptor(conf.getString("torque.permission.property.name", "Name"), permissionObject);
                idPropDesc = new PropertyDescriptor(conf.getString("torque.permission.property.id", "PermissionId"), permissionObject);
            }
            catch (Exception e) {
                if (persistentPeerClassName == null || persistentPeerClass == null) {
                    throw new InitializationException("Could not find PermissionPeer class (" + persistentPeerClassName + ")", e);
                }
                if (tableName == null) {
                    throw new InitializationException("Failed to get the table name from the Peer object", e);
                }
                if (permissionObject == null || permissionObjectName == null) {
                    throw new InitializationException("Failed to get the object type from the Peer object", e);
                }
                if (nameColumn == null || namePropDesc == null) {
                    throw new InitializationException("PermissionPeer " + persistentPeerClassName + " has no name column information!", e);
                }
                if (idColumn != null && idPropDesc != null) break block6;
                throw new InitializationException("PermissionPeer " + persistentPeerClassName + " has no id column information!", e);
            }
        }
    }

    public static String getTableName() {
        return tableName;
    }

    public static String getNameColumn() {
        return nameColumn;
    }

    public static String getIdColumn() {
        return idColumn;
    }

    public static String getColumnName(String name) {
        StringBuffer sb = new StringBuffer();
        sb.append(PermissionPeerManager.getTableName());
        sb.append(".");
        sb.append(name);
        return sb.toString();
    }

    public static Persistent newPersistentInstance() {
        Persistent obj = null;
        if (permissionObject == null) {
            return obj;
        }
        try {
            obj = (Persistent)permissionObject.newInstance();
        }
        catch (Exception e) {
            log.error((Object)"Could not instantiate a permission object", (Throwable)e);
            obj = null;
        }
        return obj;
    }

    public static boolean checkExists(Permission permission) throws DataBackendException, Exception {
        Criteria criteria = new Criteria();
        criteria.addSelectColumn(PermissionPeerManager.getIdColumn());
        criteria.add(PermissionPeerManager.getNameColumn(), (Object)permission.getName());
        List results = BasePeer.doSelect((Criteria)criteria);
        if (results.size() > 1) {
            throw new DataBackendException("Multiple permissions named '" + permission.getName() + "' exist!");
        }
        return results.size() == 1;
    }

    public static PermissionSet retrieveSet(Criteria criteria) throws Exception {
        List results = PermissionPeerManager.doSelect(criteria);
        PermissionSet ps = new PermissionSet();
        Iterator it = results.iterator();
        while (it.hasNext()) {
            ps.add((Permission)it.next());
        }
        return ps;
    }

    public static PermissionSet retrieveSet(Role role) throws Exception {
        Criteria criteria = new Criteria();
        criteria.add(TurbineRolePermissionPeer.ROLE_ID, (Object)((Persistent)role).getPrimaryKey());
        criteria.addJoin(TurbineRolePermissionPeer.PERMISSION_ID, PermissionPeerManager.getIdColumn());
        return PermissionPeerManager.retrieveSet(criteria);
    }

    public static final Vector getDifference(Vector some, Vector all) {
        Vector clone = (Vector)all.clone();
        Enumeration e = some.elements();
        block0: while (e.hasMoreElements()) {
            Permission tmp = (Permission)e.nextElement();
            Enumeration f = clone.elements();
            while (f.hasMoreElements()) {
                Permission tmp2 = (Permission)f.nextElement();
                if (((Persistent)tmp).getPrimaryKey() != ((Persistent)tmp2).getPrimaryKey()) continue;
                clone.removeElement(tmp2);
                continue block0;
            }
        }
        return clone;
    }

    public static Criteria buildCriteria(Permission permission) {
        Criteria crit;
        try {
            Class[] clazz = new Class[]{permissionObject};
            Object[] params = new Object[]{((TorquePermission)permission).getPersistentObj()};
            crit = (Criteria)persistentPeerClass.getMethod("buildCriteria", clazz).invoke(null, params);
        }
        catch (Exception e) {
            crit = null;
        }
        return crit;
    }

    public static void doUpdate(Criteria criteria) throws TorqueException {
        try {
            Class[] clazz = new Class[]{Criteria.class};
            Object[] params = new Object[]{criteria};
            persistentPeerClass.getMethod("doUpdate", clazz).invoke(null, params);
        }
        catch (Exception e) {
            throw new TorqueException("doUpdate failed", (Throwable)e);
        }
    }

    public static void doInsert(Criteria criteria) throws TorqueException {
        try {
            Class[] clazz = new Class[]{Criteria.class};
            Object[] params = new Object[]{criteria};
            persistentPeerClass.getMethod("doInsert", clazz).invoke(null, params);
        }
        catch (Exception e) {
            throw new TorqueException("doInsert failed", (Throwable)e);
        }
    }

    public static List doSelect(Criteria criteria) throws TorqueException {
        List list;
        try {
            Class[] clazz = new Class[]{Criteria.class};
            Object[] params = new Object[]{criteria};
            list = (List)persistentPeerClass.getMethod("doSelect", clazz).invoke(null, params);
        }
        catch (Exception e) {
            throw new TorqueException("doSelect failed", (Throwable)e);
        }
        ArrayList<Permission> newList = new ArrayList<Permission>(list.size());
        Iterator it = list.iterator();
        while (it.hasNext()) {
            Permission p = PermissionPeerManager.getNewPermission((Persistent)it.next());
            newList.add(p);
        }
        return newList;
    }

    public static void doDelete(Criteria criteria) throws TorqueException {
        try {
            Class[] clazz = new Class[]{Criteria.class};
            Object[] params = new Object[]{criteria};
            persistentPeerClass.getMethod("doDelete", clazz).invoke(null, params);
        }
        catch (Exception e) {
            throw new TorqueException("doDelete failed", (Throwable)e);
        }
    }

    public static void setPermissionName(Persistent obj, String name) {
        if (obj == null) {
            return;
        }
        try {
            Object[] params = new Object[]{name};
            namePropDesc.getWriteMethod().invoke((Object)obj, params);
        }
        catch (ClassCastException cce) {
            String msg = obj.getClass().getName() + " does not seem to be a Permission Object!";
            log.error((Object)msg);
            throw new RuntimeException(msg);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    public static String getPermissionName(Persistent obj) {
        String name = null;
        if (obj == null) {
            return null;
        }
        try {
            name = (String)namePropDesc.getReadMethod().invoke((Object)obj, new Object[0]);
        }
        catch (ClassCastException cce) {
            String msg = obj.getClass().getName() + " does not seem to be a Permission Object!";
            log.error((Object)msg);
            throw new RuntimeException(msg);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        return name;
    }

    public static void setId(Persistent obj, int id) {
        if (obj == null) {
            return;
        }
        try {
            Object[] params = new Object[]{Integer.TYPE};
            idPropDesc.getWriteMethod().invoke((Object)obj, params);
        }
        catch (ClassCastException cce) {
            String msg = obj.getClass().getName() + " does not seem to be a Permission Object!";
            log.error((Object)msg);
            throw new RuntimeException(msg);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    public static Integer getIdAsObj(Persistent obj) {
        Integer id = null;
        if (obj == null) {
            return new Integer(0);
        }
        try {
            id = (Integer)idPropDesc.getReadMethod().invoke((Object)obj, new Object[0]);
        }
        catch (ClassCastException cce) {
            String msg = obj.getClass().getName() + " does not seem to be a Permission Object!";
            log.error((Object)msg);
            throw new RuntimeException(msg);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        return id;
    }

    private static Class getPersistenceClass() {
        Class persistenceClass = null;
        try {
            Object[] params = new Object[]{};
            persistenceClass = (Class)persistentPeerClass.getMethod("getOMClass", null).invoke(null, params);
        }
        catch (Exception e) {
            persistenceClass = null;
        }
        return persistenceClass;
    }

    public static Permission getNewPermission(Persistent p) {
        Permission perm = null;
        try {
            Class permissionWrapperClass = TurbineSecurity.getPermissionClass();
            Class[] clazz = new Class[]{Persistent.class};
            Object[] params = new Object[]{p};
            perm = (Permission)permissionWrapperClass.getConstructor(clazz).newInstance(params);
        }
        catch (Exception e) {
            log.error((Object)"Could not instantiate a new permission from supplied persistent: ", (Throwable)e);
        }
        return perm;
    }
}

