/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.betwixt.schema;

import java.beans.IntrospectionException;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.betwixt.ElementDescriptor;
import org.apache.commons.betwixt.schema.ComplexType;
import org.apache.commons.betwixt.schema.Schema;
import org.apache.commons.betwixt.schema.TranscriptionConfiguration;

public class GlobalComplexType
extends ComplexType {
    private String name;

    public GlobalComplexType() {
    }

    public GlobalComplexType(TranscriptionConfiguration configuration, ElementDescriptor elementDescriptor, Schema schema) throws IntrospectionException {
        super(configuration, elementDescriptor, schema);
    }

    protected void init(TranscriptionConfiguration configuration, ElementDescriptor elementDescriptor, Schema schema) throws IntrospectionException {
        this.setName(this.nameFromDescriptor(elementDescriptor));
    }

    protected void fill(TranscriptionConfiguration configuration, ElementDescriptor elementDescriptor, Schema schema) throws IntrospectionException {
        elementDescriptor = this.fillDescriptor(elementDescriptor, schema);
        super.init(configuration, elementDescriptor, schema);
    }

    private String nameFromDescriptor(ElementDescriptor elementDescriptor) {
        return elementDescriptor.getPropertyType().getName();
    }

    public boolean matches(ElementDescriptor elementDescriptor) {
        String nameFromDescriptor = this.nameFromDescriptor(elementDescriptor);
        return nameFromDescriptor.equals(this.getName());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof GlobalComplexType) {
            GlobalComplexType complexType = (GlobalComplexType)obj;
            result = this.isEqual(this.name, complexType.name) && this.equalContents(this.attributes, complexType.attributes) && this.equalContents(this.elements, complexType.elements);
        }
        return result;
    }

    public int hashCode() {
        return 0;
    }

    private boolean equalContents(Collection one, Collection two) {
        if (one.size() != two.size()) {
            return false;
        }
        Iterator it = one.iterator();
        while (it.hasNext()) {
            Object object = it.next();
            if (two.contains(object)) continue;
            return false;
        }
        return true;
    }

    private boolean isEqual(String one, String two) {
        boolean result = false;
        result = one == null ? two == null : one.equals(two);
        return result;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<xsd:complexType name='");
        buffer.append(this.name);
        buffer.append("'>");
        buffer.append("<xsd:sequence>");
        Iterator it = this.elements.iterator();
        while (it.hasNext()) {
            buffer.append(it.next());
        }
        buffer.append("</xsd:sequence>");
        Iterator it2 = this.attributes.iterator();
        while (it2.hasNext()) {
            buffer.append(it2.next());
        }
        buffer.append("</xsd:complexType>");
        return buffer.toString();
    }
}

