/*
 * Decompiled with CFR 0.152.
 */
package test.ojb.odmg;

import java.util.Iterator;
import junit.framework.Assert;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import ojb.broker.PersistenceBroker;
import ojb.broker.PersistenceBrokerException;
import ojb.odmg.DatabaseImpl;
import ojb.odmg.OJB;
import org.odmg.DList;
import org.odmg.DMap;
import org.odmg.Database;
import org.odmg.Transaction;
import test.ojb.odmg.Article;

public class DMapTest
extends TestCase {
    private static Class CLASS = class$test$ojb$odmg$DMapTest == null ? (class$test$ojb$odmg$DMapTest = DMapTest.class$("test.ojb.odmg.DMapTest")) : class$test$ojb$odmg$DMapTest;
    private String databaseName;
    static /* synthetic */ Class class$test$ojb$odmg$DMapTest;
    static /* synthetic */ Class class$test$ojb$odmg$Article;
    static /* synthetic */ Class class$ojb$odmg$collections$DMapImpl;

    public static void main(String[] args) {
        String[] arr = new String[]{CLASS.getName()};
        TestRunner.main((String[])arr);
    }

    public DMapTest(String name) {
        super(name);
    }

    protected Article createArticle() {
        Article a = new Article();
        PersistenceBroker broker = ((DatabaseImpl)OJB.getInstance().getDatabase(null)).getBroker();
        try {
            a.setArticleId(broker.getUniqueId(class$test$ojb$odmg$Article == null ? (class$test$ojb$odmg$Article = DMapTest.class$("test.ojb.odmg.Article")) : class$test$ojb$odmg$Article, "articleId"));
        }
        catch (PersistenceBrokerException persistenceBrokerException) {
            // empty catch block
        }
        a.setArticleName("New Funny Article " + a.getArticleId());
        a.setStock(234);
        return a;
    }

    protected void printDList(DList list) {
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Article a = (Article)iter.next();
            System.out.print(a.getArticleId() + ", ");
        }
        System.out.println();
    }

    public void setUp() {
        this.databaseName = "repository.xml";
    }

    public void tearDown() {
        try {
            OJB.getInstance().currentTransaction().abort();
            OJB.getInstance().getDatabase(null).close();
            this.databaseName = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void testAdding() {
        try {
            OJB odmg = OJB.getInstance();
            Database db = odmg.newDatabase();
            db.open(this.databaseName, 2);
            Transaction tx = odmg.newTransaction();
            tx.begin();
            DMap map = odmg.newDMap();
            PersistenceBroker broker = ((DatabaseImpl)OJB.getInstance().getDatabase(null)).getBroker();
            String name = null;
            try {
                name = "the_dmap_" + (broker.getUniqueId(class$ojb$odmg$collections$DMapImpl == null ? (class$ojb$odmg$collections$DMapImpl = DMapTest.class$("ojb.odmg.collections.DMapImpl")) : class$ojb$odmg$collections$DMapImpl, "id") - 1);
            }
            catch (PersistenceBrokerException e) {
                // empty catch block
            }
            db.bind(map, name);
            Article key1 = this.createArticle();
            Article val1 = this.createArticle();
            Article key2 = this.createArticle();
            Article val2 = this.createArticle();
            map.put(key1, val1);
            map.put(key2, val2);
            tx.commit();
            tx = odmg.newTransaction();
            tx.begin();
            DMap mapA = (DMap)db.lookup(name);
            Article val1A = (Article)mapA.get(key1);
            Assert.assertEquals((int)val1.getArticleId(), (int)val1A.getArticleId());
            Article val2A = (Article)mapA.get(key2);
            Assert.assertEquals((int)val2.getArticleId(), (int)val2A.getArticleId());
            tx.commit();
        }
        catch (Throwable ex) {
            Assert.fail((String)ex.getMessage());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

