/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.jce.crypto.extended;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.fulcrum.jce.crypto.PasswordFactory;
import org.apache.fulcrum.jce.crypto.StreamUtil;
import org.apache.fulcrum.jce.crypto.algo.CryptoStreamGCMImpl;
import org.apache.fulcrum.jce.crypto.algo.CryptoStreamPBEImpl;
import org.apache.fulcrum.jce.crypto.extended.CryptoParametersJ8;
import org.apache.fulcrum.jce.crypto.extended.CryptoStreamFactoryJ8;

public abstract class CryptoStreamFactoryJ8Template
implements CryptoStreamFactoryJ8 {
    protected byte[] salt;
    protected int count;
    protected String providerName;
    protected String algorithm;
    private CryptoParametersJ8.TYPES type;
    protected static final String PROVIDERNAME = null;
    protected static final int SALT_SIZE = 16;
    protected static final Map<CryptoParametersJ8.TYPES, CryptoStreamFactoryJ8Template> instances = new ConcurrentHashMap<CryptoParametersJ8.TYPES, CryptoStreamFactoryJ8Template>();

    public CryptoParametersJ8.TYPES getType() {
        return this.type;
    }

    public void setType(CryptoParametersJ8.TYPES type) {
        this.type = type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CryptoStreamFactoryJ8 getInstance() {
        Class<CryptoStreamFactoryJ8Template> clazz = CryptoStreamFactoryJ8Template.class;
        synchronized (CryptoStreamFactoryJ8Template.class) {
            if (!instances.containsKey((Object)CryptoParametersJ8.DEFAULT_TYPE)) {
                try {
                    instances.put(CryptoParametersJ8.DEFAULT_TYPE, CryptoParametersJ8.DEFAULT_TYPE.equals((Object)CryptoParametersJ8.TYPES.PBE) ? new CryptoStreamPBEImpl() : new CryptoStreamGCMImpl());
                }
                catch (GeneralSecurityException e) {
                    e.printStackTrace();
                    throw new RuntimeException(e.getMessage());
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instances.get((Object)CryptoParametersJ8.DEFAULT_TYPE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CryptoStreamFactoryJ8 getInstance(CryptoParametersJ8.TYPES type) {
        Class<CryptoStreamFactoryJ8Template> clazz = CryptoStreamFactoryJ8Template.class;
        synchronized (CryptoStreamFactoryJ8Template.class) {
            if (!instances.containsKey((Object)type)) {
                try {
                    instances.put(type, type.equals((Object)CryptoParametersJ8.TYPES.PBE) ? new CryptoStreamPBEImpl() : new CryptoStreamGCMImpl());
                }
                catch (GeneralSecurityException e) {
                    e.printStackTrace();
                    throw new RuntimeException(e.getMessage());
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instances.get((Object)type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CryptoStreamFactoryJ8 getInstance(CryptoParametersJ8.TYPES type, byte[] salt, int count) {
        Class<CryptoStreamFactoryJ8Template> clazz = CryptoStreamFactoryJ8Template.class;
        synchronized (CryptoStreamFactoryJ8Template.class) {
            if (!instances.containsKey((Object)type)) {
                try {
                    instances.put(type, type.equals((Object)CryptoParametersJ8.TYPES.PBE) ? new CryptoStreamPBEImpl(salt, count) : new CryptoStreamGCMImpl(salt));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new RuntimeException(e.getMessage());
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return instances.get((Object)type);
        }
    }

    @Override
    public InputStream getSmartInputStream(InputStream is) throws GeneralSecurityException, IOException {
        return this.getSmartInputStream(is, PasswordFactory.getInstance("SHA-256").create());
    }

    @Override
    public InputStream getInputStream(InputStream is, char[] password) throws GeneralSecurityException, IOException {
        byte[] decrypted = this.createCipher(is, 2, (char[])password.clone());
        ByteArrayInputStream eis = new ByteArrayInputStream(decrypted);
        return eis;
    }

    @Override
    public OutputStream getOutputStream(InputStream is, OutputStream os, char[] password) throws GeneralSecurityException, IOException {
        byte[] encrypted = this.createCipher(is, 1, (char[])password.clone());
        ByteArrayInputStream eis = new ByteArrayInputStream(encrypted);
        StreamUtil.copy(eis, os);
        return os;
    }

    public static void resetInstances() {
        instances.clear();
    }

    @Override
    public InputStream getInputStream(InputStream is, String decryptionMode) throws GeneralSecurityException, IOException {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public InputStream getInputStream(InputStream is, String decryptionMode, char[] password) throws GeneralSecurityException, IOException {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public InputStream getInputStream(InputStream is) throws GeneralSecurityException, IOException {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public InputStream getSmartInputStream(InputStream is, char[] password) throws GeneralSecurityException, IOException {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public OutputStream getOutputStream(OutputStream os) throws GeneralSecurityException, IOException {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public OutputStream getOutputStream(OutputStream os, char[] password) throws GeneralSecurityException, IOException {
        throw new UnsupportedOperationException("not implemented");
    }

    protected abstract Key createKey(char[] var1, byte[] var2) throws GeneralSecurityException;

    protected abstract byte[] createCipher(InputStream var1, int var2, char[] var3) throws GeneralSecurityException, IOException;

    protected static byte[] generateSalt() throws GeneralSecurityException {
        try {
            SecureRandom random = SecureRandom.getInstanceStrong();
            byte[] salt = new byte[16];
            random.nextBytes(salt);
            return salt;
        }
        catch (NoSuchAlgorithmException e) {
            throw new GeneralSecurityException(e);
        }
    }

    public byte[] getSalt() {
        return (byte[])this.salt.clone();
    }

    protected void setSalt(byte[] salt) {
        this.salt = (byte[])salt.clone();
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public void setProviderName(String providerName) {
        this.providerName = providerName;
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }
}

