/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.torque.om;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fulcrum.security.torque.om.BaseTurbineRolePeer;
import org.apache.fulcrum.security.torque.om.TurbineRole;
import org.apache.torque.Column;
import org.apache.torque.TorqueException;
import org.apache.torque.criteria.Criteria;
import org.apache.torque.om.mapper.MappingStrategy;
import org.apache.torque.om.mapper.RecordMapper;
import org.apache.torque.util.UniqueColumnList;

public class BaseTurbineRoleRecordMapper
implements RecordMapper<TurbineRole> {
    private static final long serialVersionUID = 1735909173292L;
    private static Log log = LogFactory.getLog(BaseTurbineRoleRecordMapper.class);
    private static final String ROLE_ID_EXPRESSION = BaseTurbineRolePeer.ROLE_ID.getSqlExpression();
    private static final String ROLE_NAME_EXPRESSION = BaseTurbineRolePeer.ROLE_NAME.getSqlExpression();
    private boolean useMappingStrategy = true;
    private MappingStrategy<TurbineRole> strategy;

    public void initStrategy() {
        this.strategy = new MappingStrategy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TurbineRole processRow(ResultSet resultSet, int offset, Criteria criteria) throws TorqueException {
        TurbineRole turbineRole = new TurbineRole();
        try {
            turbineRole.setLoading(true);
            if (criteria == null) {
                turbineRole.setEntityId(this.getEntityId(resultSet, offset + 1));
                turbineRole.setEntityName(this.getEntityName(resultSet, offset + 2));
            } else {
                if (this.useMappingStrategy) {
                    this.initStrategy();
                }
                int totalOffset = offset + 1;
                UniqueColumnList selectColumns = criteria.getSelectColumns();
                List columnsWithoutOffset = selectColumns.subList(offset, selectColumns.size());
                HashSet<String> columnsMapped = new HashSet<String>();
                for (Column column : columnsWithoutOffset) {
                    int nextOffset = totalOffset;
                    if (!columnsMapped.contains(ROLE_ID_EXPRESSION) && ROLE_ID_EXPRESSION.equals(column.getSqlExpression())) {
                        if (this.useMappingStrategy) {
                            this.strategy.addColumn(nextOffset, (res, inst) -> inst.setEntityId(this.getEntityId((ResultSet)res, nextOffset)));
                        } else {
                            turbineRole.setEntityId(this.getEntityId(resultSet, totalOffset));
                        }
                        columnsMapped.add(ROLE_ID_EXPRESSION);
                    } else if (!columnsMapped.contains(ROLE_NAME_EXPRESSION) && ROLE_NAME_EXPRESSION.equals(column.getSqlExpression())) {
                        if (this.useMappingStrategy) {
                            this.strategy.addColumn(nextOffset, (res, inst) -> inst.setEntityName(this.getEntityName((ResultSet)res, nextOffset)));
                        } else {
                            turbineRole.setEntityName(this.getEntityName(resultSet, totalOffset));
                        }
                        columnsMapped.add(ROLE_NAME_EXPRESSION);
                    }
                    ++totalOffset;
                }
                if (columnsMapped.isEmpty()) {
                    log.debug((Object)"no columns to map found in criteria, returning null");
                    Iterator iterator = null;
                    return iterator;
                }
                if (this.useMappingStrategy) {
                    this.strategy.finish(2, true);
                    this.strategy.execute(resultSet, (Object)turbineRole);
                }
            }
            turbineRole.setNew(false);
            turbineRole.setModified(false);
        }
        finally {
            turbineRole.setLoading(false);
        }
        return turbineRole;
    }

    protected Integer getEntityId(ResultSet resultSet, int columnIndex) throws TorqueException {
        try {
            Integer value = resultSet.getInt(columnIndex);
            if (resultSet.wasNull()) {
                value = null;
            }
            return value;
        }
        catch (SQLException e) {
            throw new TorqueException((Throwable)e);
        }
    }

    protected String getEntityName(ResultSet resultSet, int columnIndex) throws TorqueException {
        try {
            return resultSet.getString(columnIndex);
        }
        catch (SQLException e) {
            throw new TorqueException((Throwable)e);
        }
    }
}

