/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.torque.om;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fulcrum.security.torque.om.BaseTorqueBasicUserGroupPeer;
import org.apache.fulcrum.security.torque.om.TorqueBasicUserGroup;
import org.apache.torque.Column;
import org.apache.torque.TorqueException;
import org.apache.torque.criteria.Criteria;
import org.apache.torque.om.mapper.MappingStrategy;
import org.apache.torque.om.mapper.RecordMapper;
import org.apache.torque.util.UniqueColumnList;

public class BaseTorqueBasicUserGroupRecordMapper
implements RecordMapper<TorqueBasicUserGroup> {
    private static final long serialVersionUID = 1735909173149L;
    private static Log log = LogFactory.getLog(BaseTorqueBasicUserGroupRecordMapper.class);
    private static final String USER_ID_EXPRESSION = BaseTorqueBasicUserGroupPeer.USER_ID.getSqlExpression();
    private static final String GROUP_ID_EXPRESSION = BaseTorqueBasicUserGroupPeer.GROUP_ID.getSqlExpression();
    private boolean useMappingStrategy = true;
    private MappingStrategy<TorqueBasicUserGroup> strategy;

    public void initStrategy() {
        this.strategy = new MappingStrategy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TorqueBasicUserGroup processRow(ResultSet resultSet, int offset, Criteria criteria) throws TorqueException {
        TorqueBasicUserGroup torqueBasicUserGroup = new TorqueBasicUserGroup();
        try {
            torqueBasicUserGroup.setLoading(true);
            if (criteria == null) {
                torqueBasicUserGroup.setUserId(this.getUserId(resultSet, offset + 1));
                torqueBasicUserGroup.setGroupId(this.getGroupId(resultSet, offset + 2));
            } else {
                if (this.useMappingStrategy) {
                    this.initStrategy();
                }
                int totalOffset = offset + 1;
                UniqueColumnList selectColumns = criteria.getSelectColumns();
                List columnsWithoutOffset = selectColumns.subList(offset, selectColumns.size());
                HashSet<String> columnsMapped = new HashSet<String>();
                for (Column column : columnsWithoutOffset) {
                    int nextOffset = totalOffset;
                    if (!columnsMapped.contains(USER_ID_EXPRESSION) && USER_ID_EXPRESSION.equals(column.getSqlExpression())) {
                        if (this.useMappingStrategy) {
                            this.strategy.addColumn(nextOffset, (res, inst) -> inst.setUserId(this.getUserId((ResultSet)res, nextOffset)));
                        } else {
                            torqueBasicUserGroup.setUserId(this.getUserId(resultSet, totalOffset));
                        }
                        columnsMapped.add(USER_ID_EXPRESSION);
                    } else if (!columnsMapped.contains(GROUP_ID_EXPRESSION) && GROUP_ID_EXPRESSION.equals(column.getSqlExpression())) {
                        if (this.useMappingStrategy) {
                            this.strategy.addColumn(nextOffset, (res, inst) -> inst.setGroupId(this.getGroupId((ResultSet)res, nextOffset)));
                        } else {
                            torqueBasicUserGroup.setGroupId(this.getGroupId(resultSet, totalOffset));
                        }
                        columnsMapped.add(GROUP_ID_EXPRESSION);
                    }
                    ++totalOffset;
                }
                if (columnsMapped.isEmpty()) {
                    log.debug((Object)"no columns to map found in criteria, returning null");
                    Iterator iterator = null;
                    return iterator;
                }
                if (this.useMappingStrategy) {
                    this.strategy.finish(2, true);
                    this.strategy.execute(resultSet, (Object)torqueBasicUserGroup);
                }
            }
            torqueBasicUserGroup.setNew(false);
            torqueBasicUserGroup.setModified(false);
        }
        finally {
            torqueBasicUserGroup.setLoading(false);
        }
        return torqueBasicUserGroup;
    }

    protected Integer getUserId(ResultSet resultSet, int columnIndex) throws TorqueException {
        try {
            Integer value = resultSet.getInt(columnIndex);
            if (resultSet.wasNull()) {
                value = null;
            }
            return value;
        }
        catch (SQLException e) {
            throw new TorqueException((Throwable)e);
        }
    }

    protected Integer getGroupId(ResultSet resultSet, int columnIndex) throws TorqueException {
        try {
            Integer value = resultSet.getInt(columnIndex);
            if (resultSet.wasNull()) {
                value = null;
            }
            return value;
        }
        catch (SQLException e) {
            throw new TorqueException((Throwable)e);
        }
    }
}

