/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.impl;

import java.util.Timer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import org.apache.hc.client5.http.classic.HttpClient;
import org.opensaml.saml.metadata.resolver.RemoteMetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.AbstractDynamicHTTPMetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.HTTPEntityIDRequestURLBuilder;
import org.opensaml.saml.metadata.resolver.impl.MetadataQueryProtocolRequestURLBuilder;
import org.slf4j.Logger;

public class FunctionDrivenDynamicHTTPMetadataResolver
extends AbstractDynamicHTTPMetadataResolver
implements RemoteMetadataResolver {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(FunctionDrivenDynamicHTTPMetadataResolver.class);
    @Nonnull
    private Function<CriteriaSet, String> requestURLBuilder = new HTTPEntityIDRequestURLBuilder();

    public FunctionDrivenDynamicHTTPMetadataResolver(@Nonnull HttpClient client) {
        this(null, client);
    }

    public FunctionDrivenDynamicHTTPMetadataResolver(@Nullable Timer backgroundTaskTimer, @Nonnull HttpClient client) {
        super(backgroundTaskTimer, client);
    }

    @Nonnull
    public Function<CriteriaSet, String> getRequestURLBuilder() {
        return this.requestURLBuilder;
    }

    public void setRequestURLBuilder(@Nonnull Function<CriteriaSet, String> builder) {
        this.checkSetterPreconditions();
        this.requestURLBuilder = (Function)Constraint.isNotNull(builder, (String)"Request URL builder function cannot be null");
    }

    @Override
    @Nullable
    protected String buildRequestURL(@Nullable CriteriaSet criteria) {
        String url = this.getRequestURLBuilder().apply(criteria);
        this.log.debug("{} URL generated by request builder was: {}", (Object)this.getLogPrefix(), (Object)url);
        return url;
    }

    @Nullable
    public String getMetadataURI() {
        Function<CriteriaSet, String> function = this.requestURLBuilder;
        if (function instanceof MetadataQueryProtocolRequestURLBuilder) {
            MetadataQueryProtocolRequestURLBuilder mdq = (MetadataQueryProtocolRequestURLBuilder)function;
            return mdq.getBaseURL();
        }
        return null;
    }
}

