/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.timer;

import jakarta.ejb.ScheduleExpression;
import jakarta.ejb.TimerConfig;
import jakarta.transaction.RollbackException;
import jakarta.transaction.Synchronization;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.openejb.core.timer.CalendarTimerData;
import org.apache.openejb.core.timer.EjbTimerServiceImpl;
import org.apache.openejb.core.timer.IntervalTimerData;
import org.apache.openejb.core.timer.SingleActionTimerData;
import org.apache.openejb.core.timer.TimerData;
import org.apache.openejb.core.timer.TimerStore;
import org.apache.openejb.core.timer.TimerStoreException;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public class MemoryTimerStore
implements TimerStore {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getInstance(LogCategory.TIMER, "org.apache.openejb.util.resources");
    private final Map<Long, TimerData> taskStore = new ConcurrentHashMap<Long, TimerData>();
    private final Map<Transaction, TimerDataView> tasksByTransaction = new ConcurrentHashMap<Transaction, TimerDataView>();
    private final AtomicLong counter = new AtomicLong(0L);
    private final TransactionManager transactionManager;

    public MemoryTimerStore(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    @Override
    public TimerData getTimer(String deploymentId, long timerId) {
        try {
            TimerDataView tasks = this.getTasks();
            return tasks.getTasks().get(timerId);
        }
        catch (TimerStoreException e) {
            return null;
        }
    }

    @Override
    public Collection<TimerData> getTimers(String deploymentId) {
        try {
            TimerDataView tasks = this.getTasks();
            return new ArrayList<TimerData>(tasks.getTasks().values());
        }
        catch (TimerStoreException e) {
            return Collections.emptySet();
        }
    }

    @Override
    public Collection<TimerData> loadTimers(EjbTimerServiceImpl timerService, String deploymentId) throws TimerStoreException {
        TimerDataView tasks = this.getTasks();
        LinkedList<TimerData> out = new LinkedList<TimerData>();
        for (TimerData data : tasks.getTasks().values()) {
            if (deploymentId != null && !deploymentId.equals(data.getDeploymentId())) continue;
            out.add(data);
        }
        return out;
    }

    @Override
    public void addTimerData(TimerData timerData) throws TimerStoreException {
        this.getTasks().addTimerData(timerData);
    }

    @Override
    public TimerData createCalendarTimer(EjbTimerServiceImpl timerService, String deploymentId, Object primaryKey, Method timeoutMethod, ScheduleExpression scheduleExpression, TimerConfig timerConfig, boolean auto) throws TimerStoreException {
        long id = this.counter.incrementAndGet();
        CalendarTimerData timerData = new CalendarTimerData(id, timerService, deploymentId, primaryKey, timeoutMethod, timerConfig, scheduleExpression, auto);
        this.getTasks().addTimerData(timerData);
        return timerData;
    }

    @Override
    public TimerData createIntervalTimer(EjbTimerServiceImpl timerService, String deploymentId, Object primaryKey, Method timeoutMethod, Date initialExpiration, long intervalDuration, TimerConfig timerConfig) throws TimerStoreException {
        long id = this.counter.incrementAndGet();
        IntervalTimerData timerData = new IntervalTimerData(id, timerService, deploymentId, primaryKey, timeoutMethod, timerConfig, initialExpiration, intervalDuration);
        this.getTasks().addTimerData(timerData);
        return timerData;
    }

    @Override
    public TimerData createSingleActionTimer(EjbTimerServiceImpl timerService, String deploymentId, Object primaryKey, Method timeoutMethod, Date expiration, TimerConfig timerConfig) throws TimerStoreException {
        long id = this.counter.incrementAndGet();
        SingleActionTimerData timerData = new SingleActionTimerData(id, timerService, deploymentId, primaryKey, timeoutMethod, timerConfig, expiration);
        this.getTasks().addTimerData(timerData);
        return timerData;
    }

    @Override
    public void removeTimer(long id) {
        try {
            this.getTasks().removeTimerData(id);
        }
        catch (TimerStoreException e) {
            log.warning("Unable to remove timer data from memory store", e);
        }
    }

    @Override
    public void updateIntervalTimer(TimerData timerData) {
    }

    private TimerDataView getTasks() throws TimerStoreException {
        Transaction transaction = null;
        int status = 6;
        try {
            transaction = this.transactionManager.getTransaction();
            if (transaction != null) {
                status = transaction.getStatus();
            }
        }
        catch (SystemException systemException) {
            // empty catch block
        }
        if (status != 0 && status != 1) {
            return new LiveTimerDataView();
        }
        TxTimerDataView tasks = (TxTimerDataView)this.tasksByTransaction.get(transaction);
        if (tasks == null) {
            tasks = new TxTimerDataView(transaction);
            this.tasksByTransaction.put(transaction, tasks);
        }
        return tasks;
    }

    private static interface TimerDataView {
        public Map<Long, TimerData> getTasks();

        public void addTimerData(TimerData var1);

        public void removeTimerData(Long var1);
    }

    private class LiveTimerDataView
    implements TimerDataView {
        private LiveTimerDataView() {
        }

        @Override
        public Map<Long, TimerData> getTasks() {
            return new TreeMap<Long, TimerData>(MemoryTimerStore.this.taskStore);
        }

        @Override
        public void addTimerData(TimerData timerData) {
            MemoryTimerStore.this.taskStore.put(timerData.getId(), timerData);
        }

        @Override
        public void removeTimerData(Long timerId) {
            MemoryTimerStore.this.taskStore.remove(timerId);
        }
    }

    private class TxTimerDataView
    implements Synchronization,
    TimerDataView {
        private final Map<Long, TimerData> add = new TreeMap<Long, TimerData>();
        private final Set<Long> remove = new TreeSet<Long>();
        private final Lock lock = new ReentrantLock();
        private final RuntimeException concurentException;
        private final WeakReference<Transaction> tansactionReference;

        public TxTimerDataView(Transaction transaction) throws TimerStoreException {
            this.lock.lock();
            this.concurentException = new IllegalThreadStateException("Object can only be invoked by Thread[" + Thread.currentThread().getName() + "] in Transaction[" + transaction + "]");
            this.concurentException.fillInStackTrace();
            try {
                transaction.registerSynchronization((Synchronization)this);
                this.tansactionReference = new WeakReference<Transaction>(transaction);
            }
            catch (RollbackException e) {
                throw new TimerStoreException("Transaction has been rolled back");
            }
            catch (SystemException e) {
                throw new TimerStoreException("Error registering transaction synchronization callback");
            }
        }

        private void checkThread() {
            if (!this.lock.tryLock()) {
                throw new IllegalStateException("Illegal access by Thread[" + Thread.currentThread().getName() + "]", this.concurentException);
            }
        }

        @Override
        public Map<Long, TimerData> getTasks() {
            this.checkThread();
            TreeMap<Long, TimerData> allTasks = new TreeMap<Long, TimerData>(MemoryTimerStore.this.taskStore);
            for (Long key : this.remove) {
                allTasks.remove(key);
            }
            allTasks.putAll(this.add);
            return Collections.unmodifiableMap(allTasks);
        }

        @Override
        public void addTimerData(TimerData timerData) {
            this.checkThread();
            Long timerId = timerData.getId();
            this.remove.remove(timerId);
            this.add.put(timerId, timerData);
        }

        @Override
        public void removeTimerData(Long timerId) {
            this.checkThread();
            this.add.remove(timerId);
            this.remove.add(timerId);
        }

        public void beforeCompletion() {
            this.checkThread();
        }

        public void afterCompletion(int status) {
            this.checkThread();
            if (status != 3) {
                return;
            }
            MemoryTimerStore.this.taskStore.putAll(this.add);
            MemoryTimerStore.this.taskStore.keySet().removeAll(this.remove);
            MemoryTimerStore.this.tasksByTransaction.remove(this.tansactionReference.get());
        }
    }
}

