/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.eis;

import jakarta.resource.cci.ConnectionFactory;
import jakarta.resource.cci.ConnectionSpec;
import org.eclipse.persistence.eis.EISAccessor;
import org.eclipse.persistence.eis.EISConnectionSpec;
import org.eclipse.persistence.eis.EISPlatform;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.databaseaccess.Platform;
import org.eclipse.persistence.sessions.DatasourceLogin;
import org.eclipse.persistence.sessions.Session;

public class EISLogin
extends DatasourceLogin {
    public EISLogin() {
        this(new EISPlatform());
    }

    public EISLogin(Platform platform) {
        super(platform);
        this.connector = new EISConnectionSpec();
    }

    @Override
    public Accessor buildAccessor() {
        return new EISAccessor();
    }

    @Override
    public Object connectToDatasource(Accessor accessor, Session session) {
        return this.getConnectionSpec().connectToDataSource((EISAccessor)accessor, this.getProperties());
    }

    @Override
    public void setPassword(String password) {
        if (password != null) {
            this.setProperty("password", password.toCharArray());
        } else {
            this.removeProperty("password");
        }
    }

    public String getConnectionFactoryURL() {
        if (this.getConnectionSpec().getName() == null || this.getConnectionSpec().getName().size() == 0) {
            return null;
        }
        return this.getConnectionSpec().getName().get(0);
    }

    public void setConnectionFactoryURL(String url) {
        if (url == null || url.length() == 0) {
            return;
        }
        this.getConnectionSpec().setName(url);
    }

    public EISConnectionSpec getConnectionSpec() {
        return (EISConnectionSpec)this.getConnector();
    }

    public void setConnectionSpec(EISConnectionSpec connectionSpec) {
        this.setConnector(connectionSpec);
    }

    public void configureConnectionSpec(String jndiName) {
        this.setConnectionSpec(new EISConnectionSpec(jndiName));
    }

    public void configureConnectionSpec(ConnectionFactory connectionFactory) {
        EISConnectionSpec spec = new EISConnectionSpec();
        spec.setConnectionFactory(connectionFactory);
        this.setConnectionSpec(spec);
    }

    public void configureConnectionSpec(String jndiName, ConnectionSpec connectionSpec) {
        EISConnectionSpec spec = new EISConnectionSpec(jndiName);
        spec.setConnectionSpec(connectionSpec);
        this.setConnectionSpec(spec);
    }

    public void configureConnectionSpec(ConnectionFactory connectionFactory, ConnectionSpec connectionSpec) {
        EISConnectionSpec spec = new EISConnectionSpec();
        spec.setConnectionFactory(connectionFactory);
        spec.setConnectionSpec(connectionSpec);
        this.setConnectionSpec(spec);
    }
}

