/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.mbeans;

import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanException;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import org.apache.catalina.mbeans.BaseCatalinaMBean;
import org.apache.tomcat.util.descriptor.web.ContextResourceLink;
import org.apache.tomcat.util.descriptor.web.NamingResources;
import org.apache.tomcat.util.res.StringManager;

public class ContextResourceLinkMBean
extends BaseCatalinaMBean<ContextResourceLink> {
    private static final StringManager sm = StringManager.getManager(ContextResourceLinkMBean.class);

    public Object getAttribute(String name) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(sm.getString("mBean.nullName")), sm.getString("mBean.nullName"));
        }
        ContextResourceLink cl = (ContextResourceLink)this.doGetManagedResource();
        switch (name) {
            case "global": {
                return cl.getGlobal();
            }
            case "description": {
                return cl.getDescription();
            }
            case "name": {
                return cl.getName();
            }
            case "type": {
                return cl.getType();
            }
        }
        String value = (String)cl.getProperty(name);
        if (value == null) {
            throw new AttributeNotFoundException(sm.getString("mBean.attributeNotFound", new Object[]{name}));
        }
        return value;
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (attribute == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(sm.getString("mBean.nullAttribute")), sm.getString("mBean.nullAttribute"));
        }
        String name = attribute.getName();
        Object value = attribute.getValue();
        if (name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(sm.getString("mBean.nullName")), sm.getString("mBean.nullName"));
        }
        ContextResourceLink crl = (ContextResourceLink)this.doGetManagedResource();
        switch (name) {
            case "global": {
                crl.setGlobal((String)value);
                break;
            }
            case "description": {
                crl.setDescription((String)value);
                break;
            }
            case "name": {
                crl.setName((String)value);
                break;
            }
            case "type": {
                crl.setType((String)value);
                break;
            }
            default: {
                crl.setProperty(name, (Object)String.valueOf(value));
            }
        }
        NamingResources nr = crl.getNamingResources();
        nr.removeResourceLink(crl.getName());
        nr.addResourceLink(crl);
    }
}

