/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.graphson;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Path;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.MutablePath;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.Tree;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.io.graphson.TypeInfo;
import org.apache.tinkerpop.gremlin.structure.util.Comparators;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedEdge;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedFactory;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedPath;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedProperty;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedVertex;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedVertexProperty;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.apache.tinkerpop.shaded.jackson.core.JsonGenerationException;
import org.apache.tinkerpop.shaded.jackson.core.JsonGenerator;
import org.apache.tinkerpop.shaded.jackson.core.JsonParser;
import org.apache.tinkerpop.shaded.jackson.core.JsonProcessingException;
import org.apache.tinkerpop.shaded.jackson.core.JsonToken;
import org.apache.tinkerpop.shaded.jackson.databind.DeserializationContext;
import org.apache.tinkerpop.shaded.jackson.databind.JavaType;
import org.apache.tinkerpop.shaded.jackson.databind.SerializerProvider;
import org.apache.tinkerpop.shaded.jackson.databind.deser.std.StdDeserializer;
import org.apache.tinkerpop.shaded.jackson.databind.jsontype.TypeSerializer;
import org.apache.tinkerpop.shaded.jackson.databind.ser.std.StdKeySerializer;
import org.apache.tinkerpop.shaded.jackson.databind.ser.std.StdScalarSerializer;
import org.apache.tinkerpop.shaded.jackson.databind.type.TypeFactory;

class GraphSONSerializersV4 {
    private GraphSONSerializersV4() {
    }

    private static void writeTypeForGraphObjectIfUntyped(JsonGenerator jsonGenerator, TypeInfo typeInfo, String type) throws IOException {
        if (typeInfo == TypeInfo.NO_TYPES) {
            jsonGenerator.writeStringField("type", type);
        }
    }

    private static void writeLabel(JsonGenerator jsonGenerator, String labelName, String labelValue) throws IOException {
        jsonGenerator.writeFieldName(labelName);
        jsonGenerator.writeStartArray();
        jsonGenerator.writeString(labelValue);
        jsonGenerator.writeEndArray();
    }

    static class DoubleJacksonDeserializer
    extends StdDeserializer<Double> {
        protected DoubleJacksonDeserializer() {
            super(Double.class);
        }

        public Double deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            if (jsonParser.getCurrentToken().isNumeric()) {
                return jsonParser.getDoubleValue();
            }
            String numberText = jsonParser.getValueAsString();
            if ("NaN".equalsIgnoreCase(numberText)) {
                return Double.NaN;
            }
            if ("-Infinity".equals(numberText) || "-INF".equalsIgnoreCase(numberText)) {
                return Double.NEGATIVE_INFINITY;
            }
            if ("Infinity".equals(numberText) || "INF".equals(numberText)) {
                return Double.POSITIVE_INFINITY;
            }
            throw new IllegalStateException("Double value unexpected: " + numberText);
        }

        public boolean isCachable() {
            return true;
        }
    }

    static class IntegerJackonsDeserializer
    extends StdDeserializer<Integer> {
        protected IntegerJackonsDeserializer() {
            super(Integer.class);
        }

        public Integer deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            return jsonParser.getIntValue();
        }

        public boolean isCachable() {
            return true;
        }
    }

    static class TreeJacksonDeserializer
    extends StdDeserializer<Tree> {
        public TreeJacksonDeserializer() {
            super(Tree.class);
        }

        public Tree deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            List data = (List)deserializationContext.readValue(jsonParser, List.class);
            Tree t = new Tree();
            for (Map entry : data) {
                t.put(entry.get("key"), entry.get("value"));
            }
            return t;
        }

        public boolean isCachable() {
            return true;
        }
    }

    static class VertexPropertyJacksonDeserializer
    extends StdDeserializer<VertexProperty> {
        private static final JavaType propertiesType = TypeFactory.defaultInstance().constructMapType(HashMap.class, String.class, Object.class);

        protected VertexPropertyJacksonDeserializer() {
            super(VertexProperty.class);
        }

        public VertexProperty deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            DetachedVertexProperty.Builder vp = DetachedVertexProperty.build();
            while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
                if (jsonParser.getCurrentName().equals("id")) {
                    jsonParser.nextToken();
                    vp.setId(deserializationContext.readValue(jsonParser, Object.class));
                    continue;
                }
                if (jsonParser.getCurrentName().equals("label")) {
                    jsonParser.nextToken();
                    while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                        vp.setLabel(jsonParser.getText());
                    }
                    continue;
                }
                if (jsonParser.getCurrentName().equals("value")) {
                    jsonParser.nextToken();
                    vp.setValue(deserializationContext.readValue(jsonParser, Object.class));
                    continue;
                }
                if (!jsonParser.getCurrentName().equals("properties")) continue;
                jsonParser.nextToken();
                while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
                    String key = jsonParser.getCurrentName();
                    jsonParser.nextToken();
                    Object val = deserializationContext.readValue(jsonParser, Object.class);
                    vp.addProperty(new DetachedProperty<Object>(key, val));
                }
            }
            return vp.create();
        }

        public boolean isCachable() {
            return true;
        }
    }

    static class PathJacksonDeserializer
    extends StdDeserializer<Path> {
        private static final JavaType setType = TypeFactory.defaultInstance().constructCollectionType(HashSet.class, String.class);

        public PathJacksonDeserializer() {
            super(Path.class);
        }

        public Path deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            Path p = MutablePath.make();
            List labels = new ArrayList();
            List objects = new ArrayList();
            while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
                if (jsonParser.getCurrentName().equals("labels")) {
                    jsonParser.nextToken();
                    labels = (List)deserializationContext.readValue(jsonParser, List.class);
                    continue;
                }
                if (!jsonParser.getCurrentName().equals("objects")) continue;
                jsonParser.nextToken();
                objects = (List)deserializationContext.readValue(jsonParser, List.class);
            }
            for (int i = 0; i < objects.size(); ++i) {
                p.extend(objects.get(i), (Set)labels.get(i));
            }
            return p;
        }

        public boolean isCachable() {
            return true;
        }
    }

    static class PropertyJacksonDeserializer
    extends StdDeserializer<Property> {
        public PropertyJacksonDeserializer() {
            super(Property.class);
        }

        public Property deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            String key = null;
            Object value = null;
            while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
                if (jsonParser.getCurrentName().equals("key")) {
                    jsonParser.nextToken();
                    key = jsonParser.getText();
                    continue;
                }
                if (!jsonParser.getCurrentName().equals("value")) continue;
                jsonParser.nextToken();
                value = deserializationContext.readValue(jsonParser, Object.class);
            }
            return new DetachedProperty<Object>(key, value);
        }

        public boolean isCachable() {
            return true;
        }
    }

    static class EdgeJacksonDeserializer
    extends StdDeserializer<Edge> {
        public EdgeJacksonDeserializer() {
            super(Edge.class);
        }

        public Edge deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            DetachedEdge.Builder e = DetachedEdge.build();
            while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
                if (jsonParser.getCurrentName().equals("id")) {
                    jsonParser.nextToken();
                    e.setId(deserializationContext.readValue(jsonParser, Object.class));
                    continue;
                }
                if (jsonParser.getCurrentName().equals("label")) {
                    jsonParser.nextToken();
                    while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                        e.setLabel(jsonParser.getText());
                    }
                    continue;
                }
                if (jsonParser.getCurrentName().equals("outV")) {
                    jsonParser.nextToken();
                    e.setOutV((DetachedVertex)deserializationContext.readValue(jsonParser, Vertex.class));
                    continue;
                }
                if (jsonParser.getCurrentName().equals("inV")) {
                    jsonParser.nextToken();
                    e.setInV((DetachedVertex)deserializationContext.readValue(jsonParser, Vertex.class));
                    continue;
                }
                if (!jsonParser.getCurrentName().equals("properties")) continue;
                jsonParser.nextToken();
                while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
                    jsonParser.nextToken();
                    while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                        e.addProperty((Property)deserializationContext.readValue(jsonParser, Property.class));
                    }
                }
            }
            return e.create();
        }

        public boolean isCachable() {
            return true;
        }
    }

    static class VertexJacksonDeserializer
    extends StdDeserializer<Vertex> {
        public VertexJacksonDeserializer() {
            super(Vertex.class);
        }

        public Vertex deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            DetachedVertex.Builder v = DetachedVertex.build();
            while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
                if (jsonParser.getCurrentName().equals("id")) {
                    jsonParser.nextToken();
                    v.setId(deserializationContext.readValue(jsonParser, Object.class));
                    continue;
                }
                if (jsonParser.getCurrentName().equals("label")) {
                    jsonParser.nextToken();
                    while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                        v.setLabel(jsonParser.getText());
                    }
                    continue;
                }
                if (!jsonParser.getCurrentName().equals("properties")) continue;
                jsonParser.nextToken();
                while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
                    jsonParser.nextToken();
                    while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                        v.addProperty((DetachedVertexProperty)deserializationContext.readValue(jsonParser, VertexProperty.class));
                    }
                }
            }
            return v.create();
        }

        public boolean isCachable() {
            return true;
        }
    }

    static final class GraphSONKeySerializer
    extends StdKeySerializer {
        GraphSONKeySerializer() {
        }

        public void serialize(Object o, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            this.ser(o, jsonGenerator, serializerProvider);
        }

        public void serializeWithType(Object o, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
            this.ser(o, jsonGenerator, serializerProvider);
        }

        private void ser(Object o, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            if (Element.class.isAssignableFrom(o.getClass())) {
                jsonGenerator.writeFieldName(((Element)o).id().toString());
            } else {
                super.serialize(o, jsonGenerator, serializerProvider);
            }
        }
    }

    static final class DoubleGraphSONSerializer
    extends StdScalarSerializer<Double> {
        public DoubleGraphSONSerializer() {
            super(Double.class);
        }

        public void serialize(Double doubleValue, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeNumber(doubleValue.doubleValue());
        }
    }

    static final class IntegerGraphSONSerializer
    extends StdScalarSerializer<Integer> {
        public IntegerGraphSONSerializer() {
            super(Integer.class);
        }

        public void serialize(Integer integer, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeNumber(integer.intValue());
        }
    }

    static final class TreeJacksonSerializer
    extends StdScalarSerializer<Tree> {
        public TreeJacksonSerializer() {
            super(Tree.class);
        }

        public void serialize(Tree tree, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
            jsonGenerator.writeStartArray();
            Set set = tree.entrySet();
            for (Map.Entry entry : set) {
                jsonGenerator.writeStartObject();
                jsonGenerator.writeObjectField("key", entry.getKey());
                jsonGenerator.writeObjectField("value", entry.getValue());
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndArray();
        }
    }

    static final class PathJacksonSerializer
    extends StdScalarSerializer<Path> {
        public PathJacksonSerializer() {
            super(Path.class);
        }

        public void serialize(Path path, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
            jsonGenerator.writeStartObject();
            DetachedPath p = DetachedFactory.detach(path, false);
            jsonGenerator.writeObjectField("labels", p.labels());
            jsonGenerator.writeObjectField("objects", p.objects());
            jsonGenerator.writeEndObject();
        }
    }

    static final class VertexPropertyJacksonSerializer
    extends StdScalarSerializer<VertexProperty> {
        private final boolean normalize;
        private final boolean includeLabel;

        public VertexPropertyJacksonSerializer(boolean normalize, boolean includeLabel) {
            super(VertexProperty.class);
            this.normalize = normalize;
            this.includeLabel = includeLabel;
        }

        public void serialize(VertexProperty property, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            VertexPropertyJacksonSerializer.writeVertexProperty(property, jsonGenerator, serializerProvider, this.normalize, this.includeLabel);
        }

        private static void writeVertexProperty(VertexProperty property, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, boolean normalize, boolean includeLabel) throws IOException {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeObjectField("id", property.id());
            jsonGenerator.writeObjectField("value", property.value());
            if (includeLabel) {
                GraphSONSerializersV4.writeLabel(jsonGenerator, "label", property.label());
            }
            VertexPropertyJacksonSerializer.tryWriteMetaProperties(property, jsonGenerator, normalize);
            jsonGenerator.writeEndObject();
        }

        private static void tryWriteMetaProperties(VertexProperty property, JsonGenerator jsonGenerator, boolean normalize) throws IOException {
            if (property instanceof DetachedVertexProperty) {
                if (property.properties(new String[0]).hasNext()) {
                    VertexPropertyJacksonSerializer.writeMetaProperties(property, jsonGenerator, normalize);
                }
            } else if (property.graph().features().vertex().supportsMetaProperties() && property.properties(new String[0]).hasNext()) {
                VertexPropertyJacksonSerializer.writeMetaProperties(property, jsonGenerator, normalize);
            }
        }

        private static void writeMetaProperties(VertexProperty property, JsonGenerator jsonGenerator, boolean normalize) throws IOException {
            Iterator metaProperties;
            jsonGenerator.writeFieldName("properties");
            jsonGenerator.writeStartObject();
            Iterator iterator = metaProperties = normalize ? IteratorUtils.list(property.properties(new String[0]), Comparators.PROPERTY_COMPARATOR).iterator() : property.properties(new String[0]);
            while (metaProperties.hasNext()) {
                Property metaProperty = metaProperties.next();
                jsonGenerator.writeObjectField(metaProperty.key(), metaProperty.value());
            }
            jsonGenerator.writeEndObject();
        }
    }

    static final class PropertyJacksonSerializer
    extends StdScalarSerializer<Property> {
        public PropertyJacksonSerializer() {
            super(Property.class);
        }

        public void serialize(Property property, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeObjectField("key", (Object)property.key());
            jsonGenerator.writeObjectField("value", property.value());
            jsonGenerator.writeEndObject();
        }
    }

    static final class EdgeJacksonSerializer
    extends StdScalarSerializer<Edge> {
        private final boolean normalize;
        private final TypeInfo typeInfo;

        public EdgeJacksonSerializer(boolean normalize, TypeInfo typeInfo) {
            super(Edge.class);
            this.normalize = normalize;
            this.typeInfo = typeInfo;
        }

        public void serialize(Edge edge, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeObjectField("id", edge.id());
            GraphSONSerializersV4.writeLabel(jsonGenerator, "label", edge.label());
            GraphSONSerializersV4.writeTypeForGraphObjectIfUntyped(jsonGenerator, this.typeInfo, "edge");
            EdgeJacksonSerializer.writeVertex("inV", edge.inVertex(), jsonGenerator);
            EdgeJacksonSerializer.writeVertex("outV", edge.outVertex(), jsonGenerator);
            this.writeProperties(edge, jsonGenerator);
            jsonGenerator.writeEndObject();
        }

        private static void writeVertex(String vertexDirection, Vertex v, JsonGenerator jsonGenerator) throws IOException {
            jsonGenerator.writeFieldName(vertexDirection);
            jsonGenerator.writeStartObject();
            jsonGenerator.writeObjectField("id", v.id());
            GraphSONSerializersV4.writeLabel(jsonGenerator, "label", v.label());
            jsonGenerator.writeEndObject();
        }

        private void writeProperties(Edge edge, JsonGenerator jsonGenerator) throws IOException {
            Iterator elementProperties;
            Iterator iterator = elementProperties = this.normalize ? IteratorUtils.list(edge.properties(new String[0]), Comparators.PROPERTY_COMPARATOR).iterator() : edge.properties(new String[0]);
            if (elementProperties.hasNext()) {
                jsonGenerator.writeFieldName("properties");
                jsonGenerator.writeStartObject();
                while (elementProperties.hasNext()) {
                    Property prop = elementProperties.next();
                    jsonGenerator.writeFieldName(prop.key());
                    jsonGenerator.writeStartArray();
                    if (this.typeInfo == TypeInfo.NO_TYPES) {
                        jsonGenerator.writeObject(prop.value());
                    } else {
                        jsonGenerator.writeObject(prop);
                    }
                    jsonGenerator.writeEndArray();
                }
                jsonGenerator.writeEndObject();
            }
        }
    }

    static final class VertexJacksonSerializer
    extends StdScalarSerializer<Vertex> {
        private final boolean normalize;
        private final TypeInfo typeInfo;

        public VertexJacksonSerializer(boolean normalize, TypeInfo typeInfo) {
            super(Vertex.class);
            this.normalize = normalize;
            this.typeInfo = typeInfo;
        }

        public void serialize(Vertex vertex, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeObjectField("id", vertex.id());
            GraphSONSerializersV4.writeLabel(jsonGenerator, "label", vertex.label());
            GraphSONSerializersV4.writeTypeForGraphObjectIfUntyped(jsonGenerator, this.typeInfo, "vertex");
            this.writeProperties(vertex, jsonGenerator, serializerProvider);
            jsonGenerator.writeEndObject();
        }

        private void writeProperties(Vertex vertex, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            if (vertex.keys().size() == 0) {
                return;
            }
            jsonGenerator.writeFieldName("properties");
            jsonGenerator.writeStartObject();
            List<String> keys = this.normalize ? IteratorUtils.list(vertex.keys().iterator(), Comparator.naturalOrder()) : new ArrayList<String>(vertex.keys());
            for (String key : keys) {
                Iterator vertexProperties = this.normalize ? IteratorUtils.list(vertex.properties(key), Comparators.PROPERTY_COMPARATOR).iterator() : vertex.properties(key);
                if (!vertexProperties.hasNext()) continue;
                jsonGenerator.writeFieldName(key);
                jsonGenerator.writeStartArray();
                while (vertexProperties.hasNext()) {
                    if (this.typeInfo == TypeInfo.NO_TYPES) {
                        VertexPropertyJacksonSerializer.writeVertexProperty(vertexProperties.next(), jsonGenerator, serializerProvider, this.normalize, false);
                        continue;
                    }
                    jsonGenerator.writeObject(vertexProperties.next());
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
    }
}

