/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server.channel;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpServerKeepAliveHandler;
import io.netty.handler.codec.http.cors.CorsConfigBuilder;
import io.netty.handler.codec.http.cors.CorsHandler;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import org.apache.tinkerpop.gremlin.server.AbstractChannelizer;
import org.apache.tinkerpop.gremlin.server.Settings;
import org.apache.tinkerpop.gremlin.server.auth.AllowAllAuthenticator;
import org.apache.tinkerpop.gremlin.server.handler.AbstractAuthenticationHandler;
import org.apache.tinkerpop.gremlin.server.handler.HttpBasicAuthenticationHandler;
import org.apache.tinkerpop.gremlin.server.handler.HttpBasicAuthorizationHandler;
import org.apache.tinkerpop.gremlin.server.handler.HttpContentCompressionHandler;
import org.apache.tinkerpop.gremlin.server.handler.HttpGremlinEndpointHandler;
import org.apache.tinkerpop.gremlin.server.handler.HttpRequestCheckingHandler;
import org.apache.tinkerpop.gremlin.server.handler.HttpRequestIdHandler;
import org.apache.tinkerpop.gremlin.server.handler.HttpRequestMessageDecoder;
import org.apache.tinkerpop.gremlin.server.handler.HttpUserAgentHandler;
import org.apache.tinkerpop.gremlin.server.util.ServerGremlinExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpChannelizer
extends AbstractChannelizer {
    private static final Logger logger = LoggerFactory.getLogger(HttpChannelizer.class);
    private HttpGremlinEndpointHandler httpGremlinEndpointHandler;
    private HttpRequestCheckingHandler httpRequestCheckingHandler = new HttpRequestCheckingHandler();
    private HttpRequestMessageDecoder httpRequestMessageDecoder = new HttpRequestMessageDecoder(this.serializers);
    private HttpRequestIdHandler httpRequestIdHandler = new HttpRequestIdHandler();
    private HttpContentCompressionHandler httpContentEncoder = new HttpContentCompressionHandler();

    @Override
    public void init(ServerGremlinExecutor serverGremlinExecutor) {
        super.init(serverGremlinExecutor);
        this.httpGremlinEndpointHandler = new HttpGremlinEndpointHandler(this.gremlinExecutor, this.graphManager, this.settings);
    }

    @Override
    public void configure(ChannelPipeline pipeline) {
        if (logger.isDebugEnabled()) {
            pipeline.addLast(new ChannelHandler[]{new LoggingHandler("log-io", LogLevel.DEBUG)});
        }
        pipeline.addLast("http-server", (ChannelHandler)new HttpServerCodec());
        if (logger.isDebugEnabled()) {
            pipeline.addLast(new ChannelHandler[]{new LoggingHandler("http-io", LogLevel.DEBUG)});
        }
        pipeline.addLast("http-requestid-handler", (ChannelHandler)this.httpRequestIdHandler);
        pipeline.addLast("http-keepalive-handler", (ChannelHandler)new HttpServerKeepAliveHandler());
        pipeline.addLast("http-cors-handler", (ChannelHandler)new CorsHandler(CorsConfigBuilder.forAnyOrigin().build()));
        HttpObjectAggregator aggregator = new HttpObjectAggregator(this.settings.maxRequestContentLength);
        aggregator.setMaxCumulationBufferComponents(this.settings.maxAccumulationBufferComponents);
        pipeline.addLast("http-aggregator", (ChannelHandler)aggregator);
        pipeline.addLast("http-request-checker", (ChannelHandler)this.httpRequestCheckingHandler);
        pipeline.addLast("http-user-agent-handler", (ChannelHandler)new HttpUserAgentHandler());
        pipeline.addLast("http-compression-handler", (ChannelHandler)this.httpContentEncoder);
        if (this.authenticator != null) {
            AbstractAuthenticationHandler authenticationHandler;
            AbstractAuthenticationHandler abstractAuthenticationHandler = authenticationHandler = this.authenticator.getClass() == AllowAllAuthenticator.class ? null : this.instantiateAuthenticationHandler(this.settings);
            if (authenticationHandler != null) {
                pipeline.addLast("authenticator", (ChannelHandler)authenticationHandler);
            }
        }
        pipeline.addLast("http-requestmessage-decoder", (ChannelHandler)this.httpRequestMessageDecoder);
        if (this.authorizer != null) {
            HttpBasicAuthorizationHandler authorizationHandler = new HttpBasicAuthorizationHandler(this.authorizer);
            pipeline.addLast("authorizer", (ChannelHandler)authorizationHandler);
        }
        pipeline.addLast("http-gremlin-handler", (ChannelHandler)this.httpGremlinEndpointHandler);
    }

    private AbstractAuthenticationHandler instantiateAuthenticationHandler(Settings settings) {
        String authHandlerClass = settings.authentication.authenticationHandler;
        if (authHandlerClass == null) {
            return new HttpBasicAuthenticationHandler(this.authenticator, this.authorizer, settings);
        }
        return this.createAuthenticationHandler(settings);
    }
}

