/**
 * Represents the response returned from the execution of a Gremlin traversal or script.
 */
export default class ResultSet {
    private readonly items;
    private readonly attributes;
    readonly length: number;
    /**
     * Creates a new instance of {@link ResultSet}.
     * @param {Array} items
     * @param {Map} [attributes]
     */
    constructor(items: any[], attributes: Map<string, any>);
    /**
     * Gets the iterator associated with this instance.
     * @returns {Iterator}
     */
    [Symbol.iterator](): IterableIterator<any>;
    /**
     * Gets an array of result items.
     * @returns {Array}
     */
    toArray(): Array<any>;
    /**
     * Returns the first item.
     * @returns {Object|null}
     */
    first(): any | null;
}
