/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.strategy.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.lambda.AbstractLambdaTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.lambda.ColumnTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.lambda.IdentityTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.lambda.TokenTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.lambda.ValueTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.AndStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.DedupGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.HasStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.IsStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.NotStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.OrStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.RangeGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.TraversalFilterStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.WherePredicateStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.WhereTraversalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.AddEdgeStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.AddVertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.ConstantStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.CountLocalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.DedupLocalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.EdgeOtherVertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.EdgeVertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.ElementMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.ElementStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.IdStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.IndexStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.LabelStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.LambdaMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.LoopsStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.MathStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.MaxLocalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.MeanLocalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.MinLocalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.OrderLocalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.PathStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.ProjectStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.PropertyKeyStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.PropertyMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.PropertyValueStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.RangeLocalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.SackStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.SampleLocalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.SelectOneStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.SelectStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.SumLocalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.TailLocalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.TraversalMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.TraversalSelectStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.IdentityStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.SackValueStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.ReducingBarrierStep;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.T;

public class StepOutputArityPredictor {
    private static final List<Class> STEP_CLASSES_WITH_OPTIONAL_SINGULAR_ARITY_BEHAVIOR = Arrays.asList(HasStep.class, WherePredicateStep.class, AndStep.class, OrStep.class, NotStep.class, IsStep.class, DedupGlobalStep.class, TraversalFilterStep.class, RangeGlobalStep.class, DedupLocalStep.class, ElementStep.class, IndexStep.class, LambdaMapStep.class, LoopsStep.class, MaxLocalStep.class, MeanLocalStep.class, MinLocalStep.class, RangeLocalStep.class, SelectOneStep.class, SelectStep.class, SumLocalStep.class, TailLocalStep.class, WhereTraversalStep.class, TraversalSelectStep.class);
    private static final List<Class> STEP_CLASSES_WITH_DEFINITELY_SINGULAR_ARITY_BEHAVIOR = Arrays.asList(AddEdgeStep.class, AddVertexStep.class, ConstantStep.class, CountLocalStep.class, EdgeOtherVertexStep.class, ElementMapStep.class, IdStep.class, LabelStep.class, MathStep.class, IdentityStep.class, OrderLocalStep.class, PathStep.class, ProjectStep.class, PropertyKeyStep.class, PropertyMapStep.class, PropertyValueStep.class, SackStep.class, SackValueStep.class, SampleLocalStep.class);
    private static final Function<Step, Arity> RETURN_DEFINITELY_SINGLE_ARITY_FOR_STEP_INPUT = step -> Arity.DEFINITELY_SINGULAR;
    private static final Function<Step, Arity> RETURN_MAY_BE_SINGLE_ARITY_FOR_STEP_INPUT = step -> Arity.MAY_BE_SINGULAR;
    private static final Function<Traversal, Arity> RETURN_DEFINITELY_SINGLE_ARITY_FOR_TRAVERSAL_INPUT = step -> Arity.DEFINITELY_SINGULAR;
    private static final Map<String, Function<Step, Arity>> STEP_TO_ARITY_FUNCTION_MAP = new HashMap<String, Function<Step, Arity>>();
    private static final Map<String, Function<Traversal, Arity>> SPECIAL_TRAVERSAL_TO_ARITY_FUNCTION_MAP;

    private static Arity wouldEdgeVertexStepHaveSingleResult(Step<?, ?> step) {
        EdgeVertexStep edgeVertexStep = (EdgeVertexStep)step;
        if (edgeVertexStep.getDirection().equals((Object)Direction.BOTH)) {
            return Arity.MULTI;
        }
        return Arity.MAY_BE_SINGULAR;
    }

    private static Arity getOutputArityBehaviorForValueTraversal(Traversal traversal) {
        ValueTraversal valueTraversal = (ValueTraversal)traversal;
        if (((ValueTraversal)traversal).getPropertyKey().equals(T.id.getAccessor())) {
            return Arity.DEFINITELY_SINGULAR;
        }
        if (((ValueTraversal)traversal).getPropertyKey().equals(T.label.getAccessor())) {
            return STEP_TO_ARITY_FUNCTION_MAP.get(LabelStep.class.getSimpleName()).apply(null);
        }
        return Arity.MULTI;
    }

    private static Arity getOutputArityBehaviorForTraversalMapStep(Step step) {
        if (!(step instanceof TraversalMapStep)) {
            throw new IllegalArgumentException(String.format("Expected TraversalMapStep but got '%s'", step.getClass().getSimpleName()));
        }
        TraversalMapStep mapStep = (TraversalMapStep)step;
        return StepOutputArityPredictor.getOutputArity(mapStep.getLocalChildren().get(0));
    }

    private static Arity getOutputArityBehaviorForTokenTraversal(Traversal traversal) {
        TokenTraversal tokenTraversal = (TokenTraversal)traversal;
        if (tokenTraversal.getToken().equals(T.id)) {
            return Arity.DEFINITELY_SINGULAR;
        }
        if (tokenTraversal.getToken().equals(T.label)) {
            return STEP_TO_ARITY_FUNCTION_MAP.get(LabelStep.class.getSimpleName()).apply(null);
        }
        return Arity.MULTI;
    }

    public static void configureMultiLabelProvider() {
        if (STEP_TO_ARITY_FUNCTION_MAP.containsKey(LabelStep.class.getSimpleName())) {
            STEP_TO_ARITY_FUNCTION_MAP.remove(LabelStep.class.getSimpleName());
        }
        STEP_TO_ARITY_FUNCTION_MAP.put(LabelStep.class.getSimpleName(), Step2 -> Arity.MULTI);
    }

    private static Arity getStepOutputArity(Step step, Arity inputArity) {
        if (step == null) {
            throw new NullPointerException("step is marked non-null but is null");
        }
        String stepName = step.getClass().getSimpleName();
        Arity result = STEP_TO_ARITY_FUNCTION_MAP.containsKey(stepName) ? inputArity.computeArity(STEP_TO_ARITY_FUNCTION_MAP.get(stepName).apply(step)) : (step instanceof ReducingBarrierStep ? inputArity.computeArity(Arity.DEFINITELY_SINGULAR) : Arity.MULTI);
        return result;
    }

    private static Arity getOutputArity(Traversal<?, ?> traversal) {
        if (traversal == null) {
            throw new NullPointerException("traversal is marked non-null but is null");
        }
        return StepOutputArityPredictor.getOutputArity(traversal, Arity.DEFINITELY_SINGULAR);
    }

    private static Arity getOutputArity(Traversal<?, ?> traversal, Arity inputArity) {
        if (traversal == null) {
            throw new NullPointerException("traversal is marked non-null but is null");
        }
        Arity result = inputArity;
        if (traversal instanceof AbstractLambdaTraversal) {
            if (SPECIAL_TRAVERSAL_TO_ARITY_FUNCTION_MAP.containsKey(traversal.getClass().getSimpleName())) {
                result = result.computeArity(SPECIAL_TRAVERSAL_TO_ARITY_FUNCTION_MAP.get(traversal.getClass().getSimpleName()).apply(traversal));
            }
        } else {
            List<Step> steps = traversal.asAdmin().getSteps();
            for (Step step : steps) {
                result = StepOutputArityPredictor.getStepOutputArity(step, result);
            }
            return result;
        }
        return result;
    }

    public static boolean hasSingularOutputArity(Traversal<?, ?> traversal) {
        if (traversal == null) {
            throw new NullPointerException("traversal is marked non-null but is null");
        }
        Arity resultArity = StepOutputArityPredictor.getOutputArity(traversal);
        return resultArity.getPriority() == 1;
    }

    public static boolean hasAlwaysBoundResult(Traversal<?, ?> traversal) {
        if (traversal == null) {
            throw new NullPointerException("traversal is marked non-null but is null");
        }
        Arity resultArity = StepOutputArityPredictor.getOutputArity(traversal);
        return resultArity.equals((Object)Arity.DEFINITELY_SINGULAR);
    }

    public static boolean hasMultiOutputArity(Traversal<?, ?> traversal) {
        if (traversal == null) {
            throw new NullPointerException("traversal is marked non-null but is null");
        }
        Arity resultArity = StepOutputArityPredictor.getOutputArity(traversal);
        return resultArity.getPriority() != 1;
    }

    public static boolean hasSingularOutputArity(Step<?, ?> step) {
        if (step == null) {
            throw new NullPointerException("step is marked non-null but is null");
        }
        Arity resultArity = StepOutputArityPredictor.getStepOutputArity(step, Arity.DEFINITELY_SINGULAR);
        return resultArity.getPriority() == 1;
    }

    public static boolean hasAlwaysBoundResult(Step<?, ?> step) {
        if (step == null) {
            throw new NullPointerException("step is marked non-null but is null");
        }
        Arity resultArity = StepOutputArityPredictor.getStepOutputArity(step, Arity.DEFINITELY_SINGULAR);
        return resultArity.equals((Object)Arity.DEFINITELY_SINGULAR);
    }

    public static boolean hasMultiOutputArity(Step<?, ?> step) {
        if (step == null) {
            throw new NullPointerException("step is marked non-null but is null");
        }
        Arity resultArity = StepOutputArityPredictor.getStepOutputArity(step, Arity.DEFINITELY_SINGULAR);
        return resultArity.getPriority() != 1;
    }

    static {
        for (Class elem : STEP_CLASSES_WITH_DEFINITELY_SINGULAR_ARITY_BEHAVIOR) {
            STEP_TO_ARITY_FUNCTION_MAP.put(elem.getSimpleName(), RETURN_DEFINITELY_SINGLE_ARITY_FOR_STEP_INPUT);
        }
        for (Class elem : STEP_CLASSES_WITH_OPTIONAL_SINGULAR_ARITY_BEHAVIOR) {
            STEP_TO_ARITY_FUNCTION_MAP.put(elem.getSimpleName(), RETURN_MAY_BE_SINGLE_ARITY_FOR_STEP_INPUT);
        }
        STEP_TO_ARITY_FUNCTION_MAP.put(EdgeVertexStep.class.getSimpleName(), StepOutputArityPredictor::wouldEdgeVertexStepHaveSingleResult);
        STEP_TO_ARITY_FUNCTION_MAP.put(TraversalMapStep.class.getSimpleName(), StepOutputArityPredictor::getOutputArityBehaviorForTraversalMapStep);
        SPECIAL_TRAVERSAL_TO_ARITY_FUNCTION_MAP = new HashMap<String, Function<Traversal, Arity>>();
        SPECIAL_TRAVERSAL_TO_ARITY_FUNCTION_MAP.put(ValueTraversal.class.getSimpleName(), StepOutputArityPredictor::getOutputArityBehaviorForValueTraversal);
        SPECIAL_TRAVERSAL_TO_ARITY_FUNCTION_MAP.put(TokenTraversal.class.getSimpleName(), StepOutputArityPredictor::getOutputArityBehaviorForTokenTraversal);
        SPECIAL_TRAVERSAL_TO_ARITY_FUNCTION_MAP.put(IdentityTraversal.class.getSimpleName(), RETURN_DEFINITELY_SINGLE_ARITY_FOR_TRAVERSAL_INPUT);
        SPECIAL_TRAVERSAL_TO_ARITY_FUNCTION_MAP.put(ColumnTraversal.class.getSimpleName(), RETURN_DEFINITELY_SINGLE_ARITY_FOR_TRAVERSAL_INPUT);
    }

    public static enum Arity {
        MAY_BE_SINGULAR(1),
        DEFINITELY_SINGULAR(1),
        MULTI(2);

        private final int priority;

        private Arity(int inputPriority) {
            this.priority = inputPriority;
        }

        public int getPriority() {
            return this.priority;
        }

        public Arity computeArity(Arity operandArity) {
            Arity inputArity = this;
            if (inputArity.getPriority() * operandArity.getPriority() > 1) {
                return MULTI;
            }
            if (inputArity.equals((Object)MAY_BE_SINGULAR) || operandArity.equals((Object)MAY_BE_SINGULAR)) {
                return MAY_BE_SINGULAR;
            }
            return DEFINITELY_SINGULAR;
        }
    }
}

