/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.util.detached;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedElement;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedFactory;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedProperty;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedVertex;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public class DetachedEdge
extends DetachedElement<Edge>
implements Edge {
    private DetachedVertex outVertex;
    private DetachedVertex inVertex;

    private DetachedEdge() {
    }

    protected DetachedEdge(Edge edge, boolean withProperties) {
        super(edge);
        Iterator propertyIterator;
        this.outVertex = DetachedFactory.detach(edge.outVertex(), false);
        this.inVertex = DetachedFactory.detach(edge.inVertex(), false);
        if (withProperties && (propertyIterator = edge.properties(new String[0])).hasNext()) {
            this.properties = new HashMap();
            propertyIterator.forEachRemaining(property -> this.properties.put(property.key(), Collections.singletonList(DetachedFactory.detach(property))));
        }
    }

    public DetachedEdge(Object id, String label, Map<String, Object> properties, Object outVId, String outVLabel, Object inVId, String inVLabel) {
        super(id, label);
        this.outVertex = new DetachedVertex(outVId, outVLabel, Collections.emptyMap());
        this.inVertex = new DetachedVertex(inVId, inVLabel, Collections.emptyMap());
        if (properties != null && !properties.isEmpty()) {
            this.properties = new HashMap();
            properties.entrySet().iterator().forEachRemaining(entry -> {
                if (Property.class.isAssignableFrom(entry.getValue().getClass())) {
                    this.properties.put((String)entry.getKey(), Collections.singletonList((Property)entry.getValue()));
                } else {
                    this.properties.put((String)entry.getKey(), Collections.singletonList(new DetachedProperty((String)entry.getKey(), entry.getValue(), this)));
                }
            });
        }
    }

    public String toString() {
        return StringFactory.edgeString(this);
    }

    @Override
    public Vertex inVertex() {
        return this.inVertex;
    }

    @Override
    public Vertex outVertex() {
        return this.outVertex;
    }

    @Override
    public Iterator<Vertex> vertices(Direction direction) {
        switch (direction) {
            case OUT: {
                return IteratorUtils.of(this.outVertex);
            }
            case IN: {
                return IteratorUtils.of(this.inVertex);
            }
        }
        return IteratorUtils.of(this.outVertex, this.inVertex);
    }

    @Override
    public void remove() {
        throw Edge.Exceptions.edgeRemovalNotSupported();
    }

    @Override
    public <V> Iterator<Property<V>> properties(String ... propertyKeys) {
        return super.properties(propertyKeys);
    }

    @Override
    void internalAddProperty(Property p) {
        if (null == this.properties) {
            this.properties = new HashMap();
        }
        this.properties.put(p.key(), Collections.singletonList(p));
    }

    public static Builder build() {
        return new Builder(new DetachedEdge());
    }

    public static class Builder {
        private DetachedEdge e;

        private Builder(DetachedEdge e) {
            this.e = e;
        }

        public Builder addProperty(Property p) {
            this.e.internalAddProperty(p);
            return this;
        }

        public Builder setId(Object id) {
            this.e.id = id;
            return this;
        }

        public Builder setLabel(String label) {
            this.e.label = label;
            return this;
        }

        public Builder setOutV(DetachedVertex v) {
            this.e.outVertex = v;
            return this;
        }

        public Builder setInV(DetachedVertex v) {
            this.e.inVertex = v;
            return this;
        }

        public DetachedEdge create() {
            return this.e;
        }
    }
}

