/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server.handler;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import org.apache.tinkerpop.gremlin.driver.MessageSerializer;
import org.apache.tinkerpop.gremlin.driver.message.RequestMessage;
import org.apache.tinkerpop.gremlin.driver.ser.SerializationException;
import org.apache.tinkerpop.gremlin.server.handler.ServerSerializers;
import org.apache.tinkerpop.gremlin.server.handler.StateKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class WsGremlinBinaryRequestDecoder
extends MessageToMessageDecoder<BinaryWebSocketFrame> {
    private static final Logger logger = LoggerFactory.getLogger(WsGremlinBinaryRequestDecoder.class);
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private final Map<String, MessageSerializer<?>> serializers;

    public WsGremlinBinaryRequestDecoder(Map<String, MessageSerializer<?>> serializers) {
        this.serializers = serializers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decode(ChannelHandlerContext channelHandlerContext, BinaryWebSocketFrame frame, List<Object> objects) throws Exception {
        ByteBuf messageBytes = frame.content();
        byte len = messageBytes.readByte();
        if (len <= 0) {
            objects.add(RequestMessage.INVALID);
            return;
        }
        ByteBuf contentTypeBytes = channelHandlerContext.alloc().buffer((int)len);
        try {
            messageBytes.readBytes(contentTypeBytes);
            String contentType = contentTypeBytes.toString(UTF8);
            MessageSerializer<?> serializer = this.select(contentType, ServerSerializers.DEFAULT_BINARY_SERIALIZER);
            channelHandlerContext.channel().attr(StateKey.SESSION).set(null);
            channelHandlerContext.channel().attr(StateKey.SERIALIZER).set(serializer);
            channelHandlerContext.channel().attr(StateKey.USE_BINARY).set((Object)true);
            try {
                objects.add(serializer.deserializeRequest(messageBytes.discardReadBytes()));
            }
            catch (SerializationException se) {
                logger.warn("Serialization error while decoding request", (Throwable)se);
                objects.add(RequestMessage.INVALID);
            }
        }
        finally {
            contentTypeBytes.release();
        }
    }

    private MessageSerializer<?> select(String mimeType, MessageSerializer<?> defaultSerializer) {
        if (logger.isWarnEnabled() && !this.serializers.containsKey(mimeType)) {
            logger.warn("Gremlin Server is not configured with a serializer for the requested mime type [{}] - using {} by default", (Object)mimeType, (Object)defaultSerializer.getClass().getName());
        }
        return this.serializers.getOrDefault(mimeType, defaultSerializer);
    }
}

