/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.util.tools;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;

public class CollectionFactory {
    public static <E> List<E> asList(E ... elements) {
        return new ArrayList<E>(Arrays.asList(elements));
    }

    public static <E> LinkedHashSet<E> asSet(E ... elements) {
        return CollectionFactory.asSet(Arrays.asList(elements));
    }

    public static <E> LinkedHashSet<E> asSet(Collection<E> elements) {
        return new LinkedHashSet<E>(elements);
    }

    public static <K, V> LinkedHashMap<K, V> asMap(Object ... elements) {
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
        for (int i = 0; i < elements.length; i += 2) {
            Object k = elements[i];
            Object v = i + 1 < elements.length ? elements[i + 1] : null;
            map.put(k, v);
        }
        return map;
    }
}

